webpackJsonp([3],{

/***/ 372:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__script_total_contents__ = __webpack_require__(373);

new __WEBPACK_IMPORTED_MODULE_0__script_total_contents__["a" /* default */];


/***/ }),

/***/ 373:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Promise) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_jquery__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__app_global__ = __webpack_require__(28);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__attach_data__ = __webpack_require__(47);



var appGlobal = __WEBPACK_IMPORTED_MODULE_1__app_global__["default"].instance;
// #outer-table-of-contents
//   #table-of-contents
//     #total-contents-holder
//       h2
//       ul.menu-content
//         li: p: span: a[href]
//         li
//           p: span:
//             a[href]
//             span.tree-toggle-button
//           ul
//             li
var TotalContents = /** @class */ (function () {
    function TotalContents() {
        var _this = this;
        this.openTargetDic = appGlobal.openTarget;
        this.loadTotalContents()
            .then(function () {
            _this.$holder = __WEBPACK_IMPORTED_MODULE_0_jquery__("#total-contents-holder");
            _this.readyMenuAccordion();
            _this.initMenuMatters();
            __WEBPACK_IMPORTED_MODULE_0_jquery__(document).on("click", ".tree-toggle-button", _this.toggleSubList.bind(_this));
        });
    }
    TotalContents.prototype.loadTotalContents = function () {
        return Object(__WEBPACK_IMPORTED_MODULE_2__attach_data__["default"])(appGlobal.totalContentsFiles)
            .then(function (contents) {
            // 各総目次を結合する
            var totalContents = contents
                .map(function (v) {
                return v
                    .replace(/^<div[^>]*>/, "")
                    .replace(/<\/div>$/, "");
            })
                .join('');
            totalContents
                = totalContents.replace(/\$\(pathToRoot\)/g, appGlobal.pathToRoot);
            var totalContentsHTML = "<div id=\"total-contents-holder\">" + totalContents + "</div>";
            return new Promise(function (resolve, _reject) {
                var totalContentsArea = document.getElementById('table-of-contents');
                if (totalContentsArea instanceof HTMLElement) {
                    totalContentsArea.innerHTML = totalContentsHTML;
                    //console.log("inject total-content at earlyer.");
                    resolve();
                }
                else {
                    document.addEventListener('DOMContentLoaded', function () {
                        var totalContentsArea = document.getElementById('table-of-contents');
                        if (!(totalContentsArea instanceof HTMLElement)) {
                            console.log("Fail to catch 'table-of-contents' element.");
                            return;
                        }
                        totalContentsArea.innerHTML = totalContentsHTML;
                        //console.log("inject total-content at waiting loaded.");
                        resolve();
                    }, false);
                }
            });
        });
    };
    // 初期化する
    TotalContents.prototype.readyMenuAccordion = function () {
        var _this = this;
        var $h2 = this.$holder.find('h2');
        $h2.addClass('clickable');
        $h2.each(function (idx, elm) {
            __WEBPACK_IMPORTED_MODULE_0_jquery__(elm).attr('data-menu-order', idx * 2);
            __WEBPACK_IMPORTED_MODULE_0_jquery__(elm).next('ul')
                .attr('data-menu-order', idx * 2 + 1)
                .addClass('total-contents-list');
        });
        Object.keys(appGlobal.totalContentsColor).forEach(function (key) {
            var color = appGlobal.totalContentsColor[key];
            _this.$holder.find('>h2[id="' + key + '"]')
                .css('border-left-color', color);
        });
        __WEBPACK_IMPORTED_MODULE_0_jquery__(document).on("click", "#table-of-contents h2", this.toggleMenuAccordion.bind(this));
        this.openParentMenu();
    };
    // クリックしたヘッダの配下リストを開閉する
    TotalContents.prototype.toggleMenuAccordion = function (ev, is_force_open) {
        var $currentTarget = __WEBPACK_IMPORTED_MODULE_0_jquery__(ev.currentTarget);
        if (__WEBPACK_IMPORTED_MODULE_0_jquery__("+ul", $currentTarget).length) {
            var $hd = $currentTarget;
            var $ul = $currentTarget.next('ul');
            this.reorderMenuItems();
            this.$holder.prepend($ul);
            this.$holder.prepend($hd);
            var is_invisible = !$ul.is(":visible");
            this.$holder.find("h2+ul:visible").hide();
            if (is_force_open) {
                $ul.show();
                if (!/style:\s*block/.test($ul.attr('style'))) {
                    $ul.attr('style', 'display: block;');
                }
            }
            else {
                $ul.toggle(!!is_invisible);
            }
            this.$holder.find("h2.current-header")
                .removeClass("current-header");
            $hd.addClass('current-header');
            __WEBPACK_IMPORTED_MODULE_0_jquery__("#table-of-contents").scrollTop(0);
        }
    };
    TotalContents.prototype.openParentMenu = function () {
        var title = __WEBPACK_IMPORTED_MODULE_0_jquery__("title").text();
        var fullTitle = appGlobal.pageInfo.fulltitle;
        var res = title.match(/§\s*(.*?)(\s*▶|$)/);
        var k = "";
        if (res) {
            k = res[1];
        }
        var menuString = this.openTargetDic[k];
        for (var _i = 0, _a = Object.keys(this.openTargetDic); _i < _a.length; _i++) {
            var sectionKey = _a[_i];
            if (fullTitle.startsWith(sectionKey + ">>")) {
                menuString = this.openTargetDic[sectionKey];
                break;
            }
        }
        if (!menuString) {
            menuString = this.openTargetDic[""];
        }
        // console.log('現在の主カテゴリー: ', str );
        // 該当ヘッダを選択
        var hd = __WEBPACK_IMPORTED_MODULE_0_jquery__("#table-of-contents h2")
            .filter(function () { return __WEBPACK_IMPORTED_MODULE_0_jquery__(this).text() == menuString; });
        // メニューを開く
        hd.trigger('click', [true]);
        //console.log(hd);
    };
    // メニューを初期状態と同じ並びに戻す。
    TotalContents.prototype.reorderMenuItems = function () {
        this.$holder.append(this.$holder
            .children()
            .sort(function (a, b) {
            var a_order = parseInt(__WEBPACK_IMPORTED_MODULE_0_jquery__(a).attr('data-menu-order'));
            var b_order = parseInt(__WEBPACK_IMPORTED_MODULE_0_jquery__(b).attr('data-menu-order'));
            var ret = a_order - b_order;
            return ret;
        }));
    };
    // メニューの子リストを開閉可能するための初期化
    TotalContents.prototype.initMenuMatters = function () {
        // 子リストが、4つ以上の項目を持つ項目は開閉可能にする
        // これ以下は開閉しない
        var ignoreChildNum = appGlobal.unclosableCount;
        // 該当する見出しは開閉しない
        // 書式は "book//page"： book == 親 h2 見出しのテキスト
        //                    ： page == リスト項目のテキスト
        var ignoreTitles = appGlobal.unclosableTitles;
        var button = __WEBPACK_IMPORTED_MODULE_0_jquery__["parseHTML"]('<span class="tree-toggle-button"></span>');
        var docPath = __WEBPACK_IMPORTED_MODULE_0_jquery__('body').attr('data-document-path');
        var rootPos = appGlobal.pathToRoot;
        var currentSigil = rootPos + docPath + '.html';
        //console.log('currentSigil', currentSigil);
        // 下位リストの項目数が ignoreChildNum より大きい LI のみ集める。
        var $closableLI = __WEBPACK_IMPORTED_MODULE_0_jquery__('#table-of-contents > div > ul > li:has(ul>li:eq(' + ignoreChildNum + '))');
        // 集めた LI から、指定タイトル（ルールブック//タイトル）に合致するものを除外
        $closableLI = $closableLI.filter(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            var title = $this.find('>p>span').text();
            var book = $this.closest('ul').prev('h2').text();
            return ignoreTitles.indexOf(book + '//' + title) >= 0 ? false : true;
        });
        // 現在ページに対するリンク
        var $currentPageItem = __WEBPACK_IMPORTED_MODULE_0_jquery__('#table-of-contents > div > ul span:has(a[href="' + currentSigil + '"])');
        // 現在ページの項目を強調するクラスを設定
        $currentPageItem.addClass('current-path');
        // 開閉ボタンを追加
        $closableLI.find('> p > span')
            .each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            $this.append(__WEBPACK_IMPORTED_MODULE_0_jquery__(button).clone());
        });
        // 現在のページの項目を含むリスト以外全て閉じる
        $closableLI
            .not(':has(a[href="' + currentSigil + '"])')
            .children('ul')
            .addClass('hidable')
            .hide();
        $closableLI
            .has('a[href="' + currentSigil + '"]')
            .addClass('current-path-list')
            .find('.tree-toggle-button')
            .addClass('tree-opened');
    };
    // 子リストを開閉する
    TotalContents.prototype.toggleSubList = function (e) {
        var $clicked = __WEBPACK_IMPORTED_MODULE_0_jquery__(e.currentTarget); // クリックした開閉ボタン
        var $currentSubList = $clicked.closest('li').children('ul');
        var $allTreeToggleButton = this.$holder.find('.tree-toggle-button');
        $allTreeToggleButton.removeClass('tree-opened');
        var $visibleLists = __WEBPACK_IMPORTED_MODULE_0_jquery__('#table-of-contents > div > ul > li > ul.hidable:visible');
        $visibleLists
            .not($currentSubList)
            .hide();
        if ($currentSubList.is(':visible')) {
            $currentSubList.hide();
        }
        else {
            $currentSubList.fadeIn();
            $clicked.addClass('tree-opened');
            //console.log($clicked.offset());
            if (appGlobal.isMobileMode()) {
                var topPos = $clicked.offset().top;
                __WEBPACK_IMPORTED_MODULE_0_jquery__('#table-of-contents').get(0).scrollTop += topPos;
            }
        }
        this.$holder
            .find('.current-path-list:has(>ul:visible)')
            .find('.tree-toggle-button')
            .addClass('tree-opened');
    };
    return TotalContents;
}());
/* harmony default export */ __webpack_exports__["a"] = (TotalContents);

/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(48)))

/***/ })

},[372]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9zcmMvYXBwL2lnbml0ZS50b3RhbC1jb250ZW50cy50cyIsIndlYnBhY2s6Ly8vLi9zcmMvYXBwL3NjcmlwdC90b3RhbC1jb250ZW50cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7OztBQUFvRDtBQUNwRCxJQUFJLHVFQUFhLENBQUM7Ozs7Ozs7Ozs7Ozs7QUNEVTtBQUNTO0FBQ0U7QUFFdkMsSUFBSSxTQUFTLEdBQUcsb0RBQVMsQ0FBQyxRQUFRLENBQUM7QUFFbkMsMkJBQTJCO0FBQzNCLHVCQUF1QjtBQUN2Qiw2QkFBNkI7QUFDN0IsV0FBVztBQUNYLHdCQUF3QjtBQUN4QiwrQkFBK0I7QUFDL0IsYUFBYTtBQUNiLHFCQUFxQjtBQUNyQixzQkFBc0I7QUFDdEIsc0NBQXNDO0FBQ3RDLGVBQWU7QUFDZixpQkFBaUI7QUFFakI7SUFLSTtRQUFBLGlCQVdDO1FBZEQsa0JBQWEsR0FBRyxTQUFTLENBQUMsVUFBVSxDQUFDO1FBSWpDLElBQUksQ0FBQyxpQkFBaUIsRUFBRTthQUN2QixJQUFJLENBQUM7WUFDRixLQUFJLENBQUMsT0FBTyxHQUFHLG9DQUFDLENBQUMsd0JBQXdCLENBQUMsQ0FBQztZQUMzQyxLQUFJLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztZQUMxQixLQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7WUFDdkIsb0NBQUMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLENBQ1YsT0FBTyxFQUNQLHFCQUFxQixFQUNyQixLQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxLQUFJLENBQUMsQ0FBRSxDQUFDO1FBQ3hDLENBQUMsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztJQUVELHlDQUFpQixHQUFqQjtRQUdJLE1BQU0sQ0FBQyw2REFBVSxDQUFTLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQzthQUN0RCxJQUFJLENBQUMsVUFBQyxRQUFrQjtZQUVyQixZQUFZO1lBQ1osSUFBSSxhQUFhLEdBQUcsUUFBUTtpQkFDdkIsR0FBRyxDQUFDLFVBQUMsQ0FBQztnQkFDSCxNQUFNLENBQUMsQ0FBQztxQkFDSCxPQUFPLENBQUMsYUFBYSxFQUFFLEVBQUUsQ0FBQztxQkFDMUIsT0FBTyxDQUFDLFVBQVUsRUFBRSxFQUFFLENBQUM7WUFDaEMsQ0FBQyxDQUFDO2lCQUNELElBQUksQ0FBQyxFQUFFLENBQUMsQ0FDWjtZQUVELGFBQWE7a0JBQ1AsYUFBYSxDQUFDLE9BQU8sQ0FDbkIsbUJBQW1CLEVBQUUsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1lBQ25ELElBQUksaUJBQWlCLEdBQ2YsdUNBQW1DLGFBQWEsV0FBUSxDQUFDO1lBRS9ELE1BQU0sQ0FBQyxJQUFJLE9BQU8sQ0FBTyxVQUFVLE9BQU8sRUFBRSxPQUFPO2dCQUUvQyxJQUFJLGlCQUFpQixHQUNmLFFBQVEsQ0FBQyxjQUFjLENBQUMsbUJBQW1CLENBQUMsQ0FBQztnQkFDbkQsRUFBRSxFQUFFLGlCQUFpQixZQUFZLFdBQVksQ0FBQyxDQUM5QyxDQUFDO29CQUNHLGlCQUFpQixDQUFDLFNBQVMsR0FBRyxpQkFBaUIsQ0FBQztvQkFFaEQsa0RBQWtEO29CQUNsRCxPQUFPLEVBQUUsQ0FBQztnQkFDZCxDQUFDO2dCQUNELElBQUksQ0FDSixDQUFDO29CQUNHLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxrQkFBa0IsRUFBRTt3QkFDMUMsSUFBSSxpQkFBaUIsR0FDZixRQUFRLENBQUMsY0FBYyxDQUFDLG1CQUFtQixDQUFDLENBQUM7d0JBQ25ELEVBQUUsRUFBQyxDQUFDLENBQUUsaUJBQWlCLFlBQVksV0FBVyxDQUFFLENBQUMsQ0FDakQsQ0FBQzs0QkFDRyxPQUFPLENBQUMsR0FBRyxDQUFDLDRDQUE0QyxDQUFDLENBQUM7NEJBQzFELE1BQU0sQ0FBQzt3QkFDWCxDQUFDO3dCQUVELGlCQUFpQixDQUFDLFNBQVMsR0FBRyxpQkFBaUIsQ0FBQzt3QkFFaEQseURBQXlEO3dCQUN6RCxPQUFPLEVBQUUsQ0FBQztvQkFDZCxDQUFDLEVBQUUsS0FBSyxDQUFDLENBQUM7Z0JBQ2QsQ0FBQztZQUNMLENBQUMsQ0FBQyxDQUFDO1FBQ1AsQ0FBQyxDQUFDLENBQUM7SUFDUCxDQUFDO0lBRUQsUUFBUTtJQUNSLDBDQUFrQixHQUFsQjtRQUFBLGlCQXlCQztRQXhCRyxJQUFJLEdBQUcsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNsQyxHQUFHLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQzFCLEdBQUcsQ0FBQyxJQUFJLENBQUMsVUFBUyxHQUFHLEVBQUUsR0FBRztZQUN0QixvQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLEdBQUcsQ0FBQyxDQUFDLENBQUM7WUFDeEMsb0NBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2lCQUNaLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztpQkFDcEMsUUFBUSxDQUFDLHFCQUFxQixDQUFDLENBQ25DO1FBQ0wsQ0FBQyxDQUFDLENBQUM7UUFFSCxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxVQUFDLEdBQUc7WUFDbEQsSUFBSSxLQUFLLEdBQUcsU0FBUyxDQUFDLGtCQUFrQixDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQzlDLEtBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFVBQVUsR0FBQyxHQUFHLEdBQUMsSUFBSSxDQUFDO2lCQUNqQyxHQUFHLENBQUMsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDekMsQ0FBQyxDQUFDLENBQUM7UUFFSCxvQ0FBQyxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQUUsQ0FDVixPQUFPLEVBQ1AsdUJBQXVCLEVBQ3ZCLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQ3RDLENBQUM7UUFFRixJQUFJLENBQUMsY0FBYyxFQUFFLENBQUM7SUFFMUIsQ0FBQztJQUVELHVCQUF1QjtJQUN2QiwyQ0FBbUIsR0FBbkIsVUFBcUIsRUFBYyxFQUFFLGFBQXNCO1FBRXZELElBQUksY0FBYyxHQUFHLG9DQUFDLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ3pDLEVBQUUsRUFBRSxvQ0FBQyxDQUFDLEtBQUssRUFBRSxjQUFjLENBQUMsQ0FBQyxNQUFPLENBQUMsRUFBQztZQUNsQyxJQUFJLEdBQUcsR0FBRyxjQUFjLENBQUM7WUFDekIsSUFBSSxHQUFHLEdBQUcsY0FBYyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUVwQyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztZQUV4QixJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUMxQixJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUUxQixJQUFJLFlBQVksR0FBRyxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLENBQUU7WUFDeEMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUMsSUFBSSxFQUFFLENBQUM7WUFDMUMsRUFBRSxFQUFFLGFBQWMsQ0FBQyxFQUFDO2dCQUNoQixHQUFHLENBQUMsSUFBSSxFQUFFLENBQUM7Z0JBQ1gsRUFBRSxFQUFFLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFFLEdBQUcsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUcsQ0FBQyxDQUNqRCxDQUFDO29CQUNHLEdBQUcsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLGlCQUFpQixDQUFDLENBQUM7Z0JBQ3pDLENBQUM7WUFDTCxDQUFDO1lBQ0QsSUFBSSxDQUFDLENBQUM7Z0JBQ0YsR0FBRyxDQUFDLE1BQU0sQ0FBRSxDQUFDLENBQUMsWUFBWSxDQUFFO1lBQ2hDLENBQUM7WUFDRCxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztpQkFDakMsV0FBVyxDQUFDLGdCQUFnQixDQUFDLENBQUM7WUFDbkMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1lBRS9CLG9DQUFDLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDekMsQ0FBQztJQUNMLENBQUM7SUFFRCxzQ0FBYyxHQUFkO1FBQ0ksSUFBSSxLQUFLLEdBQUcsb0NBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQztRQUM5QixJQUFJLFNBQVMsR0FBRyxTQUFTLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQztRQUM3QyxJQUFJLEdBQUcsR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDLG1CQUFtQixDQUFFLENBQUU7UUFDN0MsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBQ1gsRUFBRSxFQUFFLEdBQUksQ0FBQyxFQUFDO1lBQ04sQ0FBQyxHQUFHLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNmLENBQUM7UUFDRCxJQUFJLFVBQVUsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBRXZDLEdBQUcsRUFBb0IsVUFBK0IsRUFBL0IsV0FBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLEVBQS9CLGNBQStCLEVBQS9CLElBQStCO1lBQWpELElBQUksVUFBVTtZQUVmLEVBQUUsRUFBRSxTQUFTLENBQUMsVUFBVSxDQUFJLFVBQVUsT0FBSSxDQUFFLENBQUMsQ0FDN0MsQ0FBQztnQkFDRyxVQUFVLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxVQUFVLENBQUMsQ0FBQztnQkFDNUMsS0FBSyxDQUFDO1lBQ1YsQ0FBQztTQUNKO1FBRUQsRUFBRSxFQUFFLENBQUMsVUFBVyxDQUFDLENBQ2pCLENBQUM7WUFDRyxVQUFVLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUN4QyxDQUFDO1FBR0Qsb0NBQW9DO1FBRXBDLFdBQVc7UUFDWCxJQUFJLEVBQUUsR0FBRyxvQ0FBQyxDQUFDLHVCQUF1QixDQUFDO2FBQzlCLE1BQU0sQ0FBQyxjQUE0QixNQUFNLENBQUMsb0NBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLEVBQUUsSUFBSSxVQUFVLEdBQUMsQ0FBQyxDQUFDO1FBRTlFLFVBQVU7UUFDVixFQUFFLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7UUFDNUIsa0JBQWtCO0lBQ3RCLENBQUM7SUFFRCxxQkFBcUI7SUFDckIsd0NBQWdCLEdBQWhCO1FBQ0ksSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBRWYsSUFBSSxDQUFDLE9BQU87YUFDWCxRQUFRLEVBQUU7YUFDVixJQUFJLENBQUMsVUFBQyxDQUFjLEVBQUUsQ0FBYztZQUNqQyxJQUFJLE9BQU8sR0FBRyxRQUFRLENBQUMsb0NBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsQ0FBQztZQUNwRCxJQUFJLE9BQU8sR0FBRyxRQUFRLENBQUMsb0NBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO1lBQ3JELElBQUksR0FBRyxHQUFHLE9BQU8sR0FBRyxPQUFPLENBQUM7WUFDNUIsTUFBTSxDQUFDLEdBQUcsQ0FBQztRQUNmLENBQUMsQ0FBQyxDQUNMLENBQUM7SUFDTixDQUFDO0lBRUQseUJBQXlCO0lBQ3pCLHVDQUFlLEdBQWY7UUFDSSw2QkFBNkI7UUFDN0IsYUFBYTtRQUNiLElBQUksY0FBYyxHQUFHLFNBQVMsQ0FBQyxlQUFlLENBQUU7UUFDaEQsZ0JBQWdCO1FBQ2hCLDBDQUEwQztRQUMxQywwQ0FBMEM7UUFDMUMsSUFBSSxZQUFZLEdBQUcsU0FBUyxDQUFDLGdCQUFnQixDQUFDO1FBQzlDLElBQUksTUFBTSxHQUFHLGlEQUFXLENBQUMsMENBQTBDLENBQUMsQ0FBQztRQUNyRSxJQUFJLE9BQU8sR0FBRyxvQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1FBQ25ELElBQUksT0FBTyxHQUFHLFNBQVMsQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxZQUFZLEdBQUcsT0FBTyxHQUFHLE9BQU8sR0FBRyxPQUFPLENBQUM7UUFDL0MsNENBQTRDO1FBRTVDLDRDQUE0QztRQUM1QyxJQUFJLFdBQVcsR0FDWCxvQ0FBQyxDQUFDLGtEQUFrRCxHQUFDLGNBQWMsR0FBQyxJQUFJLENBQUM7UUFFN0UsMkNBQTJDO1FBQzNDLFdBQVcsR0FBRyxXQUFXLENBQUMsTUFBTSxDQUFDO1lBQzdCLElBQUksS0FBSyxHQUFHLG9DQUFDLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDcEIsSUFBSSxLQUFLLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUN6QyxJQUFJLElBQUksR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUNqRCxNQUFNLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUUsSUFBSSxHQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUU7UUFDeEUsQ0FBQyxDQUFDLENBQUM7UUFFSCxlQUFlO1FBQ2YsSUFBSSxnQkFBZ0IsR0FBRyxvQ0FBQyxDQUNwQixpREFBaUQsR0FBQyxZQUFZLEdBQUMsS0FBSyxDQUN2RSxDQUFDO1FBRUYsc0JBQXNCO1FBQ3RCLGdCQUFnQixDQUFDLFFBQVEsQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUUxQyxXQUFXO1FBQ1gsV0FBVyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7YUFDekIsSUFBSSxDQUFDO1lBQ0YsSUFBSSxLQUFLLEdBQUcsb0NBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUNwQixLQUFLLENBQUMsTUFBTSxDQUFDLG9DQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUNwQyxDQUFDLENBQUMsQ0FBQztRQUNQLHlCQUF5QjtRQUN6QixXQUFXO2FBQ04sR0FBRyxDQUFDLGVBQWUsR0FBQyxZQUFZLEdBQUMsS0FBSyxDQUFDO2FBQ3ZDLFFBQVEsQ0FBQyxJQUFJLENBQUM7YUFDZCxRQUFRLENBQUMsU0FBUyxDQUFDO2FBQ25CLElBQUksRUFBRSxDQUFDO1FBQ1osV0FBVzthQUNOLEdBQUcsQ0FBQyxVQUFVLEdBQUMsWUFBWSxHQUFDLElBQUksQ0FBQzthQUNqQyxRQUFRLENBQUMsbUJBQW1CLENBQUM7YUFDN0IsSUFBSSxDQUFDLHFCQUFxQixDQUFDO2FBQzNCLFFBQVEsQ0FBQyxhQUFhLENBQUMsQ0FDM0I7SUFFTCxDQUFDO0lBRUQsWUFBWTtJQUNaLHFDQUFhLEdBQWIsVUFBZSxDQUFhO1FBQ3hCLElBQUksUUFBUSxHQUFHLG9DQUFDLENBQUMsQ0FBQyxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsY0FBYztRQUNqRCxJQUFJLGVBQWUsR0FBRyxRQUFRLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUU1RCxJQUFJLG9CQUFvQixHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLENBQUM7UUFDcEUsb0JBQW9CLENBQUMsV0FBVyxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBRWhELElBQUksYUFBYSxHQUNiLG9DQUFDLENBQUMseURBQXlELENBQUMsQ0FBQztRQUVqRSxhQUFhO2FBQ1IsR0FBRyxDQUFDLGVBQWUsQ0FBQzthQUNwQixJQUFJLEVBQUUsQ0FBQztRQUVaLEVBQUUsRUFBRSxlQUFlLENBQUMsRUFBRSxDQUFDLFVBQVUsQ0FBRSxDQUFDLEVBQUM7WUFDakMsZUFBZSxDQUFDLElBQUksRUFBRTtRQUMxQixDQUFDO1FBQ0QsSUFBSSxDQUFDLENBQUM7WUFDRixlQUFlLENBQUMsTUFBTSxFQUFFLENBQUU7WUFDMUIsUUFBUSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUNqQyxpQ0FBaUM7WUFDakMsRUFBRSxFQUFDLFNBQVMsQ0FBQyxZQUFZLEVBQUUsQ0FBQyxFQUFDO2dCQUN6QixJQUFJLE1BQU0sR0FBVyxRQUFRLENBQUMsTUFBTSxFQUFFLENBQUMsR0FBRyxDQUFDO2dCQUMzQyxvQ0FBQyxDQUFDLG9CQUFvQixDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsSUFBSSxNQUFNLENBQUM7WUFDdkQsQ0FBQztRQUNMLENBQUM7UUFFRCxJQUFJLENBQUMsT0FBTzthQUNQLElBQUksQ0FBQyxxQ0FBcUMsQ0FBQzthQUMzQyxJQUFJLENBQUMscUJBQXFCLENBQUM7YUFDM0IsUUFBUSxDQUFDLGFBQWEsQ0FBQyxDQUMzQjtJQUVMLENBQUM7SUFDTCxvQkFBQztBQUFELENBQUMiLCJmaWxlIjoiaWduaXRlLnRvdGFsLWNvbnRlbnRzLmJuZC5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBUb3RhbENvbnRlbnRzIGZyb20gJy4vc2NyaXB0L3RvdGFsLWNvbnRlbnRzJztcbm5ldyBUb3RhbENvbnRlbnRzO1xuXG5cblxuLy8gV0VCUEFDSyBGT09URVIgLy9cbi8vIC4vc3JjL2FwcC9pZ25pdGUudG90YWwtY29udGVudHMudHMiLCJpbXBvcnQgKiBhcyAkIGZyb20gJ2pxdWVyeSc7XG5pbXBvcnQgQXBwR2xvYmFsIGZyb20gJy4vYXBwLWdsb2JhbCc7XG5pbXBvcnQgYXR0YWNoRGF0YSBmcm9tICcuL2F0dGFjaC1kYXRhJztcblxubGV0IGFwcEdsb2JhbCA9IEFwcEdsb2JhbC5pbnN0YW5jZTtcblxuLy8gI291dGVyLXRhYmxlLW9mLWNvbnRlbnRzXG4vLyAgICN0YWJsZS1vZi1jb250ZW50c1xuLy8gICAgICN0b3RhbC1jb250ZW50cy1ob2xkZXJcbi8vICAgICAgIGgyXG4vLyAgICAgICB1bC5tZW51LWNvbnRlbnRcbi8vICAgICAgICAgbGk6IHA6IHNwYW46IGFbaHJlZl1cbi8vICAgICAgICAgbGlcbi8vICAgICAgICAgICBwOiBzcGFuOlxuLy8gICAgICAgICAgICAgYVtocmVmXVxuLy8gICAgICAgICAgICAgc3Bhbi50cmVlLXRvZ2dsZS1idXR0b25cbi8vICAgICAgICAgICB1bFxuLy8gICAgICAgICAgICAgbGlcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgVG90YWxDb250ZW50cyB7XG5cbiAgICBvcGVuVGFyZ2V0RGljID0gYXBwR2xvYmFsLm9wZW5UYXJnZXQ7XG4gICAgJGhvbGRlcjogSlF1ZXJ5OyAvLyAjdG90YWwtY29udGVudHMtaG9sZGVyXG5cbiAgICBjb25zdHJ1Y3RvciAoKSB7XG4gICAgICAgIHRoaXMubG9hZFRvdGFsQ29udGVudHMoKVxuICAgICAgICAudGhlbigoKSA9PiB7XG4gICAgICAgICAgICB0aGlzLiRob2xkZXIgPSAkKFwiI3RvdGFsLWNvbnRlbnRzLWhvbGRlclwiKTtcbiAgICAgICAgICAgIHRoaXMucmVhZHlNZW51QWNjb3JkaW9uKCk7XG4gICAgICAgICAgICB0aGlzLmluaXRNZW51TWF0dGVycygpO1xuICAgICAgICAgICAgJChkb2N1bWVudCkub24oXG4gICAgICAgICAgICAgICAgXCJjbGlja1wiLFxuICAgICAgICAgICAgICAgIFwiLnRyZWUtdG9nZ2xlLWJ1dHRvblwiLFxuICAgICAgICAgICAgICAgIHRoaXMudG9nZ2xlU3ViTGlzdC5iaW5kKHRoaXMpICk7XG4gICAgICAgIH0pO1xuICAgIH1cblxuICAgIGxvYWRUb3RhbENvbnRlbnRzKClcbiAgICA6IFByb21pc2U8dm9pZD5cbiAgICB7XG4gICAgICAgIHJldHVybiBhdHRhY2hEYXRhPHN0cmluZz4oYXBwR2xvYmFsLnRvdGFsQ29udGVudHNGaWxlcylcbiAgICAgICAgLnRoZW4oKGNvbnRlbnRzOiBzdHJpbmdbXSk9PntcblxuICAgICAgICAgICAgLy8g5ZCE57eP55uu5qyh44KS57WQ5ZCI44GZ44KLXG4gICAgICAgICAgICBsZXQgdG90YWxDb250ZW50cyA9IGNvbnRlbnRzXG4gICAgICAgICAgICAgICAgLm1hcCgodik9PntcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHZcbiAgICAgICAgICAgICAgICAgICAgICAgIC5yZXBsYWNlKC9ePGRpdltePl0qPi8sIFwiXCIpXG4gICAgICAgICAgICAgICAgICAgICAgICAucmVwbGFjZSgvPFxcL2Rpdj4kLywgXCJcIilcbiAgICAgICAgICAgICAgICB9KVxuICAgICAgICAgICAgICAgIC5qb2luKCcnKVxuICAgICAgICAgICAgO1xuXG4gICAgICAgICAgICB0b3RhbENvbnRlbnRzXG4gICAgICAgICAgICAgICAgPSB0b3RhbENvbnRlbnRzLnJlcGxhY2UoXG4gICAgICAgICAgICAgICAgICAgIC9cXCRcXChwYXRoVG9Sb290XFwpL2csIGFwcEdsb2JhbC5wYXRoVG9Sb290KTtcbiAgICAgICAgICAgIGxldCB0b3RhbENvbnRlbnRzSFRNTFxuICAgICAgICAgICAgICAgID0gYDxkaXYgaWQ9XCJ0b3RhbC1jb250ZW50cy1ob2xkZXJcIj4ke3RvdGFsQ29udGVudHN9PC9kaXY+YDtcblxuICAgICAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlPHZvaWQ+KGZ1bmN0aW9uKCByZXNvbHZlLCBfcmVqZWN0KXtcblxuICAgICAgICAgICAgICAgIGxldCB0b3RhbENvbnRlbnRzQXJlYVxuICAgICAgICAgICAgICAgICAgICA9IGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCd0YWJsZS1vZi1jb250ZW50cycpO1xuICAgICAgICAgICAgICAgIGlmKCB0b3RhbENvbnRlbnRzQXJlYSBpbnN0YW5jZW9mIEhUTUxFbGVtZW50IClcbiAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgIHRvdGFsQ29udGVudHNBcmVhLmlubmVySFRNTCA9IHRvdGFsQ29udGVudHNIVE1MO1xuXG4gICAgICAgICAgICAgICAgICAgIC8vY29uc29sZS5sb2coXCJpbmplY3QgdG90YWwtY29udGVudCBhdCBlYXJseWVyLlwiKTtcbiAgICAgICAgICAgICAgICAgICAgcmVzb2x2ZSgpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBlbHNlXG4gICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICBkb2N1bWVudC5hZGRFdmVudExpc3RlbmVyKCdET01Db250ZW50TG9hZGVkJywgKCk9PntcbiAgICAgICAgICAgICAgICAgICAgICAgIGxldCB0b3RhbENvbnRlbnRzQXJlYVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgID0gZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoJ3RhYmxlLW9mLWNvbnRlbnRzJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICBpZighKCB0b3RhbENvbnRlbnRzQXJlYSBpbnN0YW5jZW9mIEhUTUxFbGVtZW50ICkpXG4gICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29uc29sZS5sb2coXCJGYWlsIHRvIGNhdGNoICd0YWJsZS1vZi1jb250ZW50cycgZWxlbWVudC5cIik7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICB0b3RhbENvbnRlbnRzQXJlYS5pbm5lckhUTUwgPSB0b3RhbENvbnRlbnRzSFRNTDtcblxuICAgICAgICAgICAgICAgICAgICAgICAgLy9jb25zb2xlLmxvZyhcImluamVjdCB0b3RhbC1jb250ZW50IGF0IHdhaXRpbmcgbG9hZGVkLlwiKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJlc29sdmUoKTtcbiAgICAgICAgICAgICAgICAgICAgfSwgZmFsc2UpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9XG5cbiAgICAvLyDliJ3mnJ/ljJbjgZnjgotcbiAgICByZWFkeU1lbnVBY2NvcmRpb24gKCkge1xuICAgICAgICBsZXQgJGgyID0gdGhpcy4kaG9sZGVyLmZpbmQoJ2gyJyk7XG4gICAgICAgICRoMi5hZGRDbGFzcygnY2xpY2thYmxlJyk7XG4gICAgICAgICRoMi5lYWNoKGZ1bmN0aW9uKGlkeCwgZWxtKXtcbiAgICAgICAgICAgICQoZWxtKS5hdHRyKCdkYXRhLW1lbnUtb3JkZXInLCBpZHggKiAyKTtcbiAgICAgICAgICAgICQoZWxtKS5uZXh0KCd1bCcpXG4gICAgICAgICAgICAgICAgLmF0dHIoJ2RhdGEtbWVudS1vcmRlcicsIGlkeCAqIDIgKyAxKVxuICAgICAgICAgICAgICAgIC5hZGRDbGFzcygndG90YWwtY29udGVudHMtbGlzdCcpXG4gICAgICAgICAgICA7XG4gICAgICAgIH0pO1xuXG4gICAgICAgIE9iamVjdC5rZXlzKGFwcEdsb2JhbC50b3RhbENvbnRlbnRzQ29sb3IpLmZvckVhY2goKGtleSk9PntcbiAgICAgICAgICAgIGxldCBjb2xvciA9IGFwcEdsb2JhbC50b3RhbENvbnRlbnRzQ29sb3Jba2V5XTtcbiAgICAgICAgICAgIHRoaXMuJGhvbGRlci5maW5kKCc+aDJbaWQ9XCInK2tleSsnXCJdJylcbiAgICAgICAgICAgICAgICAuY3NzKCdib3JkZXItbGVmdC1jb2xvcicsIGNvbG9yKTtcbiAgICAgICAgfSk7XG5cbiAgICAgICAgJChkb2N1bWVudCkub24oXG4gICAgICAgICAgICBcImNsaWNrXCIsXG4gICAgICAgICAgICBcIiN0YWJsZS1vZi1jb250ZW50cyBoMlwiLFxuICAgICAgICAgICAgdGhpcy50b2dnbGVNZW51QWNjb3JkaW9uLmJpbmQodGhpcylcbiAgICAgICAgKTtcblxuICAgICAgICB0aGlzLm9wZW5QYXJlbnRNZW51KCk7XG5cbiAgICB9XG5cbiAgICAvLyDjgq/jg6rjg4Pjgq/jgZfjgZ/jg5jjg4Pjg4Djga7phY3kuIvjg6rjgrnjg4jjgpLplovplonjgZnjgotcbiAgICB0b2dnbGVNZW51QWNjb3JkaW9uIChldjogTW91c2VFdmVudCwgaXNfZm9yY2Vfb3BlbjogYm9vbGVhbikge1xuXG4gICAgICAgIHZhciAkY3VycmVudFRhcmdldCA9ICQoZXYuY3VycmVudFRhcmdldCk7XG4gICAgICAgIGlmKCAkKFwiK3VsXCIsICRjdXJyZW50VGFyZ2V0KS5sZW5ndGggKXtcbiAgICAgICAgICAgIHZhciAkaGQgPSAkY3VycmVudFRhcmdldDtcbiAgICAgICAgICAgIHZhciAkdWwgPSAkY3VycmVudFRhcmdldC5uZXh0KCd1bCcpO1xuXG4gICAgICAgICAgICB0aGlzLnJlb3JkZXJNZW51SXRlbXMoKTtcblxuICAgICAgICAgICAgdGhpcy4kaG9sZGVyLnByZXBlbmQoJHVsKTtcbiAgICAgICAgICAgIHRoaXMuJGhvbGRlci5wcmVwZW5kKCRoZCk7XG5cbiAgICAgICAgICAgIHZhciBpc19pbnZpc2libGUgPSAhJHVsLmlzKFwiOnZpc2libGVcIikgO1xuICAgICAgICAgICAgdGhpcy4kaG9sZGVyLmZpbmQoXCJoMit1bDp2aXNpYmxlXCIpLmhpZGUoKTtcbiAgICAgICAgICAgIGlmKCBpc19mb3JjZV9vcGVuICl7XG4gICAgICAgICAgICAgICAgJHVsLnNob3coKTtcbiAgICAgICAgICAgICAgICBpZiggIS9zdHlsZTpcXHMqYmxvY2svLnRlc3QoICR1bC5hdHRyKCdzdHlsZScpICkgKVxuICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgJHVsLmF0dHIoJ3N0eWxlJywgJ2Rpc3BsYXk6IGJsb2NrOycpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgICAgICR1bC50b2dnbGUoICEhaXNfaW52aXNpYmxlIClcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHRoaXMuJGhvbGRlci5maW5kKFwiaDIuY3VycmVudC1oZWFkZXJcIilcbiAgICAgICAgICAgICAgICAucmVtb3ZlQ2xhc3MoXCJjdXJyZW50LWhlYWRlclwiKTtcbiAgICAgICAgICAgICRoZC5hZGRDbGFzcygnY3VycmVudC1oZWFkZXInKTtcblxuICAgICAgICAgICAgJChcIiN0YWJsZS1vZi1jb250ZW50c1wiKS5zY3JvbGxUb3AoMCk7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBvcGVuUGFyZW50TWVudSAoKSB7XG4gICAgICAgIHZhciB0aXRsZSA9ICQoXCJ0aXRsZVwiKS50ZXh0KCk7XG4gICAgICAgIHZhciBmdWxsVGl0bGUgPSBhcHBHbG9iYWwucGFnZUluZm8uZnVsbHRpdGxlO1xuICAgICAgICB2YXIgcmVzID0gdGl0bGUubWF0Y2goL8KnXFxzKiguKj8pKFxccyrilrZ8JCkvICkgO1xuICAgICAgICB2YXIgayA9IFwiXCI7XG4gICAgICAgIGlmKCByZXMgKXtcbiAgICAgICAgICAgIGsgPSByZXNbMV07XG4gICAgICAgIH1cbiAgICAgICAgdmFyIG1lbnVTdHJpbmcgPSB0aGlzLm9wZW5UYXJnZXREaWNba107XG5cbiAgICAgICAgZm9yKCBsZXQgc2VjdGlvbktleSBvZiBPYmplY3Qua2V5cyh0aGlzLm9wZW5UYXJnZXREaWMpIClcbiAgICAgICAge1xuICAgICAgICAgICAgaWYoIGZ1bGxUaXRsZS5zdGFydHNXaXRoKGAke3NlY3Rpb25LZXl9Pj5gKSApXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgbWVudVN0cmluZyA9IHRoaXMub3BlblRhcmdldERpY1tzZWN0aW9uS2V5XTtcbiAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIGlmKCAhbWVudVN0cmluZyApXG4gICAgICAgIHtcbiAgICAgICAgICAgIG1lbnVTdHJpbmcgPSB0aGlzLm9wZW5UYXJnZXREaWNbXCJcIl07XG4gICAgICAgIH1cblxuXG4gICAgICAgIC8vIGNvbnNvbGUubG9nKCfnj77lnKjjga7kuLvjgqvjg4bjgrTjg6rjg7w6ICcsIHN0ciApO1xuXG4gICAgICAgIC8vIOipsuW9k+ODmOODg+ODgOOCkumBuOaKnlxuICAgICAgICB2YXIgaGQgPSAkKFwiI3RhYmxlLW9mLWNvbnRlbnRzIGgyXCIpXG4gICAgICAgICAgICAuZmlsdGVyKGZ1bmN0aW9uKHRoaXM6IEhUTUxFbGVtZW50KXtyZXR1cm4gJCh0aGlzKS50ZXh0KCkgPT0gbWVudVN0cmluZ30pO1xuXG4gICAgICAgIC8vIOODoeODi+ODpeODvOOCkumWi+OBj1xuICAgICAgICBoZC50cmlnZ2VyKCdjbGljaycsIFt0cnVlXSk7XG4gICAgICAgIC8vY29uc29sZS5sb2coaGQpO1xuICAgIH1cblxuICAgIC8vIOODoeODi+ODpeODvOOCkuWIneacn+eKtuaFi+OBqOWQjOOBmOS4puOBs+OBq+aIu+OBmeOAglxuICAgIHJlb3JkZXJNZW51SXRlbXMgKCkge1xuICAgICAgICB0aGlzLiRob2xkZXIuYXBwZW5kXG4gICAgICAgIChcbiAgICAgICAgICAgIHRoaXMuJGhvbGRlclxuICAgICAgICAgICAgLmNoaWxkcmVuKClcbiAgICAgICAgICAgIC5zb3J0KChhOiBIVE1MRWxlbWVudCwgYjogSFRNTEVsZW1lbnQpID0+IHtcbiAgICAgICAgICAgICAgICB2YXIgYV9vcmRlciA9IHBhcnNlSW50KCQoYSkuYXR0cignZGF0YS1tZW51LW9yZGVyJykpXG4gICAgICAgICAgICAgICAgdmFyIGJfb3JkZXIgPSBwYXJzZUludCgkKGIpLmF0dHIoJ2RhdGEtbWVudS1vcmRlcicpKTtcbiAgICAgICAgICAgICAgICB2YXIgcmV0ID0gYV9vcmRlciAtIGJfb3JkZXI7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHJldDtcbiAgICAgICAgICAgIH0pXG4gICAgICAgICk7XG4gICAgfVxuXG4gICAgLy8g44Oh44OL44Ol44O844Gu5a2Q44Oq44K544OI44KS6ZaL6ZaJ5Y+v6IO944GZ44KL44Gf44KB44Gu5Yid5pyf5YyWXG4gICAgaW5pdE1lbnVNYXR0ZXJzICgpIHtcbiAgICAgICAgLy8g5a2Q44Oq44K544OI44GM44CBNOOBpOS7peS4iuOBrumgheebruOCkuaMgeOBpOmgheebruOBr+mWi+mWieWPr+iDveOBq+OBmeOCi1xuICAgICAgICAvLyDjgZPjgozku6XkuIvjga/plovplonjgZfjgarjgYRcbiAgICAgICAgbGV0IGlnbm9yZUNoaWxkTnVtID0gYXBwR2xvYmFsLnVuY2xvc2FibGVDb3VudCA7XG4gICAgICAgIC8vIOipsuW9k+OBmeOCi+imi+WHuuOBl+OBr+mWi+mWieOBl+OBquOBhFxuICAgICAgICAvLyDmm7jlvI/jga8gXCJib29rLy9wYWdlXCLvvJogYm9vayA9PSDopqogaDIg6KaL5Ye644GX44Gu44OG44Kt44K544OIXG4gICAgICAgIC8vICAgICAgICAgICAgICAgICAgICDvvJogcGFnZSA9PSDjg6rjgrnjg4jpoIXnm67jga7jg4bjgq3jgrnjg4hcbiAgICAgICAgbGV0IGlnbm9yZVRpdGxlcyA9IGFwcEdsb2JhbC51bmNsb3NhYmxlVGl0bGVzO1xuICAgICAgICBsZXQgYnV0dG9uID0gJC5wYXJzZUhUTUwoJzxzcGFuIGNsYXNzPVwidHJlZS10b2dnbGUtYnV0dG9uXCI+PC9zcGFuPicpO1xuICAgICAgICBsZXQgZG9jUGF0aCA9ICQoJ2JvZHknKS5hdHRyKCdkYXRhLWRvY3VtZW50LXBhdGgnKTtcbiAgICAgICAgbGV0IHJvb3RQb3MgPSBhcHBHbG9iYWwucGF0aFRvUm9vdDtcbiAgICAgICAgbGV0IGN1cnJlbnRTaWdpbCA9IHJvb3RQb3MgKyBkb2NQYXRoICsgJy5odG1sJztcbiAgICAgICAgLy9jb25zb2xlLmxvZygnY3VycmVudFNpZ2lsJywgY3VycmVudFNpZ2lsKTtcblxuICAgICAgICAvLyDkuIvkvY3jg6rjgrnjg4jjga7poIXnm67mlbDjgYwgaWdub3JlQ2hpbGROdW0g44KI44KK5aSn44GN44GEIExJIOOBruOBv+mbhuOCgeOCi+OAglxuICAgICAgICBsZXQgJGNsb3NhYmxlTEkgPVxuICAgICAgICAgICAgJCgnI3RhYmxlLW9mLWNvbnRlbnRzID4gZGl2ID4gdWwgPiBsaTpoYXModWw+bGk6ZXEoJytpZ25vcmVDaGlsZE51bSsnKSknKVxuXG4gICAgICAgIC8vIOmbhuOCgeOBnyBMSSDjgYvjgonjgIHmjIflrprjgr/jgqTjg4jjg6vvvIjjg6vjg7zjg6vjg5bjg4Pjgq8vL+OCv+OCpOODiOODq++8ieOBq+WQiOiHtOOBmeOCi+OCguOBruOCkumZpOWkllxuICAgICAgICAkY2xvc2FibGVMSSA9ICRjbG9zYWJsZUxJLmZpbHRlcihmdW5jdGlvbih0aGlzOiBIVE1MRWxlbWVudCl7XG4gICAgICAgICAgICBsZXQgJHRoaXMgPSAkKHRoaXMpO1xuICAgICAgICAgICAgbGV0IHRpdGxlID0gJHRoaXMuZmluZCgnPnA+c3BhbicpLnRleHQoKTtcbiAgICAgICAgICAgIGxldCBib29rID0gJHRoaXMuY2xvc2VzdCgndWwnKS5wcmV2KCdoMicpLnRleHQoKTtcbiAgICAgICAgICAgIHJldHVybiBpZ25vcmVUaXRsZXMuaW5kZXhPZihib29rICsnLy8nKyB0aXRsZSkgPj0gMCA/IGZhbHNlIDogdHJ1ZSA7XG4gICAgICAgIH0pO1xuXG4gICAgICAgIC8vIOePvuWcqOODmuODvOOCuOOBq+WvvuOBmeOCi+ODquODs+OCr1xuICAgICAgICBsZXQgJGN1cnJlbnRQYWdlSXRlbSA9ICQoXG4gICAgICAgICAgICAnI3RhYmxlLW9mLWNvbnRlbnRzID4gZGl2ID4gdWwgc3BhbjpoYXMoYVtocmVmPVwiJytjdXJyZW50U2lnaWwrJ1wiXSknXG4gICAgICAgICk7XG5cbiAgICAgICAgLy8g54++5Zyo44Oa44O844K444Gu6aCF55uu44KS5by36Kq/44GZ44KL44Kv44Op44K544KS6Kit5a6aXG4gICAgICAgICRjdXJyZW50UGFnZUl0ZW0uYWRkQ2xhc3MoJ2N1cnJlbnQtcGF0aCcpO1xuXG4gICAgICAgIC8vIOmWi+mWieODnOOCv+ODs+OCkui/veWKoFxuICAgICAgICAkY2xvc2FibGVMSS5maW5kKCc+IHAgPiBzcGFuJylcbiAgICAgICAgICAgIC5lYWNoKGZ1bmN0aW9uKHRoaXM6IEhUTUxFbGVtZW50KXtcbiAgICAgICAgICAgICAgICBsZXQgJHRoaXMgPSAkKHRoaXMpO1xuICAgICAgICAgICAgICAgICR0aGlzLmFwcGVuZCgkKGJ1dHRvbikuY2xvbmUoKSk7XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgLy8g54++5Zyo44Gu44Oa44O844K444Gu6aCF55uu44KS5ZCr44KA44Oq44K544OI5Lul5aSW5YWo44Gm6ZaJ44GY44KLXG4gICAgICAgICRjbG9zYWJsZUxJXG4gICAgICAgICAgICAubm90KCc6aGFzKGFbaHJlZj1cIicrY3VycmVudFNpZ2lsKydcIl0pJylcbiAgICAgICAgICAgIC5jaGlsZHJlbigndWwnKVxuICAgICAgICAgICAgLmFkZENsYXNzKCdoaWRhYmxlJylcbiAgICAgICAgICAgIC5oaWRlKCk7XG4gICAgICAgICRjbG9zYWJsZUxJXG4gICAgICAgICAgICAuaGFzKCdhW2hyZWY9XCInK2N1cnJlbnRTaWdpbCsnXCJdJylcbiAgICAgICAgICAgIC5hZGRDbGFzcygnY3VycmVudC1wYXRoLWxpc3QnKVxuICAgICAgICAgICAgLmZpbmQoJy50cmVlLXRvZ2dsZS1idXR0b24nKVxuICAgICAgICAgICAgLmFkZENsYXNzKCd0cmVlLW9wZW5lZCcpXG4gICAgICAgIDtcblxuICAgIH1cblxuICAgIC8vIOWtkOODquOCueODiOOCkumWi+mWieOBmeOCi1xuICAgIHRvZ2dsZVN1Ykxpc3QgKGU6IE1vdXNlRXZlbnQpIHtcbiAgICAgICAgbGV0ICRjbGlja2VkID0gJChlLmN1cnJlbnRUYXJnZXQpOyAvLyDjgq/jg6rjg4Pjgq/jgZfjgZ/plovplonjg5zjgr/jg7NcbiAgICAgICAgbGV0ICRjdXJyZW50U3ViTGlzdCA9ICRjbGlja2VkLmNsb3Nlc3QoJ2xpJykuY2hpbGRyZW4oJ3VsJyk7XG5cbiAgICAgICAgbGV0ICRhbGxUcmVlVG9nZ2xlQnV0dG9uID0gdGhpcy4kaG9sZGVyLmZpbmQoJy50cmVlLXRvZ2dsZS1idXR0b24nKTtcbiAgICAgICAgJGFsbFRyZWVUb2dnbGVCdXR0b24ucmVtb3ZlQ2xhc3MoJ3RyZWUtb3BlbmVkJyk7XG5cbiAgICAgICAgbGV0ICR2aXNpYmxlTGlzdHMgPVxuICAgICAgICAgICAgJCgnI3RhYmxlLW9mLWNvbnRlbnRzID4gZGl2ID4gdWwgPiBsaSA+IHVsLmhpZGFibGU6dmlzaWJsZScpO1xuXG4gICAgICAgICR2aXNpYmxlTGlzdHNcbiAgICAgICAgICAgIC5ub3QoJGN1cnJlbnRTdWJMaXN0KVxuICAgICAgICAgICAgLmhpZGUoKTtcblxuICAgICAgICBpZiggJGN1cnJlbnRTdWJMaXN0LmlzKCc6dmlzaWJsZScpICl7XG4gICAgICAgICAgICAkY3VycmVudFN1Ykxpc3QuaGlkZSgpXG4gICAgICAgIH1cbiAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAkY3VycmVudFN1Ykxpc3QuZmFkZUluKCkgO1xuICAgICAgICAgICAgJGNsaWNrZWQuYWRkQ2xhc3MoJ3RyZWUtb3BlbmVkJyk7XG4gICAgICAgICAgICAvL2NvbnNvbGUubG9nKCRjbGlja2VkLm9mZnNldCgpKTtcbiAgICAgICAgICAgIGlmKGFwcEdsb2JhbC5pc01vYmlsZU1vZGUoKSl7XG4gICAgICAgICAgICAgICAgbGV0IHRvcFBvczogbnVtYmVyID0gJGNsaWNrZWQub2Zmc2V0KCkudG9wO1xuICAgICAgICAgICAgICAgICQoJyN0YWJsZS1vZi1jb250ZW50cycpLmdldCgwKS5zY3JvbGxUb3AgKz0gdG9wUG9zO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgdGhpcy4kaG9sZGVyXG4gICAgICAgICAgICAuZmluZCgnLmN1cnJlbnQtcGF0aC1saXN0Omhhcyg+dWw6dmlzaWJsZSknKVxuICAgICAgICAgICAgLmZpbmQoJy50cmVlLXRvZ2dsZS1idXR0b24nKVxuICAgICAgICAgICAgLmFkZENsYXNzKCd0cmVlLW9wZW5lZCcpXG4gICAgICAgIDtcblxuICAgIH1cbn1cblxuXG5cbi8vIFdFQlBBQ0sgRk9PVEVSIC8vXG4vLyAuL3NyYy9hcHAvc2NyaXB0L3RvdGFsLWNvbnRlbnRzLnRzIl0sInNvdXJjZVJvb3QiOiIifQ==