webpackJsonp([2],{

/***/ 380:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__special_subject_index__ = __webpack_require__(381);

(new __WEBPACK_IMPORTED_MODULE_0__special_subject_index__["a" /* default */]()).run();


/***/ }),

/***/ 381:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_jquery__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__script_app_global__ = __webpack_require__(28);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__script_attach_data__ = __webpack_require__(47);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__script_search_pattern__ = __webpack_require__(58);




var appGlobal = __WEBPACK_IMPORTED_MODULE_1__script_app_global__["default"].instance;
function isTargetContentName(name) {
    return /^(?:feat|spell|spell-list|magic-item|monster)$/.test(name);
}
function isSpellIndex(index) {
    return !index.length || index[0].subject == "SPELL";
}
function isMagicItemIndex(index) {
    return !index.length || index[0].subject == "MAGIC_ITEM";
}
function isFeatIndex(index) {
    return !index.length || index[0].subject == "FEAT";
}
function isMonsterIndex(index) {
    return !index.length || index[0].subject == "MONSTER";
}
var KANA_LINES = 'アカサタナハマヤラワ'.split('');
var INITIAL_TO_KANA_LINE = {
    'ア': 'ア', 'イ': 'ア', 'ウ': 'ア', 'エ': 'ア', 'オ': 'ア',
    'カ': 'カ', 'キ': 'カ', 'ク': 'カ', 'ケ': 'カ', 'コ': 'カ',
    'サ': 'サ', 'シ': 'サ', 'ス': 'サ', 'セ': 'サ', 'ソ': 'サ',
    'タ': 'タ', 'チ': 'タ', 'ツ': 'タ', 'テ': 'タ', 'ト': 'タ',
    'ナ': 'ナ', 'ニ': 'ナ', 'ヌ': 'ナ', 'ネ': 'ナ', 'ノ': 'ナ',
    'ハ': 'ハ', 'ヒ': 'ハ', 'フ': 'ハ', 'ヘ': 'ハ', 'ホ': 'ハ',
    'マ': 'マ', 'ミ': 'マ', 'ム': 'マ', 'メ': 'マ', 'モ': 'マ',
    'ヤ': 'ヤ', 'ユ': 'ヤ', 'ヨ': 'ヤ',
    'ラ': 'ラ', 'リ': 'ラ', 'ル': 'ラ', 'レ': 'ラ', 'ロ': 'ラ',
    'ワ': 'ワ', 'ヲ': 'ワ', 'ン': 'ワ'
};
var SCHOOL_ORDER = ['幻術', '召喚術', '死霊術', '心術', '占術', '変成術', '防御術', '力術', '総合術'];
function initScreenElements() {
    // 初期化：ラベル内の input にチェックがあるものに、checked クラスを付ける
    __WEBPACK_IMPORTED_MODULE_0_jquery__('#filter-setting label > input:checked').each(function () {
        __WEBPACK_IMPORTED_MODULE_0_jquery__(this).parent().addClass('checked');
    });
    // 索引カテゴリーの変更
    // ラベル内の input のチェック状態に合わせて checked クラスを切り替える
    __WEBPACK_IMPORTED_MODULE_0_jquery__('#filter-setting').on('change', 'label > input', function () {
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#filter-setting label > input').each(function () {
            var $input = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            var $label = $input.parent();
            if ($input.prop('checked')) {
                $label.addClass('checked');
            }
            else {
                $label.removeClass('checked');
            }
        });
    });
    // ラベルをダブルクリックした場合
    __WEBPACK_IMPORTED_MODULE_0_jquery__('#filter-setting').on('dblclick', 'label', function () {
        var $label = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
        var $chk = $label.find('>:input:checkbox');
        if (!$chk.length)
            return true;
        $label.closest('fieldset')
            .find(':input:checkbox')
            .prop('checked', false)
            .parent().removeClass('checked');
        $label.children(':input:checkbox')
            .prop('checked', true).change();
        return;
    });
    // 全選択ボタン
    __WEBPACK_IMPORTED_MODULE_0_jquery__('#filter-setting').on('click', 'button.all-check', function () {
        var $btn = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
        $btn.closest('fieldset')
            .find(':input:checkbox')
            .each(function () {
            __WEBPACK_IMPORTED_MODULE_0_jquery__(this).parent().addClass('checked');
            __WEBPACK_IMPORTED_MODULE_0_jquery__(this).prop('checked', true);
        });
        $btn.closest('fieldset').change();
    });
    // 全解除ボタン
    __WEBPACK_IMPORTED_MODULE_0_jquery__('#filter-setting').on('click', 'button.all-checkoff', function () {
        var $btn = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
        $btn.closest('fieldset')
            .find(':input:checkbox:checked')
            .each(function () {
            __WEBPACK_IMPORTED_MODULE_0_jquery__(this).parent().removeClass('checked');
            __WEBPACK_IMPORTED_MODULE_0_jquery__(this).prop('checked', false);
        });
        $btn.closest('fieldset').change();
    });
    // 折畳みのタイトル
    __WEBPACK_IMPORTED_MODULE_0_jquery__('#filter-setting').on('click', '.foldupper-title', function () {
        var $title = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
        __WEBPACK_IMPORTED_MODULE_0_jquery__('.foldupper-title').removeClass('selected');
        $title.addClass('selected');
        var $content = __WEBPACK_IMPORTED_MODULE_0_jquery__('[data-foldupper-content="' + $title.attr('data-foldupper-for') + '"]');
        if (!$content.hasClass('hidden')) {
            $content.addClass('hidden');
        }
        else {
            __WEBPACK_IMPORTED_MODULE_0_jquery__('.foldupper-content').addClass('hidden');
            $content.removeClass('hidden');
        }
    });
    // 折畳みボタン
    __WEBPACK_IMPORTED_MODULE_0_jquery__('#filter-setting').on('click', '.fold-button, .fold-button+h4', function () {
        var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
        $this.parent().toggleClass('folded');
    });
}
function kanaOrderSort(a, b) { return a.order < b.order ? -1 : a.order > b.order ? 1 : 0; }
var SubjectIndex = /** @class */ (function () {
    function SubjectIndex() {
    }
    SubjectIndex.prototype.run = function () {
        initScreenElements();
        appGlobal.loadStylesheet('subject-index');
        var files = appGlobal.subjectIndexFiles;
        var indexes;
        Object(__WEBPACK_IMPORTED_MODULE_2__script_attach_data__["default"])(files)
            .then(function (args) {
            indexes = Object.assign.apply({}, args);
            //console.log(indexes);
            (new SubjectIndexList(indexes)).run();
        });
    };
    return SubjectIndex;
}());
/* harmony default export */ __webpack_exports__["a"] = (SubjectIndex);
var SubjectIndexList = /** @class */ (function () {
    function SubjectIndexList(indexes) {
        this.indexes = indexes;
        this.validSourceBooks = {
            "MAGIC_ITEM": [],
            "SPELL": [],
            "MONSTER": [],
            "FEAT": [],
        };
        this.isBuildedMonsterClassField = false;
        this.filteredIndex = [];
        this._tabularListCondition = {
            'spell-list': {
                order: { sortOrder: 2, sortDirect: 'ascending' },
                level: { sortOrder: 1, sortDirect: 'ascending' },
            },
            'feat': {
                order: { sortOrder: 1, sortDirect: 'ascending' },
            },
            'magic-item': {
                order: { sortOrder: 1, sortDirect: 'ascending' },
            },
            'monster': {
                order: { sortOrder: 1, sortDirect: 'ascending' },
            },
            'spell': {
                order: { sortOrder: 1, sortDirect: 'ascending' },
            },
        };
        this._tabularListCache = {
            'feat': [],
            'spell': [],
            'spell-list': [],
            'magic-item': [],
            'monster': [],
        };
        this.hideRequirementCell = true;
        this.spellLevelMemo = {};
        this.spellListData = {
            classSpell: {},
            bonusSpell: {},
        };
        this.spellLevelRe = /$^/;
        this.isReadiedCasterClassFields = false;
        this.preProcIndex();
    }
    /** 索引データをあらかじめ処理する */
    SubjectIndexList.prototype.preProcIndex = function () {
        this.indexes['MAGIC_ITEM'] = this.indexes['MAGIC_ITEM']
            .filter(function (item) { return !(item.childs && item.childs.length); })
            .filter(function (item) { return item.category != 'INTELLIGENT'; })
            .sort(kanaOrderSort);
    };
    /** 実行する */
    SubjectIndexList.prototype.run = function () {
        var self = this;
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#filter-setting').on('change', '#target-subject :input', function () {
            self.initializeIndexList();
        });
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#filter-setting').on('change', '.filter-fields', function () {
            self.initializeIndexList();
        });
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#magicitem-tabular-show-requirement').on('change', function (ev) {
            self.toggleTabularMagicItemRequirementCell(ev);
        });
        __WEBPACK_IMPORTED_MODULE_0_jquery__('[name="magicitem-tabular-limit"]').on('change', function () {
            self.limitTabularMagicItemQuantity();
        });
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#text-filter').on('input', function () {
            self.setNarrowingPattern(this.value);
            self.narrowItemsByTextFilter();
            self.displayList();
        })
            .each(function () {
            self.setNarrowingPattern(this.value);
        });
        this.initializeIndexList();
    };
    SubjectIndexList.prototype.lookListingMethod = function () {
        var listingMethod = __WEBPACK_IMPORTED_MODULE_0_jquery__('#monster-order-method :input:checked[name="listing-method"]').val();
        return listingMethod;
    };
    /** 表示を変える */
    SubjectIndexList.prototype.changeVisual = function (ev) {
        var t = ev.target;
        if (t.value == 'show-requirement') {
            if (t.checked) {
                __WEBPACK_IMPORTED_MODULE_0_jquery__('.subject-index-table').removeClass('hide-requirement');
            }
            else {
                __WEBPACK_IMPORTED_MODULE_0_jquery__('.subject-index-table').addClass('hide-requirement');
            }
        }
    };
    SubjectIndexList.prototype.limitTabularMagicItemQuantity = function () {
        this.redrawTabularList();
    };
    SubjectIndexList.prototype.toggleTabularMagicItemRequirementCell = function (ev) {
        var t = ev.target;
        if (t.checked) {
            __WEBPACK_IMPORTED_MODULE_0_jquery__('.subject-index-table').removeClass('hide-requirement');
        }
        else {
            __WEBPACK_IMPORTED_MODULE_0_jquery__('.subject-index-table').addClass('hide-requirement');
        }
    };
    /** 一覧をクリアし、選択の状態に合わせ再表示する
    */
    SubjectIndexList.prototype.initializeIndexList = function () {
        __WEBPACK_IMPORTED_MODULE_0_jquery__('section[id^="initial-"] ul').empty();
        __WEBPACK_IMPORTED_MODULE_0_jquery__('.selectable-fields').hide();
        this.applyListType('normal-list');
        var targetContent = __WEBPACK_IMPORTED_MODULE_0_jquery__(':input:checked[name="target-subject"]').val();
        if (!isTargetContentName(targetContent))
            throw new Error("\"" + targetContent + "\" isn't TargetContentName.");
        this.targetContent = targetContent;
        // 条件フィールドを設定
        this.initializeFilterField(targetContent);
        // 一覧を表示
        if (targetContent == 'feat') {
            this.showFeats();
        }
        else if (targetContent == 'spell') {
            this.showSpells();
        }
        else if (targetContent == 'spell-list') {
            this.showSpellList();
        }
        else if (targetContent == 'magic-item') {
            this.showMagicItems();
        }
        else if (targetContent == 'monster') {
            this.showMonsters();
        }
    };
    /** 結果リストの種類を設定
    */
    SubjectIndexList.prototype.applyListType = function (type) {
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#entry-list').attr('data-list-type', type);
    };
    SubjectIndexList.prototype.fetchEntryListByType = function (type) {
        return __WEBPACK_IMPORTED_MODULE_0_jquery__('#entry-list[data-list-type="' + type + '"]');
    };
    /** フィルター操作の領域を、表示対象に合わせて初期化
    */
    SubjectIndexList.prototype.initializeFilterField = function (targetContent) {
        if (targetContent == 'feat') {
            this.currentIndexName = 'FEAT';
            __WEBPACK_IMPORTED_MODULE_0_jquery__('[data-subject~="feat"]').show();
        }
        else if (targetContent == 'spell') {
            this.currentIndexName = 'SPELL';
            __WEBPACK_IMPORTED_MODULE_0_jquery__('[data-subject~="spell"]').show();
        }
        else if (targetContent == 'spell-list') {
            this.currentIndexName = 'SPELL';
            //this.readyClassFilterFields();
            __WEBPACK_IMPORTED_MODULE_0_jquery__('[data-subject~="spelllist"]').show();
            var selectedCaster = __WEBPACK_IMPORTED_MODULE_0_jquery__('#caster-class-fields :input:checked').val();
            __WEBPACK_IMPORTED_MODULE_0_jquery__('[data-visible-caster]').hide();
            __WEBPACK_IMPORTED_MODULE_0_jquery__('[data-visible-caster="' + selectedCaster + '"]').show();
        }
        else if (targetContent == 'magic-item') {
            this.currentIndexName = 'MAGIC_ITEM';
            var isTabular = __WEBPACK_IMPORTED_MODULE_0_jquery__('#magicitem-display-mode-fields input:checked').val() == 'table';
            __WEBPACK_IMPORTED_MODULE_0_jquery__('#magicitem-display-item-fields').toggleClass('hide-fields', !isTabular);
            __WEBPACK_IMPORTED_MODULE_0_jquery__('[data-subject~="MAGIC_ITEM"]').show();
        }
        else if (targetContent == 'monster') {
            this.currentIndexName = 'MONSTER';
            __WEBPACK_IMPORTED_MODULE_0_jquery__('[data-subject~="MONSTER"]').show();
        }
        this.currentIndex = this.indexes[this.currentIndexName];
        this.hideUnvalidSourceBook();
    };
    /** 項目グループで不要な出典の選択肢を非表示にする
    */
    SubjectIndexList.prototype.hideUnvalidSourceBook = function () {
        var self = this;
        var indexName = this.currentIndexName;
        this.readyValidSouceBooks(indexName);
        //console.log('XXX', this.validSourceBooks);
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#source-book-fieldset>label').each(function () {
            var $label = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            var $input = $label.children('input:eq(0)');
            if (self.validSourceBooks[indexName].includes($input.val())) {
                $label.show();
            }
            else {
                $label.hide();
            }
        });
    };
    /** モンスターで使う、クラス選択を作成 */
    SubjectIndexList.prototype.buildMonsterClassInput = function () {
        var targetIndex = this.indexes.MONSTER;
        var classCheck = {};
        targetIndex
            .forEach(function (monster) {
            monster.classes.forEach(function (cls) {
                classCheck[cls] = true;
            });
        });
        var classes = Object.keys(classCheck).sort();
        var tmpl = '<label><input name="creature-class" value="{cls}"   type="checkbox"> {cls}</label>\n';
        var inputs = classes.map(function (cls) {
            return tmpl.replace(/\{cls\}/g, cls);
        }).join('');
        __WEBPACK_IMPORTED_MODULE_0_jquery__('[data-foldupper-content="creature-class"] > fieldset').prepend(inputs);
        this.isBuildedMonsterClassField = true;
    };
    /** モンスターの一覧を表示
    */
    SubjectIndexList.prototype.showMonsters = function () {
        //フォームを作成
        //if(!this.isBuildedMonsterClassField){
        //    this.buildMonsterClassInput();
        //}
        //if(this.currentIndexName != "MONSTER")
        //    throw new Error("Invalid target! expected 'MONSTER', but not.");
        var targetIndex = this.indexes.MONSTER;
        //targetIndex.sort(function(a,b){ return a.order < b.order ? -1 : a.order > b.order ? 1 : 0 });
        var sourceBookDic = this._createSouceBookFilterDic();
        var creatureTypeDic = this._createCreatureTypeFilterDic();
        var creatureSubtypeDic = this._createCreatureSubtypeFilterDic();
        var terrainDic = this._createTerrainFilterDic();
        var climateDic = this._createClimateFilterDic();
        var challengeRatingDic = this._createChallengeRatingFilterDic();
        var creatureClassDic = this._createCreatureClassFilterDic();
        var creatureSizeDic = this._createCreatureSizeFilterDic();
        var alignmentDic = this._createAlignmentFilterDic();
        var alignmentRx = new RegExp(Object.keys(alignmentDic).join('|'));
        var isAvailCreatureSubtypeDic = Object.keys(creatureSubtypeDic).length;
        //let isAvailAlignmentDic = Object.keys( alignmentDic ).length;
        var isAvailTerrainDic = Object.keys(terrainDic).length;
        var isAvailClimateDic = Object.keys(climateDic).length;
        var isAvailCreatureClassDic = Object.keys(creatureClassDic).length;
        this.filteredIndex = targetIndex.filter(function (v) {
            return sourceBookDic[v.source]
                && creatureTypeDic[v.type]
                && challengeRatingDic[v.cr_text]
                && creatureSizeDic[v.size]
                && (!alignmentDic
                    || alignmentRx.test(v.alignment_mark))
                && (!isAvailCreatureSubtypeDic
                    || v.subtypes.some(function (subtype) {
                        return !!creatureSubtypeDic[subtype];
                    }))
                && (!isAvailCreatureClassDic
                    || v.classes.some(function (cls) {
                        return !!creatureClassDic[cls];
                    }))
                && (!isAvailTerrainDic
                    || v.terrains.some(function (terrain) {
                        return !!terrainDic[terrain];
                    }))
                && (!isAvailClimateDic
                    || v.climates.some(function (climate) {
                        return !!climateDic[climate];
                    }));
        });
        //if(DEBUG){
        //    window.__$OUTDEX = [];
        //    targetIndex.forEach(function(item){
        //        if( self.filteredIndex.indexOf(item) < 0 ){
        //            window.__$OUTDEX.push(item.name);
        //        }
        //    });
        //}
        this.narrowItemsByTextFilter();
        this.displayList();
    };
    SubjectIndexList.prototype.displayList = function () {
        var displayingIndex = this.narrowedIndex;
        switch (this.targetContent) {
            case 'feat': {
                if (isFeatIndex(displayingIndex))
                    this.displayFeats(displayingIndex);
                break;
            }
            case 'spell': {
                if (isSpellIndex(displayingIndex))
                    this.displaySpells(displayingIndex);
                break;
            }
            case 'spell-list': {
                if (isSpellIndex(displayingIndex))
                    this.displaySpellList(displayingIndex);
                break;
            }
            case 'magic-item': {
                if (isMagicItemIndex(displayingIndex))
                    this.displayMagicItems(displayingIndex);
                break;
            }
            case 'monster': {
                if (isMonsterIndex(displayingIndex))
                    this.displayMonsters(displayingIndex);
                break;
            }
        }
    };
    SubjectIndexList.prototype.displayMonsters = function (displayingIndex) {
        var self = this;
        var targetIndex = this.currentIndex;
        var listingMethod = this.lookListingMethod();
        var blocks = {};
        var ordererByCR = function (v) {
            var crText = v.cr_text;
            if (typeof crText === 'number') {
                crText = String(crText);
            }
            var itemStr = self.createMonsterListItem(v);
            var blockID = '#cr-' + crText.replace(/\//g, '\\/') + ' ul';
            if (typeof blocks[blockID] == 'undefined')
                blocks[blockID] = "";
            blocks[blockID] += itemStr;
        };
        var ordererByName = function (v) {
            var initLetter = INITIAL_TO_KANA_LINE[v.order[0]];
            var itemStr = self.createMonsterListItem(v);
            var blockID = '#initial-' + initLetter + ' ul';
            if (typeof blocks[blockID] == 'undefined')
                blocks[blockID] = "";
            blocks[blockID] += itemStr;
        };
        var orderer;
        switch (listingMethod) {
            case 'CR':
                this.setupCREntries();
                orderer = ordererByCR;
                break;
            case 'NAME':
            default:
                this.setupKanaInitialEntries();
                orderer = ordererByName;
        }
        displayingIndex.forEach(orderer);
        var _loop_1 = function (selector) {
            var htmlStr = blocks[selector];
            __WEBPACK_IMPORTED_MODULE_0_jquery__(selector)
                .each(function () {
                this.innerHTML = htmlStr;
            });
        };
        for (var _i = 0, _a = Object.keys(blocks); _i < _a.length; _i++) {
            var selector = _a[_i];
            _loop_1(selector);
        }
        this.updateIndexInfo(displayingIndex, targetIndex);
        this.hideEmptyResult();
    };
    SubjectIndexList.prototype.create_query_regex = function (_term) {
        return Object(__WEBPACK_IMPORTED_MODULE_3__script_search_pattern__["a" /* default */])(_term);
    };
    SubjectIndexList.prototype.join_regex = function (_regs) {
        var joined = _regs.map(function (item) {
            return item.source;
        }).join('.*');
        return new RegExp('(' + joined + ')', 'ig');
    };
    SubjectIndexList.prototype.setNarrowingPattern = function (_str) {
        var self = this;
        if (!_str.length) {
            this.narrowingPattern = undefined;
        }
        else {
            var patterns = _str.split(/ +/)
                .filter(function (v) { return !!v.length; })
                .map(function (s) {
                return self.create_query_regex(s);
            });
            var pattern = this.join_regex(patterns);
            this.narrowingPattern = pattern;
        }
        //console.log( this.narrowingPattern );
    };
    // テキストフィルターで絞り込む
    SubjectIndexList.prototype.narrowItemsByTextFilter = function () {
        var pattern = this.narrowingPattern;
        if (typeof pattern === 'undefined') {
            this.narrowedIndex = this.filteredIndex;
            return;
        }
        else {
            var pat_1 = pattern;
            this.narrowedIndex = this.filteredIndex.filter(function (item) {
                return !!pat_1.test(item.name)
                    || !!pat_1.test(item.en_name)
                    || !!pat_1.test(item.yomi)
                    || !!pat_1.test(item.fullyomi)
                    || !!pat_1.test(item.fullname);
            });
        }
    };
    // クリーチャーの項目を構築
    SubjectIndexList.prototype.createMonsterListItem = function (item) {
        var subItems = [];
        subItems.push('脅' + item.cr_text);
        subItems.push(item.alignment_abbr);
        if (item.type == '人型生物') {
            var subtypes = item.subtypes;
            if (subtypes.length == 1) {
                subItems.push(subtypes[0]);
            }
            else if (subtypes.length == 2 && subtypes.indexOf('人間') >= 0 && (subtypes.indexOf('エルフ') >= 0 || subtypes.indexOf('オーク') >= 0)) {
                subItems.push('ハーフ' + subtypes.filter(function (v) { return v != '人間'; }));
            }
            else {
                subItems.push(item.type);
            }
        }
        else {
            subItems.push(item.type);
        }
        if (item.class_levels.length) {
            subItems.push(item.class_levels.join('／'));
        }
        var itemStr = '<li><a href="' + item.path + '">' + item.name;
        itemStr += '<small>';
        itemStr += subItems.join('、');
        itemStr += '</small></a></li>';
        return itemStr;
    };
    /** 検索結果を更新 */
    SubjectIndexList.prototype.updateIndexInfo = function (filteredIndex, targetIndex) {
        __WEBPACK_IMPORTED_MODULE_0_jquery__("#index-info #result-number").text(filteredIndex.length);
        __WEBPACK_IMPORTED_MODULE_0_jquery__("#index-info #index-number").text(targetIndex.length);
    };
    /** 魔法のアイテムの一覧を表示
    */
    SubjectIndexList.prototype.showMagicItems = function () {
        //let targetIndex = this.currentIndex;
        var targetIndex = this.indexes.MAGIC_ITEM;
        var sourceBookDic = this._createSouceBookFilterDic();
        var itemCategoryDic = this._createItemCategoryFilterDic();
        var itemSlotDic = this._createItemSlotFilterDic();
        this.filteredIndex = targetIndex.filter(function (v) {
            return sourceBookDic[v.source]
                && itemCategoryDic[v.category]
                && (itemSlotDic['__ALL__'] || itemSlotDic[v.slot]
                    || itemSlotDic[(v.weapon_property || v.armor_property) && '特殊能力']);
        });
        //let seen = {};
        //this.filteredIndex = this.filteredIndex
        //.sort(function(a, b){
        //    return SOURCE_ORDER[b.source] - SOURCE_ORDER[a.source];
        //})
        //.filter(function(item){
        //    if( !seen[item.name] )
        //    {
        //        seen[item.name] = true;
        //        return true;
        //    }
        //    return false;
        //})
        //.sort(kanaOrderSort);
        this.narrowItemsByTextFilter();
        this.displayList();
    };
    SubjectIndexList.prototype.displayMagicItems = function (displayingIndex) {
        //let targetIndex = this.currentIndex;
        var targetIndex = this.indexes.MAGIC_ITEM;
        var isTabularDisplayMode = __WEBPACK_IMPORTED_MODULE_0_jquery__('#magicitem-display-mode-fields :input:checked').val() == 'table';
        if (isTabularDisplayMode) {
            this._displayTabularMagicItemList(displayingIndex);
        }
        else {
            this._displayStandardMagicItemList(displayingIndex);
        }
        // 結果情報を表示
        this.updateIndexInfo(displayingIndex, targetIndex);
        // 空の項目を非表示
        this.hideEmptyResult();
    };
    SubjectIndexList.prototype._displayTabularMagicItemList = function (displayingIndex) {
        var self = this;
        var magicItems = [];
        displayingIndex
            .forEach(function (v) {
            var itemStr = self._constuctMagicItemListRow(v);
            magicItems.push({
                rowLine: itemStr,
                order: v.order,
                aura_rate: v.aura_rate,
                level_num: v.level_num,
                slot: v.slot,
                price_num: v.price_num,
                weight_num: v.weight_num,
                cost_num: v.cost_num,
                requirement: v.requirement,
                source: v.source,
            });
        });
        this._tabularListCache[this.targetContent] = magicItems;
        var thead = '<thead><tr>'
            //+'<th colspan="6" class="th-item"   >アイテム <span class="sortable" data-sort-key="order"  data-sort-direct="" data-sort-order="0"></span></th>'
            //+'</tr><tr>'
            //+'<th class="th-aura"   >オーラ   <span class="sortable" data-sort-key="aura_rate"  data-sort-direct="" data-sort-order="0"></span></th>'
            + '<th class="th-aura"   >'
            + 'アイテム <span class="sortable" data-sort-key="order"  data-sort-direct="" data-sort-order="0"></span>'
            + ' ／ オーラ <span class="sortable" data-sort-key="aura_rate"  data-sort-direct="" data-sort-order="0"></span></th>'
            + '<th class="th-cl"     >レベル   <span class="sortable" data-sort-key="level_num"  data-sort-direct="" data-sort-order="0"></span></th>'
            + '<th class="th-slot"   >装備部位 <span class="sortable" data-sort-key="slot"       data-sort-direct="" data-sort-order="0"></span></th>'
            + '<th class="th-price"  >市価     <span class="sortable" data-sort-key="price_num"  data-sort-direct="" data-sort-order="0"></span></th>'
            + '<th class="th-weight" >重量     <span class="sortable" data-sort-key="weight_num" data-sort-direct="" data-sort-order="0"></span></th>'
            //+'<th class="th-cost"   >コスト <span class="sortable" data-sort-key="cost_num"   data-sort-direct="" data-sort-order="0"></span></th>'
            + '<th class="th-source" >出典     <span class="sortable" data-sort-key="source"     data-sort-direct="" data-sort-order="0"></span></th>'
            //+'</tr><tr>'
            //+'<th colspan="6" class="th-requirement">必要条件</th>'
            + '</tr>'
            + '</thead>';
        var tbody = '<tbody></tbody>';
        var tableClasses = ['subject-index-table'];
        if (!__WEBPACK_IMPORTED_MODULE_0_jquery__('#magicitem-tabular-show-requirement').prop('checked')) {
            tableClasses.push('hide-requirement');
        }
        var tableClass = tableClasses.join(' ');
        var table = '<table id="tabular-magicitem-list" class="' + tableClass + '">'
            //+'<colgroup class="col-feat"></colgroup><colgroup class="col-prerequisite"></colgroup><colgroup class="col-benefit"></colgroup><colgroup class="col-source"></colgroup>'
            + thead + tbody + '</table>';
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#entry-list').get(0).innerHTML = table;
        this._setupSortableListTable();
        this._renderTabularList();
        this._attachTabularListBody();
    };
    /* 表形式の特技リストの行を作成 */
    SubjectIndexList.prototype._constuctMagicItemListRow = function (itemData) {
        var rowLine = ''
            + '<tr class="tr-item">'
            + '<td colspan="6" class="td-item ' + 'icon-' + itemData.category + '">'
            + '<a href="' + itemData.path + '">' + itemData.name + '</a>'
            + '<small> ' + itemData.en_name + '</small>'
            + '</td>'
            + '</tr><tr class="tr-data">'
            + '<td class="td-aura"   >' + itemData.aura + '</td>'
            + '<td class="td-cl"     >' + itemData.level + '</td>'
            + '<td class="td-slot"   >' + itemData.slot + '</td>'
            + '<td class="td-price"  >' + itemData.price + '</td>'
            + '<td class="td-weight" >' + itemData.weight + '</td>'
            //+'<td>'+ itemData.cost + '</td>'
            + '<td class="td-source" >' + itemData.source + '</td>'
            + '</tr><tr class="tr-requirement">'
            + '<td colspan="6" class="td-requirement">' + itemData.requirement + '</td>'
            + '</tr>';
        return rowLine;
    };
    SubjectIndexList.prototype._createSortFunc = function (_key, _direct) {
        var key = _key;
        var numberSort = false;
        if (/_num$/.test(key)) {
            numberSort = true;
        }
        //console.log( 'SORTKEY:', key, numberSort? 'NUMBER_SORT': 'STR_SORT' );
        var func_ascending = function (a, b) {
            if (a[key] > b[key])
                return 1;
            if (a[key] < b[key])
                return -1;
            return 0;
        };
        var func_descending = function (b, a) {
            if (a[key] > b[key])
                return 1;
            if (a[key] < b[key])
                return -1;
            return 0;
        };
        var func_ascendingNum = function (a, b) {
            return parseInt(a[key]) - parseInt(b[key]);
        };
        var func_descendingNum = function (b, a) {
            return parseInt(a[key]) - parseInt(b[key]);
        };
        if (_direct == 'ascending') {
            return numberSort ? func_ascendingNum : func_ascending;
        }
        else {
            return numberSort ? func_descendingNum : func_descending;
        }
    };
    SubjectIndexList.prototype._renderTabularList = function () {
        var $table = __WEBPACK_IMPORTED_MODULE_0_jquery__('.subject-index-table');
        var self = this;
        var sortSet = [];
        $table
            .find('thead > tr > th > .sortable')
            .filter(function () {
            if ((this.dataset.sortDirect || "").length && parseInt(this.dataset.sortOrder || "0") > 0) {
                return true;
            }
            return false;
        })
            .map(function () {
            var dt = this.dataset;
            sortSet.push({
                sortOrder: parseInt(dt.sortOrder || "0"),
                sortDirect: dt.sortDirect,
                sortKey: dt.sortKey,
                sortFunc: self._createSortFunc(dt.sortKey || "", dt.sortDirect),
            });
        });
        sortSet.sort(function (a, b) { return a.sortOrder - b.sortOrder; });
        //console.log('sortSet.length =>', sortSet.length);
        var cache = this._tabularListCache[this.targetContent];
        cache.sort(function (a, b) {
            var order = 0;
            sortSet.some(function (v) {
                order = v.sortFunc(a, b);
                return !!order;
            });
            return order;
        });
    };
    SubjectIndexList.prototype.redrawTabularList = function () {
        this._attachTabularListBody();
    };
    SubjectIndexList.prototype._attachTabularListBody = function () {
        var self = this;
        var items = this._tabularListCache[this.targetContent];
        // 表示件数制限
        if (self.targetContent == 'magic-item') {
            __WEBPACK_IMPORTED_MODULE_0_jquery__('[name="magicitem-tabular-limit"]:checked')
                .each(function () {
                var limit = parseInt(this.value);
                if (limit > 0) {
                    items = items.slice(0, Math.min(limit, items.length));
                }
            });
        }
        var tbodyInner = "";
        items.forEach(function (v) {
            tbodyInner += v.rowLine;
        });
        var beg = Date.now();
        var tbody = __WEBPACK_IMPORTED_MODULE_0_jquery__('.subject-index-table > tbody').get(0);
        tbody.innerHTML = tbodyInner;
        tbody.offsetHeight;
        console.log('Time (innerHTML):', (Date.now() - beg) / 1000, 'sec.');
    };
    /** 通常形式の魔法のアイテム一覧を表示 */
    SubjectIndexList.prototype._displayStandardMagicItemList = function (displayingIndex) {
        this.setupKanaInitialEntries();
        var blocks = {};
        displayingIndex
            .forEach(function (v) {
            var initLetter = INITIAL_TO_KANA_LINE[v.order[0]];
            var postText = '';
            // if( v.category ){
            //     categoryText = '（' + v.category + '）';
            // }
            if (v.weapon_property || v.armor_property) {
                postText += '（特殊能力）';
            }
            var categoryClass = 'icon-' + v.category;
            var classText = "";
            if (v.source == 'UE')
                classText = ' class="ue"';
            var itemStr = '<li class="' + categoryClass + '"><a href="' + v.path + '"' + classText + '>' + v.name + postText + '</a></li>';
            var blockID = '#initial-' + initLetter + ' ul';
            if (typeof blocks[blockID] == 'undefined')
                blocks[blockID] = "";
            blocks[blockID] += itemStr;
        });
        var _loop_2 = function (selector) {
            var htmlStr = blocks[selector];
            __WEBPACK_IMPORTED_MODULE_0_jquery__(selector).each(function () { this.innerHTML = htmlStr; });
        };
        for (var _i = 0, _a = Object.keys(blocks); _i < _a.length; _i++) {
            var selector = _a[_i];
            _loop_2(selector);
        }
    };
    /** 特技の一覧を表示
    */
    SubjectIndexList.prototype.showFeats = function () {
        //if(!isFeatIndex(this.currentIndex))
        //    throw new Error("Not FeatIndex.");
        var targetIndex = this.indexes.FEAT;
        //targetIndex.sort(function(a,b){ return a.order < b.order ? -1 : a.order > b.order ? 1 : 0 });
        // 現在の選択状態から絞込み辞書を作成
        var sourceBookDic = this._createSouceBookFilterDic();
        var featCategoryDic = this._createFeatCategoryFilterDic();
        // 絞込み
        this.filteredIndex = targetIndex.filter(function (v) {
            return sourceBookDic[v.source]
                && Object.keys(v.category).some(function (category) {
                    return featCategoryDic[category];
                });
        });
        // テキストフィルターで絞り込み
        this.narrowItemsByTextFilter();
        // 表示
        this.displayList();
    };
    SubjectIndexList.prototype.displayFeats = function (displayingIndex) {
        var targetIndex = this.currentIndex;
        var isTabularDisplayMode = __WEBPACK_IMPORTED_MODULE_0_jquery__('#feat-display-mode-fields :input:checked').val() == 'table';
        if (isTabularDisplayMode) {
            this._displayTabularFeatList(displayingIndex);
        }
        else {
            this._displayStandardFeatList(displayingIndex);
        }
        // 結果情報を表示
        this.updateIndexInfo(displayingIndex, targetIndex);
        // 空の項目を非表示
        this.hideEmptyResult();
    };
    SubjectIndexList.prototype._displayTabularFeatList = function (displayingIndex) {
        var self = this;
        var featItems = [];
        displayingIndex
            .forEach(function (v) {
            var itemStr = self._constuctFeatListRow(v);
            featItems.push({
                rowLine: itemStr,
                order: v.order,
                prerequisite: (typeof v.prerequisite !== 'undefined' ? v.prerequisite : '？？'),
                source: v.source,
            });
        });
        this._tabularListCache[this.targetContent] = featItems;
        var thead = '<thead><tr>'
            + '<th class="th-feat"        >特技     <span class="sortable" data-sort-key="order"  data-sort-direct="" data-sort-order="0"></span></th>'
            + '<th class="th-prerequisite">前提条件 <span class="sortable" data-sort-key="prerequisite" data-sort-direct="" data-sort-order="0"></span></th>'
            + '<th class="th-benefit"     >利益</th>'
            + '<th class="th-source"      >出典     <span class="sortable" data-sort-key="source" data-sort-direct="" data-sort-order="0"></span></th>'
            + '</thead>';
        var tbody = '<tbody></tbody>';
        var table = '<table id="tabular-feat-list" class="subject-index-table">'
            + '<colgroup class="col-feat"></colgroup><colgroup class="col-prerequisite"></colgroup><colgroup class="col-benefit"></colgroup><colgroup class="col-source"></colgroup>'
            + thead + tbody + '</table>';
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#entry-list').get(0).innerHTML = table;
        this._setupSortableListTable();
        this._renderTabularList();
        this._attachTabularListBody();
    };
    SubjectIndexList.prototype._setupSortableListTable = function () {
        var self = this;
        __WEBPACK_IMPORTED_MODULE_0_jquery__('.subject-index-table .sortable').each(function () {
            var dt = this.dataset;
            var cond = self._tabularListCondition[self.targetContent][dt.sortKey];
            if (cond) {
                dt.sortDirect = cond.sortDirect;
                dt.sortOrder = String(cond.sortOrder);
            }
        });
        __WEBPACK_IMPORTED_MODULE_0_jquery__('.subject-index-table .sortable').on('click', function () {
            var current = this; // current: HTMLElement = this;
            // sortOrder が 1 （現在最も有効なソート条件）であれば、昇降を逆転
            if ((this.dataset.sortOrder || "") == "1" || !(this.dataset.sortDirect || "").length) {
                this.dataset.sortDirect
                    = this.dataset.sortDirect != "ascending" ? "ascending" : "descending";
            }
            // 優先順位振り当て
            var newOrderNum = 1;
            __WEBPACK_IMPORTED_MODULE_0_jquery__('.subject-index-table .sortable')
                .filter(function () {
                return this !== current
                    && !!this.dataset.sortDirect
                    && ((this.dataset.sortOrder || 0) > 0);
            })
                .map(function () { return this; })
                .toArray()
                .sort(function (a, b) {
                return parseInt(a.dataset.sortOrder || "0") - parseInt(b.dataset.sortOrder || "0");
            })
                .forEach(function (v) { v.dataset.sortOrder = "" + ++newOrderNum; });
            this.dataset.sortOrder = "1";
            __WEBPACK_IMPORTED_MODULE_0_jquery__('.subject-index-table .sortable').each(function () {
                var dt = this.dataset;
                self._tabularListCondition[self.targetContent][dt.sortKey] = {
                    sortOrder: parseInt(dt.sortOrder),
                    sortDirect: dt.sortDirect,
                };
            });
            // 再表示
            self._renderTabularList();
            self._attachTabularListBody();
        });
    };
    /* 表形式の特技リストの行を作成 */
    SubjectIndexList.prototype._constuctFeatListRow = function (featData) {
        // （焦、物）等
        var categoryText = this._constructFeatCategoryNoteStr(featData);
        var benefit = featData.benefit;
        if (typeof benefit === 'undefined') {
            benefit = '？？';
        }
        var prerequisite = featData.prerequisite;
        if (typeof prerequisite === 'undefined') {
            prerequisite = '？？';
        }
        if (categoryText) {
            categoryText = ' <small>' + categoryText + '</small>';
        }
        var rowLine = ''
            + '<tr>'
            + '<td>'
            + '<a href="' + featData.path + '">' + featData.name + '</a>'
            + categoryText
            + '</td>'
            + '<td>' + prerequisite + '</td>'
            + '<td>' + benefit + '</td>'
            + '<td>' + featData.source + '</td>'
            + '</tr>';
        return rowLine;
    };
    /** 通常形式の特技一覧を表示 */
    SubjectIndexList.prototype._displayStandardFeatList = function (displayingIndex) {
        var self = this;
        this.setupKanaInitialEntries();
        var blocks = {};
        displayingIndex
            .forEach(function (v) {
            var initLetter = INITIAL_TO_KANA_LINE[v.order[0]];
            if (!initLetter)
                initLetter = '名称未訳';
            var categoryText = self._constructFeatCategoryNoteStr(v);
            var itemStr = '<li><a href="' + v.path + '">' + v.name + categoryText + '</a></li>';
            var blockID = '#initial-' + initLetter + ' ul';
            if (typeof blocks[blockID] == 'undefined')
                blocks[blockID] = "";
            blocks[blockID] += itemStr;
        });
        var _loop_3 = function (selector) {
            var htmlStr = blocks[selector];
            __WEBPACK_IMPORTED_MODULE_0_jquery__(selector).each(function () { this.innerHTML = htmlStr; });
        };
        for (var _i = 0, _a = Object.keys(blocks); _i < _a.length; _i++) {
            var selector = _a[_i];
            _loop_3(selector);
        }
    };
    SubjectIndexList.prototype._constructFeatCategoryNoteStr = function (featData) {
        var categoryText = '';
        if (Object.keys(featData.category).length) {
            var text = Object.keys(featData.category).filter(function (v) { return v != 'その他'; }).join('、');
            if (text && text != 'その他') {
                categoryText = '（' + text + '）';
            }
        }
        return categoryText;
    };
    /** 呪文の一覧を表示 */
    SubjectIndexList.prototype.showSpells = function () {
        var targetIndex = this.indexes.SPELL;
        //targetIndex.sort(function(a,b){ return a.order < b.order ? -1 : a.order > b.order ? 1 : 0 });
        var sourceBookDic = this._createSouceBookFilterDic();
        var schoolDic = this._createSchoolFilterDic();
        var sbuschoolDic = this._createSubschoolFilterDic();
        var isAvailSbuschoolDic = !!Object.keys(sbuschoolDic).length;
        var descriptorDic = this._createDescriptorFilterDic();
        var descriptorKeys = Object.keys(descriptorDic);
        var isAvailDescriptorDic = descriptorKeys.length;
        this.filteredIndex = targetIndex.filter(function (v) {
            return sourceBookDic[v.source]
                && schoolDic[v.school]
                && (!isAvailSbuschoolDic
                    || v.subschools.some(function (subschool) {
                        return sbuschoolDic[subschool];
                    }))
                && (!isAvailDescriptorDic
                    || descriptorKeys.every(function (condDesc) {
                        return v.descriptors.indexOf(condDesc) >= 0;
                    }));
        });
        this.narrowItemsByTextFilter();
        this.displayList();
    };
    SubjectIndexList.prototype.displaySpells = function (displayingIndex) {
        var targetIndex = this.currentIndex;
        this.setupKanaInitialEntries();
        var blocks = {};
        displayingIndex
            .forEach(function (v) {
            var initLetter = INITIAL_TO_KANA_LINE[v.order[0]];
            var itemStr = '<li><a href="' + v.path + '">' + v.name + '</a></li>';
            var blockID = '#initial-' + initLetter + ' ul';
            if (typeof blocks[blockID] == 'undefined')
                blocks[blockID] = "";
            blocks[blockID] += itemStr;
        });
        var _loop_4 = function (selector) {
            var htmlStr = blocks[selector];
            __WEBPACK_IMPORTED_MODULE_0_jquery__(selector)
                .each(function () {
                this.innerHTML = htmlStr;
            });
        };
        for (var _i = 0, _a = Object.keys(blocks); _i < _a.length; _i++) {
            var selector = _a[_i];
            _loop_4(selector);
        }
        // 結果情報を表示
        this.updateIndexInfo(displayingIndex, targetIndex);
        // 空の項目を非表示
        this.hideEmptyResult();
    };
    /** 呪文リストを表示 */
    SubjectIndexList.prototype.showSpellList = function () {
        var self = this;
        var targetIndex = this.indexes.SPELL;
        //targetIndex.sort(function(a,b){ return a.order < b.order ? -1 : a.order > b.order ? 1 : 0 });
        // ルールブック
        var sourceBookDic = this._createSouceBookFilterDic();
        // 系統
        var schoolDic = this._createSchoolFilterDic();
        var sbuschoolDic = this._createSubschoolFilterDic();
        var isAvailSbuschoolDic = !!Object.keys(sbuschoolDic).length;
        var descriptorDic = this._createDescriptorFilterDic();
        var descriptorKeys = Object.keys(descriptorDic);
        var isAvailDescriptorDic = descriptorKeys.length;
        // クラス
        var casterClass = __WEBPACK_IMPORTED_MODULE_0_jquery__('#caster-class-fields :input:checked').val();
        // 呪文レベル
        var spellLevelsText = __WEBPACK_IMPORTED_MODULE_0_jquery__('#spell-level-fields :input:checked')
            .map(function () { return __WEBPACK_IMPORTED_MODULE_0_jquery__(this).val(); })
            .toArray()
            .join('');
        var bonusSpellLineages = [];
        var casterLineageSizzl = {
            'クレリック': '#cleric-domain-fields :input:checked'
                + ', #cleric-subdomain-fields :input:checked',
            'ドルイド': '#druid-domain-fields :input:checked'
                + ', #animal-terrain-domain-fields :input:checked',
            'ソーサラー': '#sorcerer-bloodline-fields :input:checked',
            'オラクル': '#oracle-mystery-fields :input:checked',
            'ウィッチ': '#witch-patron-fields :input:checked',
            'シャーマン': '#shaman-spirit-fields :input:checked',
            'ブラッドレイジャー': '#bloodrager-bloodline-fields :input:checked',
            'サイキック': '#psychic-discipline-fields :input:checked',
        };
        if (casterLineageSizzl[casterClass]) {
            var query = casterLineageSizzl[casterClass];
            __WEBPACK_IMPORTED_MODULE_0_jquery__(query)
                .each(function () { bonusSpellLineages.push(__WEBPACK_IMPORTED_MODULE_0_jquery__(this).val()); });
        }
        console.log(bonusSpellLineages);
        var spellLevelPattern = '[' + spellLevelsText + ']';
        var casterSpellRe = new RegExp('^' + casterClass + spellLevelPattern + '$');
        this.spellLevelMemo = {};
        this.spellListData = {
            classSpell: {},
            bonusSpell: {},
        };
        var filteredCommonIndex = targetIndex.filter(function (spell) {
            return sourceBookDic[spell.source]
                && schoolDic[spell.school]
                && (!isAvailSbuschoolDic
                    || spell.subschools.some(function (subschool) {
                        return sbuschoolDic[subschool];
                    }))
                && (!isAvailDescriptorDic
                    || descriptorKeys.every(function (condDesc) {
                        return spell.descriptors.indexOf(condDesc) >= 0;
                    }));
        });
        // クラスの呪文
        this.filteredIndex = filteredCommonIndex.filter(function (spell) {
            return spell.spell_levels.some(function (spellLevel) {
                if (casterSpellRe.test(spellLevel)) {
                    self.spellLevelMemo[spell.name] = spellLevel;
                    var _classSpell = self.spellListData.classSpell;
                    if (!_classSpell[spellLevel])
                        _classSpell[spellLevel] = [];
                    _classSpell[spellLevel].push(spell);
                    return true;
                }
                return false;
            });
        });
        // ボーナス呪文
        bonusSpellLineages.forEach(function (lineage) {
            var bonusSpellRe = new RegExp('^' + lineage + spellLevelPattern + '$');
            console.log(bonusSpellRe);
            var additionalSpells = filteredCommonIndex.filter(function (spell) {
                return spell.spell_levels.some(function (spellLevel) {
                    if (bonusSpellRe.test(spellLevel)) {
                        var _bonusSpell = self.spellListData.bonusSpell;
                        if (!_bonusSpell[spellLevel])
                            _bonusSpell[spellLevel] = [];
                        _bonusSpell[spellLevel].push(spell);
                        return true;
                    }
                    return false;
                });
            });
            Array.prototype.push.apply(self.filteredIndex, additionalSpells);
        });
        //console.log(this.filteredIndex);
        console.log(this.spellListData.bonusSpell);
        this.narrowItemsByTextFilter();
        this.displayList();
    };
    SubjectIndexList.prototype.displaySpellList = function (displayingIndex) {
        var targetIndex = this.currentIndex;
        var isShowTabularList = __WEBPACK_IMPORTED_MODULE_0_jquery__('#show-school-header-fields :input:checked').val() == 'table';
        if (isShowTabularList) {
            this._displayTabularSpellList(displayingIndex);
        }
        else {
            this._displayStandardSpellList(displayingIndex);
        }
        // 結果情報を表示
        this.updateIndexInfo(displayingIndex, targetIndex);
        // 空の項目を非表示
        this.hideEmptyResult();
    };
    /** 通常形式の呪文リストを作成 */
    SubjectIndexList.prototype._displayStandardSpellList = function (displayingIndex) {
        var self = this;
        this.setupSpellLevelListHolder();
        var isShowShoolHeader = __WEBPACK_IMPORTED_MODULE_0_jquery__('#show-school-header-fields :input:checked').val() == 'school';
        var blocks = {};
        // クラスの呪文
        Object.keys(this.spellListData.classSpell).forEach(function (spellLevel) {
            self.spellListData.classSpell[spellLevel].forEach(function (spell) {
                var spellLvNum = parseInt(spellLevel.replace(/^\D+/, ''));
                if (displayingIndex.indexOf(spell) >= 0) {
                    var blockID = '#spell-level-' + spellLvNum;
                    if (isShowShoolHeader) {
                        blockID += ' [data-school="' + (spell.school || '不明') + '"]';
                    }
                    blockID += ' ul:eq(0)';
                    var itemStr = self.constuctSpellListItem(spell);
                    if (typeof blocks[blockID] == 'undefined')
                        blocks[blockID] = "";
                    blocks[blockID] += itemStr;
                }
            });
        });
        // ボーナス呪文
        Object.keys(this.spellListData.bonusSpell).forEach(function (spellLevel) {
            self.spellListData.bonusSpell[spellLevel].forEach(function (spell) {
                var spellLvNum = parseInt(spellLevel.replace(/^\D+/, ''));
                if (displayingIndex.indexOf(spell) >= 0) {
                    var blockID = '#spell-level-' + spellLvNum;
                    if (isShowShoolHeader) {
                        blockID += ' [data-school="' + (spell.school || '不明') + '"]';
                    }
                    blockID += ' .bonus-spell ul:eq(0)';
                    var itemStr = self.constuctSpellListItem(spell);
                    var bonusSpellMarker = ''
                        + '<em class="bonus-spell">［'
                        + spellLevel.replace(/\d$/, '')
                        + '］</em>';
                    itemStr = itemStr.replace(/<li>/, '<li>' + bonusSpellMarker);
                    if (typeof blocks[blockID] == 'undefined')
                        blocks[blockID] = "";
                    blocks[blockID] += itemStr;
                }
            });
        });
        var _loop_5 = function (selector) {
            var htmlStr = blocks[selector];
            __WEBPACK_IMPORTED_MODULE_0_jquery__(selector).each(function () { this.innerHTML = htmlStr; });
        };
        for (var _i = 0, _a = Object.keys(blocks); _i < _a.length; _i++) {
            var selector = _a[_i];
            _loop_5(selector);
        }
    };
    SubjectIndexList.prototype.constructSpellNoteStr = function (_spellData) {
        var notes = [];
        var noteStr = '';
        if (_spellData.ex_material)
            notes.push('物');
        if (_spellData.ex_focus)
            notes.push('焦');
        if (_spellData.is_augmentable)
            notes.push('増');
        if (_spellData.is_mythic)
            notes.push('神');
        if (notes.length) {
            noteStr = '（' + notes.join('、') + '）';
        }
        return noteStr;
    };
    SubjectIndexList.prototype.constuctSpellListItem = function (spellData) {
        // （焦、物）等
        var noteStr = this.constructSpellNoteStr(spellData);
        return ''
            + '<li>'
            + '<strong>'
            + '<a href="' + spellData.path + '">' + spellData.name + '</a>'
            + noteStr + '：</strong>'
            + spellData.summary + '</li>';
    };
    /** 表形式の呪文リストを表示 */
    SubjectIndexList.prototype._displayTabularSpellList = function (displayingIndex) {
        var self = this;
        //let casterClass = $('#caster-class-fields :input:checked').val();
        var spellItems = [];
        Object.keys(this.spellListData.classSpell).forEach(function (spellLevel) {
            self.spellListData.classSpell[spellLevel].forEach(function (spell) {
                if (displayingIndex.indexOf(spell) >= 0) {
                    var spellLvNum = parseInt(spellLevel.replace(/^\D+/, ''));
                    var itemStr = self._constuctSpellListRow(spell, spellLvNum, spellLevel);
                    spellItems.push({
                        rowLine: itemStr,
                        level: spellLvNum,
                        order: spell.order,
                        school: spell.school,
                        source: spell.source,
                    });
                }
            });
        });
        // ボーナス呪文
        Object.keys(this.spellListData.bonusSpell).forEach(function (spellLevel) {
            self.spellListData.bonusSpell[spellLevel].forEach(function (spell) {
                if (displayingIndex.indexOf(spell) >= 0) {
                    var spellLvNum = parseInt(spellLevel.replace(/^\D+/, ''));
                    var itemStr = self._constuctSpellListRow(spell, spellLvNum, spellLevel);
                    spellItems.push({
                        rowLine: itemStr,
                        level: spellLvNum,
                        order: spell.order,
                        school: spell.school,
                        source: spell.source,
                    });
                }
            });
        });
        this._tabularListCache[this.targetContent] = spellItems;
        var thead = '<thead><tr>'
            + '<th class="th-level"  ><span      class="sortable" data-sort-key="level"  data-sort-direct="" data-sort-order="0"></span></th>'
            + '<th class="th-spell"  >呪文 <span class="sortable" data-sort-key="order"  data-sort-direct="" data-sort-order="0"></span></th>'
            + '<th class="th-school" >系統 <span class="sortable" data-sort-key="school" data-sort-direct="" data-sort-order="0"></span></th>'
            + '<th class="th-summary">概要</th>'
            + '<th class="th-source" >出典 <span class="sortable" data-sort-key="source" data-sort-direct="" data-sort-order="0"></span></th>'
            + '</thead>';
        var tbody = '<tbody></tbody>';
        var table = '<table id="tabular-spell-list" class="subject-index-table">'
            + '<colgroup class="col-level"></colgroup><colgroup class="col-spell"></colgroup><colgroup class="col-school"></colgroup><colgroup class="col-summary"></colgroup><colgroup class="col-source"></colgroup>'
            + thead + tbody + '</table>';
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#entry-list').get(0).innerHTML = table;
        this._setupSortableListTable();
        this._renderTabularList();
        this._attachTabularListBody();
    };
    /* 表形式の呪文リストの行を作成 */
    SubjectIndexList.prototype._constuctSpellListRow = function (_spellData, _spellLvNum, _classSpellLevel) {
        var bonusSpellMarker = "";
        if (/：/.test(_classSpellLevel)) {
            bonusSpellMarker = ''
                + '<em class="bonus-spell">［'
                + _classSpellLevel.replace(/\d$/, '')
                + '］</em>';
        }
        // （焦、物）等
        var noteStr = this.constructSpellNoteStr(_spellData);
        var rowLine = ''
            + '<tr>'
            + '<td>' + _spellLvNum + '</td>'
            + '<td>'
            + bonusSpellMarker
            + '<a href="' + _spellData.path + '">' + _spellData.name + '</a>'
            + noteStr
            + '</td>'
            + '<td>' + _spellData.school + '</td>'
            + '<td>' + _spellData.summary + '</td>'
            + '<td>' + _spellData.source + '</td>'
            + '</tr>';
        return rowLine;
    };
    /** 空の項目を非表示にする */
    SubjectIndexList.prototype.hideEmptyResult = function () {
        // 一般的なリスト
        this.fetchEntryListByType('normal-list')
            .find('ul.entries').each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            if (!$this.find('li').length) {
                $this.closest('section').hide();
            }
        });
        // 呪文リスト（レベル別）
        this.fetchEntryListByType('spell-list')
            .find('ul.spell-summary')
            .each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            if (!$this.find('li').length) {
                $this.closest('section').hide();
            }
        });
        // 呪文リスト（系統付）
        this.fetchEntryListByType('spell-list-by-school')
            .find('[data-school]').each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            if (!$this.find('li').length) {
                $this.closest('section').hide();
            }
        });
        this.fetchEntryListByType('spell-list-by-school')
            .find('section[id^="spell-level-"]')
            .each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            if (!$this.find('>section[data-school]:visible').length) {
                $this.hide();
            }
        });
    };
    /** インデックスを選択中の出典ルールブックで選別 */
    SubjectIndexList.prototype.filterSourceBook = function (indexes) {
        var checkDic = this._createSouceBookFilterDic();
        var filteredIndexes = indexes.filter(function (v) { return checkDic[v.source]; });
        return filteredIndexes;
    };
    //==============================================================================
    // 選別用の辞書を作成
    //==============================================================================
    SubjectIndexList.prototype.__createFilterDic = function (sizzle) {
        var filtingKeys = [];
        __WEBPACK_IMPORTED_MODULE_0_jquery__(sizzle)
            .each(function () {
            filtingKeys.push(__WEBPACK_IMPORTED_MODULE_0_jquery__(this).val());
        });
        // filtingKeys -> ['極小','中型', ... ]
        var checkDic = {};
        filtingKeys.forEach(function (v) {
            checkDic[v] = true;
        });
        // checkDic -> {'極小': ture, '中型': true, ... }
        return checkDic;
    };
    /* 出典で選別するための辞書を作成 */
    SubjectIndexList.prototype._createSouceBookFilterDic = function () {
        var filtingKeys = [];
        __WEBPACK_IMPORTED_MODULE_0_jquery__(':input:checked[id^="source-book-"]')
            .each(function () {
            filtingKeys.push(__WEBPACK_IMPORTED_MODULE_0_jquery__(this).val());
        });
        var checkDic = {};
        filtingKeys.forEach(function (v) {
            checkDic[v] = true;
        });
        return checkDic;
    };
    /* クラスで選別するための辞書を作成 */
    SubjectIndexList.prototype._createCreatureClassFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="creature-class"]');
    };
    /* 種別で選別するための辞書を作成 */
    SubjectIndexList.prototype._createCreatureTypeFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="creature-type"]');
    };
    SubjectIndexList.prototype._createCreatureSubtypeFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="creature-subtype"]');
    };
    /* 地形 */
    SubjectIndexList.prototype._createTerrainFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="terrain"]');
    };
    SubjectIndexList.prototype._createClimateFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="climate"]');
    };
    SubjectIndexList.prototype._createChallengeRatingFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="challenge-rating"]');
    };
    SubjectIndexList.prototype._createCreatureSizeFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="creature-size"]');
    };
    SubjectIndexList.prototype._createAlignmentFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="alignment"]');
    };
    /* 系統で選別するための辞書を作成 */
    SubjectIndexList.prototype._createSchoolFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="school"]');
    };
    SubjectIndexList.prototype._createSubschoolFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="subschool"]');
    };
    SubjectIndexList.prototype._createDescriptorFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="descriptor"]');
    };
    /* 特技カテゴリーで選別するための辞書を作成 */
    SubjectIndexList.prototype._createFeatCategoryFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="feat-category"]');
    };
    /* アイテムカテゴリーで選別するための辞書を作成 */
    SubjectIndexList.prototype._createItemCategoryFilterDic = function () {
        return this.__createFilterDic(':input:checked[name="item-category"]');
    };
    /* アイテム装備部位で選別するための辞書を作成 */
    SubjectIndexList.prototype._createItemSlotFilterDic = function () {
        var itemLength = __WEBPACK_IMPORTED_MODULE_0_jquery__(':input[name="item-slot"]').length;
        console.log('itemLength', itemLength);
        var dic = this.__createFilterDic(':input:checked[name="item-slot"]');
        console.log('dic.length', Object.keys(dic).length);
        if (Object.keys(dic).length == itemLength)
            dic['__ALL__'] = true;
        return dic;
    };
    /** 各項目で有効な出典ルールブックを抽出しキャッシュする */
    SubjectIndexList.prototype.readyValidSouceBooks = function (indexName) {
        // 初期化済みなら。
        if (this.validSourceBooks[indexName].length) {
            return;
        }
        var validDic = {};
        var index = this.indexes[indexName];
        index.forEach(function (v) {
            validDic[v.source] = true;
        });
        this.validSourceBooks[indexName] = Object.keys(validDic);
    };
    /** 有効な術者クラスを抽出し、メニューを作る */
    SubjectIndexList.prototype.readyClassFilterFields = function () {
        if (this.isReadiedCasterClassFields) {
            return;
        }
        var spellIndex = this.indexes.SPELL;
        var classesMap = {};
        spellIndex.forEach(function (v) {
            if (v.classes) {
                v.classes.forEach(function (casterClass) {
                    classesMap[casterClass] = true;
                });
            }
        });
        var classNames = Object.keys(classesMap).sort();
        var fieldsText = '';
        classNames.forEach(function (className) {
            var field = '<label><input name="caster-class" value="'
                + className + '" type="radio" /> '
                + className + '</label> ';
            fieldsText += field;
        });
        __WEBPACK_IMPORTED_MODULE_0_jquery__(fieldsText).appendTo('#caster-class-fields');
        this.isReadiedCasterClassFields = true;
    };
    // 呪文レベルリストホルダー作成
    SubjectIndexList.prototype.setupSpellLevelListHolder = function () {
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#entry-list').text('');
        var casterClass = __WEBPACK_IMPORTED_MODULE_0_jquery__('#caster-class-fields :input:checked').val();
        if (!casterClass)
            return;
        var isShowShoolHeader = __WEBPACK_IMPORTED_MODULE_0_jquery__('#show-school-header-fields :input:checked').val() == 'school';
        var doSpellListArea;
        if (isShowShoolHeader) {
            this.applyListType('spell-list-by-school');
            doSpellListArea = function () {
                var listArea = '';
                SCHOOL_ORDER
                    .forEach(function (v) {
                    listArea += ''
                        + '<section data-school="' + v + '">'
                        + '<h4>' + v + '</h4>'
                        + '<ul class="spell-summary"></ul>'
                        + '<section class="bonus-spell">'
                        + '<ul></ul></section>'
                        + '</section>';
                }); // SCHOOL_ORDER
                return listArea;
            };
        }
        else {
            this.applyListType('spell-list');
            doSpellListArea = function () {
                return '<ul class="spell-summary"></ul>'
                    + '<section class="bonus-spell">'
                    + '<ul></ul></section>';
            };
        }
        // 呪文レベル毎にリストの元を作る
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#spell-level-fields :input:checked').each(function () {
            var spellLevel = __WEBPACK_IMPORTED_MODULE_0_jquery__(this).val();
            var sectionStr = ''
                + '<section id="spell-level-' + spellLevel + '"><h3>'
                + spellLevel + 'レベル・'
                + casterClass + '</h3>'
                + doSpellListArea()
                + '</section>';
            __WEBPACK_IMPORTED_MODULE_0_jquery__(sectionStr).appendTo('#entry-list');
        });
    };
    // カナ行リストホルダー作成
    SubjectIndexList.prototype.setupKanaInitialEntries = function () {
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#entry-list').text('');
        KANA_LINES.forEach(function (init) {
            __WEBPACK_IMPORTED_MODULE_0_jquery__('<section id="initial-' + init + '"><h3>' + init + '行</h3><ul class="entries"></ul></section>')
                .appendTo('#entry-list');
        });
        __WEBPACK_IMPORTED_MODULE_0_jquery__('<section id="initial-名称未訳"><h3>※名称未訳</h3><ul class="entries"></ul></section>')
            .appendTo('#entry-list');
    };
    // 脅威度リストホルダー作成
    SubjectIndexList.prototype.setupCREntries = function () {
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#entry-list').text('');
        ['1/8', '1/6', '1/4', '1/3', '1/2',
            '1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
            '11', '12', '13', '14', '15', '16', '17', '18', '19', '20',
            '21', '22', '23', '24', '25', '26', '27', '28', '29', '30']
            .forEach(function (crText) {
            __WEBPACK_IMPORTED_MODULE_0_jquery__('<section id="cr-' + crText + '"><h3>脅威度' + crText + '</h3><ul class="entries"></ul></section>')
                .appendTo('#entry-list');
        });
    };
    return SubjectIndexList;
}());
//DmVuDoc.subjectIndexes['MAGIC_ITEM'] = DmVuDoc.itemIndex;
//let subjectIndex = new PRDJSubjectIndexList(DmVuDoc.subjectIndexes);
//subjectIndex.run();


/***/ }),

/***/ 58:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = makeSearchPattern;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_fhconvert__ = __webpack_require__(59);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_fhconvert___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_fhconvert__);

var malleableKanaPatternTable = {
    "ア": "[ァア]",
    "イ": "[ィイ]",
    "ウ": "[ゥウ]",
    "エ": "[ェエ]",
    "オ": "[ォオ]",
    "ヤ": "[ャヤ]",
    "ユ": "[ュユ]",
    "ヨ": "[ョヨ]",
    "ァ": "[ァア]",
    "ィ": "[ィイ]",
    "ゥ": "[ゥウ]",
    "ェ": "[ェエ]",
    "ォ": "[ォオ]",
    "ャ": "[ャヤ]",
    "ュ": "[ュユ]",
    "ョ": "[ョヨ]",
    "ツ": "[ッツ]",
    "ッ": "[ッツ]",
    "ジ": "[ジヂ]",
    "ズ": "[ズヅ]",
    "ヂ": "[ジヂ]",
    "ヅ": "[ズヅ]",
    "バ": "(?:ヴァ|バ)",
    "ビ": "(?:ヴィ|ビ)",
    "ブ": "[ヴブ]",
    "ベ": "(?:ヴェ|ベ)",
    "ボ": "(?:ヴォ|ボ)",
    "ヴァ": "(?:ヴァ|バ)",
    "ヴィ": "(?:ヴィ|ビ)",
    "ヴェ": "(?:ヴェ|ベ)",
    "ヴォ": "(?:ヴォ|ボ)",
    "ヴ": "[ヴブ]",
    "ヒュ": "[ヒフ][ユュ]",
    "フュ": "[ヒフ][ユュ]",
};
var vowelDerivingTable = {
    "ア": new RegExp("[ァアカガサザタダナハバパマラャヤワ]"),
    "イ": new RegExp("[ィイキギシジチヂニヒビピミリ]"),
    "ウ": new RegExp("[ゥウクグスズツヅヌフブプムルュユヴ]"),
    "エ": new RegExp("[ェエケゲセゼテデネヘベペメレ]"),
    "オ": new RegExp("[ォオコゴソゾトドノホボポモロョヨヲ]")
};
var prolongPatternTable = {
    "ア": "[ァアー]",
    "イ": "[ィイー]",
    "ウ": "[ゥウー]",
    "エ": "[ェエー]",
    "オ": "[ォオー]",
    "オー": "[ウゥオォー]",
    "エー": "[イィエェー]",
};
// テキストからパターンを作る
function makeSearchPattern(_queryText) {
    // ひらがなをカタカナに変換
    var queryText = __WEBPACK_IMPORTED_MODULE_0_fhconvert__["hgtokk"](_queryText);
    // パターン作成
    var seq = queryText.match(/ヴ[ァィェォ]|[ヒフ]ュ|./g);
    if (!seq) {
        seq = [];
    }
    ;
    var searchRegexpSeeds = [];
    var vowels = []; // 母音
    seq.forEach(function (_charUnit, idx) {
        var charUnit = "" + _charUnit;
        var matched = charUnit.match(/(.)$/);
        if (!matched)
            matched = [""];
        var lastChar = matched[0];
        var vowel = "";
        vowels[idx] = "";
        // 母音抽出
        Object.keys(vowelDerivingTable)
            .forEach(function (vowelKey) {
            var pattern = vowelDerivingTable[vowelKey];
            if (lastChar.match(pattern)) {
                vowel = vowelKey;
                vowels[idx] = vowel;
                return false;
            }
            return true;
        });
        // 長音のパターンを作成
        var prolongPattern = "";
        var prevVowel = vowels[idx - 1];
        if (charUnit.match(/^[アイウエオァィゥェォー]$/) && prevVowel) {
            // 今が長音の場合
            if (charUnit == "ー") {
                prolongPattern = prolongPatternTable[prevVowel + "ー"] || prolongPatternTable[prevVowel];
            }
            else if (prevVowel === vowel) {
                prolongPattern = prolongPatternTable[vowel];
            }
            else if (prevVowel === "オ" && vowel === "ウ") {
                prolongPattern = "[オォウゥー]";
            }
            else if (prevVowel === "エ" && vowel === "イ") {
                prolongPattern = "[エェイィー]";
            }
        }
        if (prolongPattern) {
            searchRegexpSeeds.push(prolongPattern);
        }
        else {
            // 特定のカナのパターン
            var kanaPattern = malleableKanaPatternTable[charUnit];
            if (kanaPattern) {
                searchRegexpSeeds.push(kanaPattern);
            }
            else {
                var bs = String.fromCharCode(92); // バックスラッシュ
                var unsafe = bs + ".+*?[^]$(){}=!<>¦|:";
                var safesearch = charUnit;
                var i = void 0;
                for (i = 0; i < unsafe.length; ++i) {
                    safesearch = safesearch.replace(new RegExp("\\" + unsafe.charAt(i), "g"), bs + unsafe.charAt(i));
                }
                searchRegexpSeeds.push(safesearch);
            }
        }
    });
    // ひらがなとカタカナのパターンを混合
    // ( (?: kata ) | (?: hira ) )
    searchRegexpSeeds.forEach(function (v, idx) {
        var pattern = "";
        var hiragana = __WEBPACK_IMPORTED_MODULE_0_fhconvert__["kktohg"](v);
        if (v !== hiragana) {
            if (v.length === 1) {
                pattern = "[" + v + hiragana + "]";
            }
            else {
                var pat_katakana = v;
                var pat_hirakana = hiragana;
                pattern = "(?:" + pat_katakana + "|" + pat_hirakana + ")";
            }
        }
        else {
            pattern = v;
        }
        searchRegexpSeeds[idx] = pattern;
    });
    // 各単位ごとに .? を挟んでパターンを作る
    var pattern = new RegExp(searchRegexpSeeds.join(".?"), "i");
    return pattern;
}


/***/ })

},[380]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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