webpackJsonp([4],{

/***/ 378:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__special_quick_advancer__ = __webpack_require__(379);

Object(__WEBPACK_IMPORTED_MODULE_0__special_quick_advancer__["a" /* default */])().run();


/***/ }),

/***/ 379:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = invoker;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_jquery__);

/** 数値をコンマ区切りに */
function encomma(num) {
    var numlook = num.toString();
    var numParts = numlook.split('.');
    numParts[0] = numParts[0]
        .split("").reverse().join("")
        .replace(/(\d{3}(?=\d))/g, '$1,')
        .split("").reverse().join("");
    var commalize = numParts[0];
    if (numParts[1])
        commalize += '.' + numParts[1];
    return commalize;
}
/** エセ $R */
function $R(_beg, _end) {
    var i = 0, ar = [];
    var beg = _beg, end = _end;
    if (!_end) {
        beg = 0;
        end = _beg - 1;
    }
    for (i = beg; i <= end; i++) {
        ar.push(i);
    }
    return ar;
}
/** 合計 */
function sum(nums) {
    var total = 0;
    for (var _i = 0, nums_1 = nums; _i < nums_1.length; _i++) {
        var n = nums_1[_i];
        total += n;
    }
    return total;
}
var STATS_ELM = '<stats>';
var EXP_CR = {
    '-4': 50,
    '-3': 65,
    '-2': 100,
    '-1': 135,
    '0': 200,
    '1': 400,
    '2': 600,
    '3': 800,
    '4': 1200,
    '5': 1600,
    '6': 2400,
    '7': 3200,
    '8': 4800,
    '9': 6400,
    '10': 9600,
    '11': 12800,
    '12': 19200,
    '13': 25600,
    '14': 38400,
    '15': 51200,
    '16': 76800,
    '17': 102400,
    '18': 153600,
    '19': 204800,
    '20': 307200,
    '21': 409600,
    '22': 614400,
    '23': 819200,
    '24': 1228800,
    '25': 1638400,
    '26': 2457600,
    '27': 3276800,
    '28': 4915200,
    '29': 6553600,
    '30': 9830400,
    '31': 13107200,
    '32': 19660800,
    '33': 26214400,
    '34': 39321600,
    '35': 52428800
};
var SIZE_TO_CODE = {
    '極小': -4,
    '微小': -3,
    '超小型': -2,
    '小型': -1,
    '中型': 0,
    '大型': 1,
    '超大型': 2,
    '巨大': 3,
    '超巨大': 4
};
var CODE_TO_SIZE = {
    '-4': '極小',
    '-3': '微小',
    '-2': '超小型',
    '-1': '小型',
    '0': '中型',
    '1': '大型',
    '2': '超大型',
    '3': '巨大',
    '4': '超巨大'
};
var SIZE_MOD = {
    '極小': { ATK: 8, AC: 8, CM: -8, FLY: 8, STEALTH: 16, SIZE: '極小' },
    '微小': { ATK: 4, AC: 4, CM: -4, FLY: 6, STEALTH: 12, SIZE: '微小' },
    '超小型': { ATK: 2, AC: 2, CM: -2, FLY: 4, STEALTH: 8, SIZE: '超小型' },
    '小型': { ATK: 1, AC: 1, CM: -1, FLY: 2, STEALTH: 4, SIZE: '小型' },
    '中型': { ATK: 0, AC: 0, CM: 0, FLY: 0, STEALTH: 0, SIZE: '中型' },
    '大型': { ATK: -1, AC: -1, CM: 1, FLY: -2, STEALTH: -4, SIZE: '大型' },
    '超大型': { ATK: -2, AC: -2, CM: 2, FLY: -4, STEALTH: -8, SIZE: '超大型' },
    '巨大': { ATK: -4, AC: -4, CM: 4, FLY: -6, STEALTH: -12, SIZE: '巨大' },
    '超巨大': { ATK: -8, AC: -8, CM: 8, FLY: -8, STEALTH: -16, SIZE: '超巨大' }
};
var DAMAGE_DICE = [
    '1d1',
    '1d2',
    '1d3',
    '1d4',
    '1d6',
    '1d8',
    '2d6',
    '3d6',
    '4d6',
    '6d6',
    '8d6',
    '12d6',
    null,
    '1d10',
    '2d8',
    '3d8',
    '4d8',
    '6d8',
    '8d8',
    '12d8'
];
function modifyDamageDice(_dice, _mod) {
    var baseIdx = DAMAGE_DICE.indexOf(_dice);
    var vec = _mod / Math.abs(_mod); // +1 か -1
    var dice = _dice;
    $R(1, Math.abs(_mod)).every(function (dif) {
        var tempDice = DAMAGE_DICE[baseIdx + (dif * vec)];
        if (tempDice) {
            dice = tempDice;
            return true;
        }
        else {
            return false;
        }
    });
    return dice;
}
var BeastUtil = {
    modifyDamageDice: modifyDamageDice
};
__WEBPACK_IMPORTED_MODULE_0_jquery__["extend"]({
    textNode: function (_text) {
        return __WEBPACK_IMPORTED_MODULE_0_jquery__(document.createTextNode(_text));
    }
});
__WEBPACK_IMPORTED_MODULE_0_jquery__["fn"].extend({
    /** テキストノードのみ */
    textNodes: function () {
        return this
            .contents()
            .filter(function () { return this.nodeType == 3; });
    },
    /** テキストノードのみ */
    allTextNodes: function (_ignoreSelector) {
        var $allTextNodes = __WEBPACK_IMPORTED_MODULE_0_jquery__();
        var traverser = function () {
            if (this.nodeType == 3) {
                $allTextNodes = $allTextNodes.add(this);
            }
            else if (this.hasChildNodes()) {
                if (_ignoreSelector && __WEBPACK_IMPORTED_MODULE_0_jquery__(this).is(_ignoreSelector)) {
                    return;
                }
                __WEBPACK_IMPORTED_MODULE_0_jquery__(this).contents().each(traverser);
            }
        };
        this.contents().each(traverser);
        return $allTextNodes;
    },
    // 値を修正
    modify: function (_mod, _hasSign) {
        var hasSign;
        if (typeof _hasSign === 'boolean' || !_hasSign) {
            hasSign = _hasSign ? ['signed'] : [];
        }
        else {
            hasSign = _hasSign;
        }
        return this.each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            var currValue = parseInt($this.attr('data-stats'));
            var newValue = currValue + _mod;
            if (hasSign.includes('least1')) {
                if (newValue < 1)
                    newValue = 1;
            }
            var newValueString = newValue.toString();
            if (hasSign.includes('encomma')) {
                newValueString = encomma(newValueString);
            }
            if (newValue >= 0 && hasSign.includes('signed')) {
                newValueString = '+' + newValueString;
            }
            newValueString = newValueString.replace('+', '＋').replace('-', '－');
            //$this.data('stats', newValue);
            $this.attr('data-stats', newValue);
            $this.addClass('modified');
            $this.text(newValueString);
        });
    },
    // 値を変更
    changeValue: function (_newValue, _hasSign) {
        var hasSign;
        if (typeof _hasSign === 'boolean' || !_hasSign) {
            hasSign = _hasSign ? ['signed'] : [];
        }
        else {
            hasSign = _hasSign;
        }
        return this.each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            var newValueString = _newValue.toString();
            if (hasSign.includes('encomma')) {
                newValueString = encomma(newValueString);
            }
            if (_newValue >= 0 && hasSign.includes('signed')) {
                newValueString = '+' + newValueString;
            }
            newValueString = newValueString.replace('+', '＋').replace('-', '－');
            $this.attr('data-stats', _newValue);
            $this.addClass('modified');
            $this.text(newValueString);
        });
    },
    // 値を変更
    changeStatsText: function (_newString) {
        return this.each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            $this.addClass('modified');
            $this.text(_newString);
        });
    },
    resetValue: function () {
        return this.each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            if ($this.is('[data-orig]')) {
                $this.text($this.attr('data-orig'));
                if ($this.attr('data-stats')) {
                    var stats = numlikeToNum($this.attr('data-orig'));
                    $this.attr('data-stats', stats);
                }
            }
            $this.removeClass('modified');
            if ($this.attr('data-orig').length == 0 && $this.attr('data-removable')) {
                $this.remove();
            }
        });
    },
    numlikeToNum: function () {
        return numlikeToNum(this.text());
    },
    nextContentUntil: function (_stopSelector) {
        var elems = [];
        this.each(function () {
            var sib = this;
            while (sib = sib.nextSibling) {
                if (__WEBPACK_IMPORTED_MODULE_0_jquery__(sib).is(_stopSelector))
                    break;
                elems.push(sib);
            }
        });
        return this.pushStack(elems);
    },
});
var BeastDetail = /** @class */ (function () {
    function BeastDetail(_beastNameHeaderElement) {
        this._memoizations = {};
        this.appliedTemplates = {
            advanced: false,
            degenerate: false,
            giant: false,
            young: false,
            resolute: false,
            entropic: false,
            fiendish: false,
            celestial: false
        };
        this.templateSetting = {
            'advanced': {
                discordable: ['degenerate'],
                stackable: false,
                modficator: true,
                template: true,
                namePrefix: 'アドヴァンスト・',
                method: 'applyAdvancedTemplate'
            },
            'degenerate': {
                discordable: ['advanced'],
                stackable: false,
                modficator: true,
                template: true,
                namePrefix: 'ディジェネレイト・',
                method: 'applyDegenerateTemplate'
            },
            'giant': {
                discordable: ['young'],
                stackable: false,
                modficator: true,
                template: true,
                namePrefix: 'ジャイアント・',
                method: 'applyGiantTemplate'
            },
            'young': {
                discordable: ['giant'],
                stackable: false,
                modficator: true,
                template: true,
                namePrefix: 'ヤング・',
                method: 'applyYoungTemplate'
            },
            'celestial': {
                discordable: ['fiendish'],
                stackable: false,
                modficator: true,
                template: true,
                namePrefix: 'セレスチャル種',
                method: 'applyCelestialTemplate'
            },
            'fiendish': {
                discordable: ['celestial'],
                stackable: false,
                modficator: true,
                template: true,
                namePrefix: 'フィーンディッシュ種',
                method: 'applyFiendishTemplate'
            },
            'entropic': {
                discordable: ['resolute'],
                stackable: false,
                modficator: true,
                template: true,
                namePrefix: 'エントロピック種',
                method: 'applyEntropicTemplate'
            },
            'resolute': {
                discordable: ['entropic'],
                stackable: false,
                modficator: true,
                template: true,
                namePrefix: 'レゾルート種',
                method: 'applyResoluteTemplate'
            },
            'clear': {
                discordable: [],
                stackable: true,
                modficator: false,
                method: 'clearAllTemplate'
            },
            'help': {
                discordable: [],
                stackable: true,
                modficator: false,
                method: null
            },
        };
        this.isReadiedAdvancementNamePrefix = false;
        this.isReadiedAllEntryLines = false;
        /** 行内の項目をまとめる。内容はテキストに変換する */
        this.isReadiedEntries = {};
        /** サイズを変更する */
        this.isReadiedSizeEntry = false;
        /** 属性を変更する */
        this.isReadiedAlignmentEntry = false;
        /** 呪文抵抗の項目の準備 */
        this.isReadiedSpellResistanceEntry = false;
        this.tableCRCodeToCR = {
            '-4': '1/8', '-3': '1/6', '-2': '1/4', '-1': '1/3', '0': '1/2',
        };
        this.tableCRToCRCode = {
            '1/8': -4, '1/6': -3, '1/4': -2, '1/3': -1, '1/2': 0,
        };
        //this.initMemoizations();
        this.nameHeader = __WEBPACK_IMPORTED_MODULE_0_jquery__(_beastNameHeaderElement);
        this.properties = this.nameHeader.nextUntil('h1, h2, h3').addBack();
        this._setupDividedStats();
        this.readyAllEntryLines();
        this._tagNumlikeText();
    }
    BeastDetail.prototype._setupDividedStats = function () {
        this.basicStats = this.nameHeader.nextUntil('h4, h3, h2, h1');
        this.defenseStats = this.properties.filter('h4:contains("防御")').nextUntil('h4, h3, h2, h1');
        this.offenseStats = this.properties.filter('h4:contains("攻撃")').nextUntil('h4, h3, h2, h1');
        this.generalStats = this.properties.filter('h4:contains("一般データ"), h4:contains("基本データ")').nextUntil('h4, h3, h2, h1');
    };
    BeastDetail.prototype.allStats = function () {
        return this.basicStats
            .add(this.defenseStats)
            .add(this.offenseStats)
            .add(this.generalStats);
    };
    BeastDetail.prototype._tagNumlikeText = function () {
        // アーマー・クラス
        var $acLine = this.armorClassLine();
        {
            var $acProp = $acLine.find('s>s');
            var acText = $acProp.text();
            $acProp.empty();
            var matched = void 0;
            if (matched = /^(.*?)（(＋\d.*)）$/.exec(acText)) {
                __WEBPACK_IMPORTED_MODULE_0_jquery__["textNode"](matched[1]).appendTo($acProp);
                __WEBPACK_IMPORTED_MODULE_0_jquery__["textNode"]('（').appendTo($acProp);
                __WEBPACK_IMPORTED_MODULE_0_jquery__('<s>').append(__WEBPACK_IMPORTED_MODULE_0_jquery__["textNode"](matched[2])).appendTo($acProp);
                __WEBPACK_IMPORTED_MODULE_0_jquery__["textNode"]('）').appendTo($acProp);
            }
            else {
                __WEBPACK_IMPORTED_MODULE_0_jquery__["textNode"](acText).appendTo($acProp);
                __WEBPACK_IMPORTED_MODULE_0_jquery__["textNode"]('（').appendTo($acProp);
                __WEBPACK_IMPORTED_MODULE_0_jquery__('<s>').appendTo($acProp);
                __WEBPACK_IMPORTED_MODULE_0_jquery__["textNode"]('）').appendTo($acProp);
            }
        }
        ;
        // 攻撃
        this.allAttackLines()
            .find('[data-label]>s')
            .allTextNodes()
            .each(function () {
            var text = __WEBPACK_IMPORTED_MODULE_0_jquery__(this).text();
            //<strong>近接</strong> 爪（×2）＝＋18（2d8＋6／19～20、加えて<dfn>［恐怖］</dfn>および“<dfn>つかみ</dfn>”）
            if (/＝[＋－]\d+/.test(text)) {
                var fragments = text.split(/(＝[＋－]\d+(?:／[＋－]\d+)*)/);
                var $texts = __WEBPACK_IMPORTED_MODULE_0_jquery__();
                fragments.forEach(function (frag) {
                    if (/^＝[＋－]\d+(?:／[＋－]\d+)*$/.test(frag)) {
                        $texts = $texts.add(__WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, {
                            text: frag,
                            attr: {
                                //'data-orig': frag,
                                'class': 'stats-attack-modifier stats'
                            }
                        }));
                    }
                    else {
                        $texts = $texts.add(__WEBPACK_IMPORTED_MODULE_0_jquery__["textNode"](frag));
                    }
                });
                $texts.insertBefore(this);
                __WEBPACK_IMPORTED_MODULE_0_jquery__(this).remove();
            }
        });
        // ダイス
        this.properties
            .allTextNodes()
            .each(function () {
            var text = __WEBPACK_IMPORTED_MODULE_0_jquery__(this).text();
            //<strong>近接</strong> 爪（×2）＝＋18（2d8＋6／19～20、加えて<dfn>［恐怖］</dfn>および“<dfn>つかみ</dfn>”）
            if (/\d+d\d+/.test(text)) {
                var fragments = text.split(/(\d+d\d+(?:[＋－]\d+)?)/);
                var $texts_1 = __WEBPACK_IMPORTED_MODULE_0_jquery__();
                fragments.forEach(function (frag) {
                    if (/^\d+d\d+(?:[＋－]\d+)?$/.test(frag)) {
                        var $diceRoll = __WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, { attr: { 'class': 'stats-dice-roll' } });
                        var matched = frag.match(/^(\d+d\d+)((?:[＋－]\d+)?)$/);
                        if (!matched)
                            matched = [];
                        $diceRoll.append(__WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, {
                            text: matched[1],
                            attr: {
                                'data-orig': matched[1],
                                'class': 'stats-dice stats'
                            }
                        }));
                        if (matched[2].length) {
                            $diceRoll = $diceRoll.append(__WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, {
                                text: matched[2],
                                attr: {
                                    'data-orig': matched[2],
                                    'data-stats': numlikeToNum(matched[2]),
                                    'class': 'stats-dice-modifier stats-value stats'
                                }
                            }));
                        }
                        $texts_1 = $texts_1.add($diceRoll);
                    }
                    else {
                        $texts_1 = $texts_1.add(__WEBPACK_IMPORTED_MODULE_0_jquery__["textNode"](frag));
                    }
                });
                $texts_1.insertBefore(this);
                __WEBPACK_IMPORTED_MODULE_0_jquery__(this).remove();
            }
        });
        this.properties
            .allTextNodes('.stats-value, .stats-dice')
            .each(_convertTextNodeToStasValueNodes);
        // マーマー・クラスの値に属性付
        $acLine.find('.stats-value')
            .each(function () {
            var prev = this.previousSibling, next = this.nextSibling, matched;
            if (matched = /(接触|立ちすくみ)/.exec(__WEBPACK_IMPORTED_MODULE_0_jquery__(prev).text())) {
                __WEBPACK_IMPORTED_MODULE_0_jquery__(this).attr('data-ac-key', matched[1]);
            }
            else if (matched = /^(【敏】|外皮|反発|サイズ)/.exec(__WEBPACK_IMPORTED_MODULE_0_jquery__(next).text())) {
                __WEBPACK_IMPORTED_MODULE_0_jquery__(this).attr('data-ac-key', matched[1]);
            }
        });
        // 能力値の値に属性付
        var abilityKeyDic = {
            '【筋】': 'str', '【敏】': 'dex', '【耐】': 'con',
            '【知】': 'int', '【判】': 'wis', '【魅】': 'cha'
        };
        this.abilityLine()
            .find('[data-label]')
            .each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            var key = abilityKeyDic[$this.attr('data-label')];
            $this
                .find('.stats-value')
                .addClass('stats-ability-' + key)
                .attr('data-ability-key', key);
        });
    };
    // メモ化関連
    //initMemoizations = memoize_initMemoizations;
    //clearMemoization = memoize_clearMemoization;
    //
    // 各行収集と項目抽出、値抽出
    //
    // イニシアチブ
    //@memo
    BeastDetail.prototype.initiativeLine = function () {
        return this.basicStats.find('span:has( strong:first-child:contains("イニシアチブ") )');
    };
    // イニシアチブ値
    BeastDetail.prototype.initiativeNum = function () {
        return this.initiativeLine().find('[data-label="イニシアチブ"]>s .stats-value:eq(0)');
    };
    // 感覚：〈知覚〉
    BeastDetail.prototype.sensePerceptionNum = function () {
        return this.initiativeLine().find('*:contains("〈知覚〉")').next('.stats-value');
    };
    //memo
    BeastDetail.prototype.armorClassLine = function () {
        return this.defenseStats
            .find('span:has( strong:first-child:contains("アーマー・クラス") )');
    };
    //@memo
    BeastDetail.prototype.hitPointLine = function () {
        return this.defenseStats.find('span:has( strong:first-child:contains("ヒット・ポイント") )');
    };
    //@memo
    BeastDetail.prototype.savingThrowLine = function () {
        return this.defenseStats
            .find('span:has( >[data-label="頑健"]:first-child )')
            .addClass('stats-line-saving-throw');
    };
    //@memo
    BeastDetail.prototype.defensiveAbilityLine = function () {
        var $da = this.defenseStats.find('span:has( strong:contains("防御的能力")   ),'
            + 'span:has( strong:contains("ダメージ減少") ),'
            + 'span:has( strong:contains("完全耐性")     ),'
            + 'span:has( strong:contains("呪文抵抗")     ),'
            + 'span:has( strong:contains("抵抗")         )');
        if (!$da.length) {
            $da = __WEBPACK_IMPORTED_MODULE_0_jquery__('<span>').appendTo(this.defenseStats.last());
        }
        return $da;
    };
    //@memo
    BeastDetail.prototype.melleeLine = function () {
        return this.offenseStats.find('span:has( strong:first-child:contains("近接") )');
    };
    //@memo
    BeastDetail.prototype.rangedLine = function () {
        return this.offenseStats.find('span:has( strong:first-child:contains("遠隔") )');
    };
    //@memo
    BeastDetail.prototype.specialAttackLine = function () {
        var $spaEntry = this.offenseStats.find('span:has(>[data-label="特殊攻撃"]:first-child)');
        if (!$spaEntry.length) {
            $spaEntry = __WEBPACK_IMPORTED_MODULE_0_jquery__('<span>').appendTo(this.offenseStats.last());
        }
        return $spaEntry;
    };
    BeastDetail.prototype.specialAttackEntry = function () {
        var $spaLine = this.specialAttackLine();
        var $spaEntry = $spaLine.find('[data-label="特殊攻撃"]:eq(0)');
        if (!$spaEntry.length) {
            $spaEntry = this.createPropEntry('特殊攻撃').appendTo($spaLine);
        }
        return $spaEntry;
    };
    //@memo
    BeastDetail.prototype.allAttackLines = function () {
        return __WEBPACK_IMPORTED_MODULE_0_jquery__()
            .add(this.melleeLine())
            .add(this.rangedLine())
            .add(this.specialAttackLine());
    };
    // 呪文、擬似呪文能力の見出し
    BeastDetail.prototype.concentrationNum = function () {
        return this.offenseStats
            .find('strong:contains("の擬似呪文能力")')
            .add('strong:contains("修得"):contains("呪文")')
            .add('strong:contains("準備済みの"):contains("呪文")')
            .nextUntil('strong', ':contains("精神集中")')
            .find(':contains("精神集中")')
            .next('.stats-value');
    };
    // 全体の難易度の値
    BeastDetail.prototype.difficultyClassNum = function () {
        return this.properties.find('.xref:contains("難易度")')
            .filter(function () { return __WEBPACK_IMPORTED_MODULE_0_jquery__(this).text() == '難易度'; })
            .next('.stats-value');
    };
    //@memo
    BeastDetail.prototype.basicAttackLine = function () {
        return this.generalStats.find('span:has( strong:first-child:contains("基本攻撃") )');
    };
    // 戦技ボーナス
    BeastDetail.prototype.cmBonusNum = function () {
        return this.basicAttackLine()
            .find('strong:contains("戦技ボーナス"):eq(0)')
            .nextUntil('strong', 's:has(.stats-value)')
            .find('.stats-value');
    };
    // 戦技防御値
    BeastDetail.prototype.cmDefenseNum = function () {
        return this.basicAttackLine()
            .find('strong:contains("戦技防御値"):eq(0)')
            .nextUntil('strong', 's:has(.stats-value)')
            .find('.stats-value');
    };
    //@memo
    BeastDetail.prototype.abilityLine = function () {
        return this.generalStats
            .children('span:has( >[data-label="【筋】"]:first-child )')
            .addClass('stats-line-ability');
    };
    //@memo
    BeastDetail.prototype.skillLine = function () {
        return this.generalStats.find('span:has( strong:first-child:contains("技能") )');
    };
    //@memo
    BeastDetail.prototype.featLine = function () {
        return this.generalStats.find('span:has( strong:first-child:contains("特技") )');
    };
    //@memo
    BeastDetail.prototype.experienceLine = function () {
        return this.basicStats.find('span:has( strong:first-child:contains("経験点") )');
    };
    //@memo
    BeastDetail.prototype.creatureTypeLine = function () {
        return this.basicStats
            .children()
            .filter(function () {
            return /^(?:真なる中立|(?:混沌|中立|秩序)にして)/
                .test(__WEBPACK_IMPORTED_MODULE_0_jquery__(this).text());
        })
            .first();
    };
    //@memo
    BeastDetail.prototype.isIncorporeal = function () {
        return !!this.creatureTypeLine().find('.xref:contains("非実体")').length;
    };
    //@memo
    BeastDetail.prototype.isConstruct = function () {
        return !!this.creatureTypeLine().find('.xref:contains("人造")').length;
    };
    //@memo
    BeastDetail.prototype.hitDice = function () {
        var hitDiceNum = 0;
        var _tmp = this.hitPointLine()
            .find('.stats-dice:eq(0)')
            .text().match(/\d+/);
        var hitDiceString = _tmp !== null ? _tmp[0] : "";
        var _matched = (hitDiceString).match(/(\d+)[／\/](\d+)/);
        if (_matched) {
            hitDiceNum = parseInt(_matched[1]) / parseInt(_matched[2]);
        }
        else {
            hitDiceNum = parseInt(hitDiceString);
        }
        return hitDiceNum;
    };
    BeastDetail.prototype.readyAdvancementNamePrefix = function () {
        if (this.isReadiedAdvancementNamePrefix)
            return;
        var baseName = this.nameHeader.text().replace(/[　 ]*脅威度.*/, '').trim();
        this.nameHeader.append(__WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, {
            attr: {
                'class': 'advancement-name-prefix',
                'data-orig': '',
                'data-base-name': baseName,
            }
        }));
        this.isReadiedAdvancementNamePrefix = true;
    };
    BeastDetail.prototype.resetAdvancementNamePrefix = function () {
        if (!this.isReadiedAdvancementNamePrefix)
            return;
        this.nameHeader.find('.advancement-name-prefix').remove();
        this.isReadiedAdvancementNamePrefix = false;
    };
    BeastDetail.prototype.changeCreatureName = function () {
        var _this = this;
        this.readyAdvancementNamePrefix();
        var prefix = '';
        Object.keys(this.templateSetting).forEach(function (k) {
            var v = _this.templateSetting[k];
            if (v.namePrefix && _this.appliedTemplates[k]) {
                prefix += v.namePrefix;
            }
        });
        var $name = this.nameHeader.find('.advancement-name-prefix');
        $name.text(prefix + $name.data('base-name'));
    };
    BeastDetail.prototype.getMethod = function (methodName) {
        var method = this[methodName];
        if (method instanceof Function) {
            return method.bind(this);
        }
        throw new Error(methodName + " doesn't exists in " + this);
    };
    BeastDetail.prototype.applyAdvancement = function (advancementTarget) {
        var setting = this.templateSetting[advancementTarget];
        var methodName = setting.method;
        //this.initMemoizations();
        if (methodName && setting.template && this.isAppliable(advancementTarget)) {
            this.getMethod(methodName)();
            this.appliedTemplates[advancementTarget] = true;
            this.changeCreatureName();
            return setting.modficator;
        }
        else if (methodName && !setting.template) {
            this.getMethod(methodName)();
        }
    };
    BeastDetail.prototype.isAppliable = function (templateName) {
        var _this = this;
        var isAppliable = true, applied = this.appliedTemplates[templateName], setting = this.templateSetting[templateName];
        if (applied && !setting.stackable) {
            isAppliable = false;
        }
        else if (setting.discordable.some(function (discordant) {
            return _this.appliedTemplates[discordant];
        })) {
            isAppliable = false;
        }
        return isAppliable;
    };
    // TODO: （非実体）の反発が0以下になってしまう。
    BeastDetail.prototype.modifyArmorClass = function (_acObj) {
        var isFlatfooted = ['反発', '外皮', 'サイズ'];
        var isTouched = ['反発', '【敏】', 'サイズ'];
        var wholeModifier = sum(Object.values(_acObj));
        var flatfootedModifier = 0;
        for (var _i = 0, _a = Object.keys(_acObj); _i < _a.length; _i++) {
            var bonusType = _a[_i];
            if (isFlatfooted.includes(bonusType)) {
                flatfootedModifier += _acObj[bonusType];
            }
        }
        var touchModifier = 0;
        for (var _b = 0, _c = Object.keys(_acObj); _b < _c.length; _b++) {
            var bonusType = _c[_b];
            if (isTouched.includes(bonusType)) {
                touchModifier += _acObj[bonusType];
            }
        }
        //console.log( _acObj, flatfootedModifier, touchModifier );
        var $acLine = this.armorClassLine();
        var $acPart = $acLine.find('s>s s:eq(0)');
        Object.keys(_acObj)
            .forEach(function (bonusType) {
            if (!$acLine.find('[data-ac-key="' + bonusType + '"]').length) {
                __WEBPACK_IMPORTED_MODULE_0_jquery__["textNode"]('、').appendTo($acPart);
                __WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, { text: '0', attr: { 'class': 'stats-value', 'data-stats': 0, 'data-orig': 0, 'data-ac-key': bonusType } }).appendTo($acPart);
                __WEBPACK_IMPORTED_MODULE_0_jquery__('<span>', { text: bonusType }).appendTo($acPart);
            }
        });
        $acLine.find('.stats-value:eq(0)').modify(wholeModifier);
        $acLine.find('.stats-value[data-ac-key="立ちすくみ"]').modify(flatfootedModifier);
        $acLine.find('.stats-value[data-ac-key="接触"]').modify(touchModifier);
        Object.keys(_acObj).forEach(function (bonusType) {
            var modifier = _acObj[bonusType];
            $acLine.find('.stats-value[data-ac-key="' + bonusType + '"]')
                .modify(modifier, ['signed'])
                .length;
        });
        // 外皮が0未満の場合
        var $naStat = $acLine.find('.stats-value[data-ac-key="外皮"]');
        if ($naStat.length) {
            var naValue = parseInt($naStat.attr('data-stats'));
            if (naValue < 0) {
                $acLine.find('.stats-value[data-ac-key="外皮"]').changeValue(0);
                //console.log( naValue , naValue.abs() );
                $acLine.find('.stats-value:eq(0)').modify(Math.abs(naValue));
                $acLine.find('.stats-value[data-ac-key="立ちすくみ"]').modify(Math.abs(naValue));
            }
        }
    };
    BeastDetail.prototype.clearAllTemplate = function () {
        var _this = this;
        this.properties.find('[data-orig]')
            .each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            $this.resetValue();
        });
        Object.keys(this.appliedTemplates)
            .forEach(function (k) {
            _this.appliedTemplates[k] = false;
        });
        this.nameHeader
            .find('span.advancementControl > button.disabled')
            .removeClass('disabled');
        this.resetAdvancementNamePrefix();
    };
    BeastDetail.prototype.applyAdvancedTemplate = function () {
        // 非実体クリーチャーかどうか
        var isIncorporeal = this.isIncorporeal();
        // 人造クリーチャーかどうか
        var isConstruct = this.isConstruct();
        // イニシアチブの行
        this.initiativeNum().modify(2, true);
        this.sensePerceptionNum().modify(2, true);
        // アーマー・クラスの行
        this.modifyArmorClass(isIncorporeal ? { '【敏】': 2, '反発': 2 } : { '【敏】': 2, '外皮': 2 });
        // ヒット・ポイントの行
        this.hitPointLine().find('.stats-value:eq(0)').modify(2 * this.hitDice());
        this.hitPointLine().find('.stats-value:eq(1)').modify(2 * this.hitDice(), true);
        // セーヴィング・スロー
        this.savingThrowLine().find('.stats-value').each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            if ($this.parent().prev('strong').text() == '頑健') {
                if (!isConstruct)
                    __WEBPACK_IMPORTED_MODULE_0_jquery__(this).modify(2, true);
            }
            else {
                __WEBPACK_IMPORTED_MODULE_0_jquery__(this).modify(2, true);
            }
        });
        // 攻撃
        this.allAttackLines()
            .find('.stats-attack-modifier > .stats-value').modify(2, true);
        // 戦技
        this.cmBonusNum().modify(2, true);
        this.cmDefenseNum().modify(4);
        // ダメージ
        this.modifyDamage(2);
        // 精神集中
        this.concentrationNum().modify(2, true);
        // 能力値
        this.abilityLine().find('.stats-value').modify(4);
        // 技能
        this.modifySkills(2);
        // 脅威度
        this.modifyChallengeRating(1);
        // 全体の難易度
        this.difficultyClassNum().modify(2);
    };
    BeastDetail.prototype.applyDegenerateTemplate = function () {
        // 非実体クリーチャーかどうか
        var isIncorporeal = this.isIncorporeal();
        // 人造クリーチャーかどうか
        var isConstruct = this.isConstruct();
        // イニシアチブの行
        this.initiativeNum().modify(-2, true);
        this.sensePerceptionNum().modify(-2, true);
        // アーマー・クラスの行
        this.modifyArmorClass(isIncorporeal
            ? { '【敏】': -2, '反発': -2 }
            : { '【敏】': -2 });
        // ヒット・ポイントの行
        if (!isConstruct) {
            this.hitPointLine().find('.stats-value:eq(0)').modify(-2 * this.hitDice());
            this.hitPointLine().find('.stats-value:eq(1)').modify(-2 * this.hitDice(), true);
        }
        // セーヴィング・スロー
        this.savingThrowLine().find('.stats-value').each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            if ($this.parent().prev('strong').text() == '頑健') {
                if (!isConstruct)
                    __WEBPACK_IMPORTED_MODULE_0_jquery__(this).modify(-2, true);
            }
            else {
                __WEBPACK_IMPORTED_MODULE_0_jquery__(this).modify(-2, true);
            }
        });
        // 攻撃
        this.allAttackLines()
            .find('.stats-attack-modifier > .stats-value').modify(-2, true);
        // 戦技
        this.cmBonusNum().modify(-2, true);
        this.cmDefenseNum().modify(-2);
        // ダメージ
        this.modifyDamage(-2);
        // 精神集中
        this.concentrationNum().modify(-2, true);
        // 能力値
        this.abilityLine().find('.stats-value').modify(-4, ['least1']);
        // 技能
        this.modifySkills(-2);
        // 脅威度
        this.modifyChallengeRating(-1);
        // 全体の難易度
        this.difficultyClassNum().modify(-2);
    };
    // ダメージを修正
    BeastDetail.prototype.modifyDamage = function (strMod) {
        var strengthValue = this.generalStats.find('.stats-ability-str').data('stats');
        var strengthModifier = Math.floor(strengthValue / 2) - 5;
        var appliedStrengthModifier = strengthModifier + strMod;
        var strengthModifierOnehalf = Math.floor(strengthModifier * 1.5);
        this.melleeLine().add(this.specialAttackLine())
            .find('.stats-dice-roll > .stats-dice-modifier')
            .each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            var damageModifier = $this.data('stats');
            var weaponModifier = 0, matched, prev = $this.parent().get(0).previousSibling;
            if (prev && __WEBPACK_IMPORTED_MODULE_0_jquery__(prev).is('em')) {
                if (matched = /^＋(\d+)/.exec(__WEBPACK_IMPORTED_MODULE_0_jquery__(prev).text())) {
                    weaponModifier = parseInt(matched[1]);
                }
            }
            var abilityModifier = damageModifier - weaponModifier;
            // 元の【筋力】修正値が1以下だった場合は対応できない
            if (abilityModifier >= 3 &&
                abilityModifier == strengthModifierOnehalf) {
                var mod = Math.floor(appliedStrengthModifier * 1.5)
                    - damageModifier + weaponModifier;
                $this.modify(mod, true);
            }
            else {
                $this.modify(strMod, true);
            }
        });
    };
    BeastDetail.prototype.modifyDamageDice = function (_mod) {
        this.melleeLine().add(this.specialAttackLine())
            .find('.stats-dice-roll:has(> .stats-dice-modifier) > .stats-dice')
            .each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            var newDice = BeastUtil.modifyDamageDice($this.text(), _mod);
            $this.addClass('modified');
            $this.text(newDice);
        });
    };
    /** ジャイアント・テンプレート */
    BeastDetail.prototype.applyGiantTemplate = function () {
        this._applySizedBaseTemplate({
            str: 4,
            dex: -2,
            con: 4,
            size: 1,
            cr: 1,
            naturalArmor: 3
        });
    };
    /** ヤング・テンプレート */
    BeastDetail.prototype.applyYoungTemplate = function () {
        this._applySizedBaseTemplate({
            str: -4,
            dex: 4,
            con: -4,
            size: -1,
            cr: -1,
            naturalArmor: -2
        });
    };
    /** サイズに基づくテンプレート */
    BeastDetail.prototype._applySizedBaseTemplate = function (_sizeObj) {
        var strAdj = _sizeObj.str;
        var dexAdj = _sizeObj.dex;
        var conAdj = _sizeObj.con;
        var sizeAdj = _sizeObj.size;
        var crAdj = _sizeObj.cr;
        var nArmorMod = _sizeObj.naturalArmor;
        var strMod = strAdj / 2, dexMod = dexAdj / 2, conMod = conAdj / 2;
        var oldSizeName = this.lookSize(), newSizeName = this.modifySize(sizeAdj);
        var beforeSize = SIZE_MOD[oldSizeName];
        var nowSize = SIZE_MOD[newSizeName];
        // 非実体クリーチャーかどうか
        var isIncorporeal = this.isIncorporeal();
        // 人造クリーチャーかどうか
        var isConstruct = this.isConstruct();
        // 《武器の妙技》を持っているか
        var isHasWeaponFiness = /《武器の妙技》/.test(this.featLine().text());
        // 《武器の妙技》を持っているか
        var isHasAgileManuevers = /《軽妙なる戦術》/.test(this.featLine().text());
        // イニシアチブの行
        this.initiativeNum().modify(dexMod, true);
        // アーマー・クラスの行
        var sizeModAC = nowSize.AC - beforeSize.AC;
        var acMod = isIncorporeal
            ? { '【敏】': dexMod, 'サイズ': sizeModAC }
            : { '外皮': nArmorMod, '【敏】': dexMod, 'サイズ': sizeModAC };
        this.modifyArmorClass(acMod);
        // ヒット・ポイントの行
        if (!isIncorporeal && !isConstruct) {
            this.hitPointLine().find('.stats-value:eq(0)').modify(conMod * this.hitDice());
            this.hitPointLine().find('.stats-value:eq(1)').modify(conMod * this.hitDice(), true);
        }
        // セーヴィング・スロー
        this.savingThrowLine().find('.stats-value').each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            if ($this.parent().prev('strong').text() == '頑健') {
                if (!isIncorporeal && !isConstruct) {
                    __WEBPACK_IMPORTED_MODULE_0_jquery__(this).modify(conMod, true);
                }
            }
            else if ($this.parent().prev('strong').text() == '反応') {
                __WEBPACK_IMPORTED_MODULE_0_jquery__(this).modify(dexMod, true);
            }
        });
        // 攻撃
        var sizeModATK = nowSize.ATK - beforeSize.ATK;
        var melleeAbilityMod = strMod;
        if (isHasWeaponFiness || isIncorporeal) {
            melleeAbilityMod = dexMod;
        }
        this.melleeLine().find('.stats-attack-modifier > .stats-value').modify(melleeAbilityMod + sizeModATK, true);
        this.rangedLine().find('.stats-attack-modifier > .stats-value').modify(dexMod + sizeModATK, true);
        // ダメージ
        this.modifyDamage(strMod);
        this.modifyDamageDice(sizeAdj);
        // 戦技
        var sizeModCM = nowSize.CM - beforeSize.CM;
        var cmbAbilityMod = strMod;
        if (isHasAgileManuevers || isIncorporeal) {
            cmbAbilityMod = dexMod;
        }
        this.cmBonusNum()
            .modify(cmbAbilityMod + sizeModCM, true);
        this.cmDefenseNum()
            .modify((isIncorporeal ? 0 : strMod)
            + dexMod + sizeModCM);
        // 能力値
        var statsValue = this.abilityLine().find('.stats-value');
        statsValue.filter('.stats-ability-str').modify(strAdj);
        statsValue.filter('.stats-ability-dex').modify(dexAdj);
        statsValue.filter('.stats-ability-con').modify(conAdj);
        // 技能
        var sizeModFLY = nowSize.FLY - beforeSize.FLY;
        var sizeModSTEALTH = nowSize.STEALTH - beforeSize.STEALTH;
        if (!isIncorporeal)
            this.modifySkills(strMod, ['水泳', '登攀']);
        this.modifySkills(dexMod, ['軽業', '騎乗', '装置無力化', '脱出術', '手先の早業']);
        this.modifySkills(dexMod + sizeModSTEALTH, ['隠密']);
        this.modifySkills(dexMod + sizeModFLY, ['飛行']);
        console.log(sizeModSTEALTH);
        // 脅威度
        this.modifyChallengeRating(crAdj);
    };
    BeastDetail.prototype.modifySkills = function (_mod, _targets) {
        var current;
        this.skillLine()
            .children().eq(0)
            .find('.xref, .stats-value')
            .filter(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            if ($this.hasClass('xref')) {
                if (/^〈.*?[〉：]$/.test($this.text())) {
                    current = $this.text().replace(/〈|：.*|〉/g, '');
                }
                return false;
            }
            var available = true;
            if (available) {
                $this.attr('data-skill', current);
            }
            if (_targets && !_targets.includes(current)) {
                available = false;
            }
            return available;
        })
            .modify(_mod, true);
    };
    BeastDetail.prototype.calcAlignedTemplateResistance = function () {
        var hitDice = this.hitDice(), resistanceValue = 5;
        if (hitDice <= 4) {
            resistanceValue = 5;
        }
        else if (hitDice <= 10) {
            resistanceValue = 10;
        }
        else {
            resistanceValue = 15;
        }
        return resistanceValue;
    };
    BeastDetail.prototype.calcAlignedTemplateDReduction = function () {
        var hitDice = this.hitDice(), reductionValue = 0;
        if (hitDice <= 4) {
            reductionValue = 0;
        }
        else if (hitDice <= 10) {
            reductionValue = 5;
        }
        else {
            reductionValue = 10;
        }
        return reductionValue;
    };
    BeastDetail.prototype.readyAllEntryLines = function () {
        if (this.isReadiedAllEntryLines)
            return;
        var self = this;
        this.allStats()
            .find('>span')
            .each(function () {
            self.readyEntryLine(__WEBPACK_IMPORTED_MODULE_0_jquery__(this));
        });
        this.isReadiedAllEntryLines = true;
    };
    BeastDetail.prototype.readyEntryLine = function ($node) {
        $node.last().find('br').remove();
        //var $entries =
        $node
            .children('strong')
            .map(function () {
            var $entryProps = __WEBPACK_IMPORTED_MODULE_0_jquery__(this).nextContentUntil('strong');
            var $entryWhole = $entryProps.addBack();
            $entryProps.each(function (idx) {
                if (this instanceof Text) {
                    if (idx === 0 && this.nodeType === 3) {
                        this.data = this.data.replace(/^[ 　]+/, '');
                    }
                    if (idx == $entryProps.length - 1 && this.nodeType === 3) {
                        this.data = this.data.replace(/[　 ]*[；、][　 ]*$/, '');
                    }
                }
            });
            $entryWhole = $entryWhole
                .wrapAll('<s>')
                .parent()
                .attr('data-label', __WEBPACK_IMPORTED_MODULE_0_jquery__(this).text());
            $entryProps = $entryProps.wrapAll('<s>').parent();
            return $entryWhole;
        });
        //console.log( $entries );
    };
    BeastDetail.prototype.attachDarkvision = function (_range) {
        var initiativeLineText = this.initiativeLine().text();
        var matched = initiativeLineText.match(/暗視\s*(\d+)/);
        if (!matched) {
            this.initiativeLine().find('[data-label="感覚"]>s').prepend(__WEBPACK_IMPORTED_MODULE_0_jquery__["textNode"]('暗視' + _range + 'フィート、'));
        }
        else if (parseInt(matched[1]) < _range) {
            this.initiativeLine().find('.xref:contains("暗視")').next('.stats-value').changeValue(_range);
        }
    };
    BeastDetail.prototype.readyEntry = function ($_parentLine, _labelText, _classes) {
        //console.log( $_parentLine, _labelText );
        if (this.isReadiedEntries[_labelText])
            return;
        var entryText = "";
        // テキストを集めて保存し、一旦削除する
        var $entry = $_parentLine
            .children('[data-label="' + _labelText + '"]')
            .first();
        // ノード等を削除
        if ($entry.length) {
            var $node = $entry.find('>s:eq(0)');
            entryText = $node.text();
            $node.empty();
        }
        else {
            $entry = this.createPropEntry(_labelText).appendTo($_parentLine);
        }
        $entry.find('>s').append(__WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, {
            text: entryText,
            attr: { 'class': _classes, 'data-orig': entryText }
        }));
        this.isReadiedEntries[_labelText] = true;
    };
    /** 抵抗の編集 */
    BeastDetail.prototype.editResistance = function (_resistanceObj) {
        var resistanceKeys = Object.keys(_resistanceObj);
        // 下準備
        this.readyEntry(this.defensiveAbilityLine(), '抵抗', 'stats-resistance stats');
        var resistsText = this.defensiveAbilityLine().find('.stats-resistance').text();
        var matched;
        resistanceKeys.forEach(function (_key) {
            if (!(new RegExp('［' + _key + '］')).test(resistsText)) {
                resistsText = resistsText.replace(/$/, '、［' + _key + '］0');
            }
        });
        resistsText = resistsText.replace(/^\s*、?/, '');
        var regexp = new RegExp('［(' + resistanceKeys.join('|') + ')］(\\d+)', 'g');
        var energyType = '', resistanceValue = 0;
        while (matched = regexp.exec(resistsText)) {
            energyType = matched[1];
            resistanceValue = _resistanceObj[energyType];
            if (parseInt(matched[2]) < resistanceValue) {
                resistsText = resistsText.replace(new RegExp('［' + energyType + '］\\d+'), '［' + energyType + '］' + resistanceValue);
            }
        }
        this.defensiveAbilityLine()
            .find('[data-label="抵抗"] .stats-resistance')
            .changeStatsText(resistsText);
        //console.log( resistsText );
    };
    /** ダメージ減少の編集 */
    BeastDetail.prototype.editDReduction = function (_drObj) {
        var drKeys = Object.keys(_drObj);
        // 下準備
        this.readyEntry(this.defensiveAbilityLine(), 'ダメージ減少', 'stats-dr stats');
        var drText = this.defensiveAbilityLine().find('.stats-dr').text();
        var matched;
        drKeys.forEach(function (_key) {
            if (!(new RegExp('\\d+／' + _key)).test(drText)) {
                drText = drText.replace(/$/, '、0／' + _key);
            }
        });
        drText = drText.replace(/^\s*、?/, '');
        var regexp = new RegExp('(\\d+)／(' + drKeys.join('|') + ')', 'g');
        var damageType = '', drValue = 0;
        while (matched = regexp.exec(drText)) {
            damageType = matched[2];
            drValue = _drObj[damageType];
            if (parseInt(matched[1]) < drValue) {
                drText = drText.replace(new RegExp('\\d+／' + damageType), drValue + '／' + damageType);
            }
        }
        this.defensiveAbilityLine()
            .find('.stats-dr')
            .changeStatsText(drText);
    };
    BeastDetail.prototype.readySizeEntry = function () {
        if (this.isReadiedSizeEntry)
            return;
        // var $type = this.creatureTypeLine();
        // var rx = /／(超?(?:[大中小]型|巨大)|[微極]小)/;
        // $type.textNodes().each(function(){
        //     //console.log( this );
        //     var matched, size, $this = $(this);
        //     if( matched = rx.exec( this.data ) ){
        //         size = matched[1];
        //         //console.log( this.parentNode, this, size );
        //         this.parentNode.insertBefore( $.textNode('／').get(0), this );
        //         this.parentNode.insertBefore( $(STATS_ELM, {text: size, attr:{'data-orig': size, 'class':'stats stats-size'}}).get(0), this );
        //         this.data = this.data.replace( rx, '' );
        //         return false;
        //     }
        // });
        var $type = this.creatureTypeLine();
        $type.allTextNodes().each(function () {
            var matched, size;
            if (matched = /^(／?)(超?(?:[大中小]型|巨大)|[微極]小)(?:サイズ)?$/.exec(this.data)) {
                var preSlash = matched[1];
                size = matched[2];
                //console.log( this.parentNode, this, size );
                // ／○型 のとき、「／」だけ手前に追加しておく
                if (preSlash) {
                    this.parentNode.insertBefore(document.createTextNode('／'), this);
                }
                // 「○型」のノードを作り、手前に挿入
                this.parentNode.insertBefore(__WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, {
                    text: size,
                    attr: { 'data-orig': size, 'class': 'stats stats-size' }
                }).get(0), this);
                this.data = this.data.replace(/^／?(超?(?:[大中小]型|巨大)|[微極]小)/, '');
                return false;
            }
            return;
        });
        this.isReadiedSizeEntry = true;
    };
    BeastDetail.prototype.lookSize = function () {
        this.readySizeEntry();
        return this.creatureTypeLine().find('.stats-size').text();
    };
    BeastDetail.prototype.modifySize = function (_mod) {
        this.readySizeEntry();
        var $type = this.creatureTypeLine();
        var $size = $type.find('.stats-size');
        var sizeCode = SIZE_TO_CODE[$size.text()];
        var newSizeCode = sizeCode + _mod;
        if (Math.abs(newSizeCode) > 4) {
            return "";
        }
        var newSize = CODE_TO_SIZE[newSizeCode];
        $size.changeStatsText(newSize);
        return newSize;
    };
    BeastDetail.prototype.readyAlignmentEntry = function () {
        if (this.isReadiedAlignmentEntry)
            return;
        this.creatureTypeLine()
            .find('.xref:first-child')
            .each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            $this.wrapInner(__WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, { 'data-orig': $this.text(), 'class': 'stats stats-alignment' }));
        });
        this.isReadiedAlignmentEntry = true;
    };
    BeastDetail.prototype.changeAlignment = function (newAlignment, _axisGE) {
        //var alignmentLine = this.basicStats.find('span:has( strong:first-child:contains("経験点") ) + span');
        this.readyAlignmentEntry();
        var alignmentLine = this.creatureTypeLine();
        alignmentLine.find('.xref:first-child > .stats-alignment')
            .each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            var text = $this.text();
            if (text == '真なる中立') {
                text = '中立にして中立';
            }
            if (_axisGE && /にして(?:[善悪]|中立)/.test(text)) {
                text = text.replace(/にして(?:[善悪]|中立)/, 'にして' + newAlignment);
            }
            else if (/(?:秩序|中立|混沌)にして/.test(text)) {
                text = text.replace(/(?:秩序|中立|混沌)にして/, newAlignment + 'にして');
            }
            if (text == '中立にして中立') {
                text = '真なる中立';
            }
            $this.changeStatsText(text);
        });
    };
    BeastDetail.prototype.createPropEntry = function (_label) {
        var $entry = __WEBPACK_IMPORTED_MODULE_0_jquery__('<s>', { attr: { 'data-label': _label } });
        var $entryLabel = __WEBPACK_IMPORTED_MODULE_0_jquery__('<strong>', { text: _label });
        var $entryProp = __WEBPACK_IMPORTED_MODULE_0_jquery__('<s>').appendTo($entry);
        $entryLabel.appendTo($entry);
        $entryProp.appendTo($entry);
        return $entry;
    };
    BeastDetail.prototype.readySpellResistanceEntry = function () {
        if (this.isReadiedSpellResistanceEntry)
            return;
        var $sr = this.defensiveAbilityLine().find('[data-label="呪文抵抗"]');
        if (!$sr.length) {
            $sr = this.createPropEntry('呪文抵抗');
            var $entryProp = $sr.children('s:eq(0)');
            __WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, { text: 0, attr: { 'data-orig': 0, 'data-stats': 0, 'class': 'stats-value stats-sr stats' } }).appendTo($entryProp);
            this.defensiveAbilityLine().append($sr);
        }
        else {
            $sr.find('s .stats-value:eq(0)').addClass('stats-sr');
        }
        this.isReadiedSpellResistanceEntry = true;
    };
    /** 呪文抵抗を編集 */
    BeastDetail.prototype.changeSpellResistance = function (_newSR, _force) {
        this.readySpellResistanceEntry();
        var $sr = this.defensiveAbilityLine().find('.stats-sr');
        if (_force || $sr.data('stats') < _newSR) {
            $sr.changeValue(_newSR);
        }
    };
    BeastDetail.prototype.addSpecialAttack = function (_spAttack) {
        var $spaEntry = this.specialAttackEntry();
        var $spaProp = $spaEntry.children('s:eq(0)');
        //console.log( $spa );
        //console.log( $spa, _spAttack );
        var isSPAEmpty = !$spaProp.text();
        if ($spaProp.text().indexOf(_spAttack) == -1) {
            var $atk = __WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, { text: (isSPAEmpty ? '' : '、') + _spAttack, attr: { 'data-orig': '', 'data-removable': true, 'class': 'stats modified' } });
            $atk.appendTo($spaProp);
        }
    };
    /** セレスチャル種テンプレート */
    BeastDetail.prototype.applyCelestialTemplate = function () {
        this.applyAlignedTemplate({
            alignment: '善',
            oppositeAlignment: '悪',
            alignmentAxisGE: true,
            resistanceTypes: ['強酸', '雷撃', '氷雪'],
        });
    };
    /** フィーンディッシュ種テンプレート */
    BeastDetail.prototype.applyFiendishTemplate = function () {
        this.applyAlignedTemplate({
            alignment: '悪',
            oppositeAlignment: '善',
            alignmentAxisGE: true,
            resistanceTypes: ['火炎', '氷雪'],
        });
    };
    /** レゾルート種テンプレート */
    BeastDetail.prototype.applyResoluteTemplate = function () {
        this.applyAlignedTemplate({
            alignment: '秩序',
            oppositeAlignment: '混沌',
            alignmentAxisGE: false,
            resistanceTypes: ['強酸', '火炎', '氷雪'],
        });
    };
    /** エントロピック種テンプレート */
    BeastDetail.prototype.applyEntropicTemplate = function () {
        this.applyAlignedTemplate({
            alignment: '混沌',
            oppositeAlignment: '秩序',
            alignmentAxisGE: false,
            resistanceTypes: ['強酸', '火炎'],
        });
    };
    /** 属性基準種テンプレート */
    BeastDetail.prototype.applyAlignedTemplate = function (_opts) {
        var alignment = _opts.alignment, oppositeAlignment = _opts.oppositeAlignment, alignmentAxisGE = _opts.alignmentAxisGE, resistanceTypes = _opts.resistanceTypes;
        var hitDice = this.hitDice(), darkvisionRange = 60, resistanceValue = this.calcAlignedTemplateResistance(), reductionValue = this.calcAlignedTemplateDReduction(), resistances = {}, damageReductions = {};
        this.attachDarkvision(darkvisionRange);
        resistanceTypes.forEach(function (type) {
            resistances[type] = resistanceValue;
        });
        damageReductions[oppositeAlignment] = reductionValue;
        // ダメージ減少
        if (reductionValue > 0)
            this.editDReduction(damageReductions);
        // 抵抗
        if (resistanceValue)
            this.editResistance(resistances);
        // 脅威度
        if (hitDice >= 5)
            this.modifyChallengeRating(1);
        // 属性
        this.changeAlignment(alignment, alignmentAxisGE);
        // 呪文抵抗
        var sr = this.lookCRCode() + 5;
        this.changeSpellResistance(sr);
        // 特殊攻撃：〇〇を討つ一撃
        var smite = oppositeAlignment + 'を討つ一撃';
        this.addSpecialAttack(smite);
    };
    BeastDetail.prototype.bringCRCode = function (_CRStr) {
        if (/^\d+$/.test(_CRStr)) {
            return parseInt(_CRStr);
        }
        else if (this.tableCRToCRCode[_CRStr] !== undefined) {
            return this.tableCRToCRCode[_CRStr];
        }
        throw new Error("Invalid CR number: " + _CRStr);
    };
    BeastDetail.prototype.convertCRCodeToCR = function (_CRCode) {
        if (_CRCode > 0) {
            return String(_CRCode);
        }
        else if (this.tableCRCodeToCR[_CRCode] !== undefined) {
            return this.tableCRCodeToCR[_CRCode];
        }
        throw new Error("Invalid CR code: " + _CRCode);
    };
    BeastDetail.prototype.editChallengeRating = function (_newCRCode) {
        var self = this;
        this.nameHeader.find('.stats-value').each(function () {
            var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
            var prev = this.previousSibling;
            if (prev && /脅威度$/.test(__WEBPACK_IMPORTED_MODULE_0_jquery__(prev).text())) {
                var newCR = self.convertCRCodeToCR(_newCRCode);
                $this.text(newCR);
                $this.attr('data-stats', newCR);
                $this.addClass('modified');
                return false;
            }
            return;
        });
    };
    BeastDetail.prototype.lookChallengeRating = function () {
        var matched = this.nameHeader.text().match(/脅威度(\d+(?:\/\d+)?)/);
        if (matched) {
            return matched[1];
        }
        throw new Error("CR not found: " + this.nameHeader.text());
    };
    BeastDetail.prototype.lookCRCode = function () {
        return this.bringCRCode(this.lookChallengeRating());
    };
    BeastDetail.prototype.editExperiencePoint = function (_cr) {
        var exp = EXP_CR[_cr];
        this.experienceLine().find('.stats-value').changeValue(exp, ['encomma']);
    };
    BeastDetail.prototype.modifyChallengeRating = function (_modifier) {
        var newCRCode = this.lookCRCode() + _modifier;
        this.editChallengeRating(newCRCode);
        this.editExperiencePoint(newCRCode);
    };
    return BeastDetail;
}());
function numlikeToNum(numlike) {
    numlike = numlike
        .replace(/,/g, '')
        .replace(/＋/, '+')
        .replace(/－/, '-')
        .replace(/±/, '');
    return parseInt(numlike);
}
function _convertTextNodeToStasValueNodes() {
    var text = __WEBPACK_IMPORTED_MODULE_0_jquery__(this).text();
    if (/[＋－]?\d+(?:,\d+)*(?:\/\d+)?/.test(text)) {
        var fragments = text.split(/([＋－]?\d+(?:,\d+)*(?:\/\d+)?)/);
        var $texts = __WEBPACK_IMPORTED_MODULE_0_jquery__();
        fragments.forEach(function (frag) {
            if (/^[＋－]?\d+(?:,\d+)*$/.test(frag)) {
                $texts = $texts.add(__WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, {
                    text: frag,
                    attr: {
                        'data-orig': frag,
                        'data-stats': numlikeToNum(frag),
                        'class': 'stats-value'
                    }
                }));
            }
            else if (/^[＋－]?\d+(?:,\d+)*\/\d+$/.test(frag)) {
                $texts = $texts.add(__WEBPACK_IMPORTED_MODULE_0_jquery__(STATS_ELM, {
                    text: frag,
                    attr: {
                        'data-orig': frag,
                        'class': 'stats-value stats-fraction'
                    }
                }));
            }
            else {
                $texts = $texts.add(__WEBPACK_IMPORTED_MODULE_0_jquery__["textNode"](frag));
            }
        });
        $texts.insertBefore(this);
        __WEBPACK_IMPORTED_MODULE_0_jquery__(this).remove();
    }
}
// 手製ロードだとクラスが返らないので、インスタンスを返す。
function invoker() {
    return new QuickAdvancer;
}
var QuickAdvancer = /** @class */ (function () {
    function QuickAdvancer() {
        this.property = {
            name: 'QuickAdvancer',
        };
    }
    QuickAdvancer.prototype.run = function () {
        readyAdvancementAll();
    };
    return QuickAdvancer;
}());
/** 初期化 */
function readyAdvancementAll() {
    var $beastHeaders = __WEBPACK_IMPORTED_MODULE_0_jquery__("h3:contains('脅威度')");
    $beastHeaders.each(readyAdvancement);
    // 変更点のツールチップ
    __WEBPACK_IMPORTED_MODULE_0_jquery__(document).on('mouseenter', '.modified[data-orig]', function () {
        var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
        var diffMessage = $this.data('orig') + ' → ' + $this.text();
        $this.attr('title', diffMessage);
    });
    __WEBPACK_IMPORTED_MODULE_0_jquery__(document).on('click', '.advancementControl > button', function () {
        var $this = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
        var beast = $this.parent().data('beast'), templateName = $this.data('action-name');
        var isApplied = beast.applyAdvancement(templateName);
        if (isApplied) {
            $this.addClass('disabled');
        }
    });
}
function readyAdvancement() {
    var $beastName = __WEBPACK_IMPORTED_MODULE_0_jquery__(this), $buttonSpan;
    if ($beastName.data('initialized')) {
        return;
    }
    $buttonSpan = __WEBPACK_IMPORTED_MODULE_0_jquery__('<span>', {
        attr: { 'class': 'advancementControl' }
    });
    __WEBPACK_IMPORTED_MODULE_0_jquery__('<button>', {
        //text:'強大',
        attr: { 'data-action-name': 'advanced', title: 'アドヴァンスト' }
    }).appendTo($buttonSpan);
    __WEBPACK_IMPORTED_MODULE_0_jquery__('<button>', {
        //text:'強大',
        attr: { 'data-action-name': 'degenerate', title: 'ディジェネレイト' }
    }).appendTo($buttonSpan);
    __WEBPACK_IMPORTED_MODULE_0_jquery__('<button>', {
        //text:'巨大',
        attr: { 'data-action-name': 'giant', title: 'ジャイアント' }
    }).appendTo($buttonSpan);
    __WEBPACK_IMPORTED_MODULE_0_jquery__('<button>', {
        //text:'若年',
        attr: { 'data-action-name': 'young', title: 'ヤング' }
    }).appendTo($buttonSpan);
    __WEBPACK_IMPORTED_MODULE_0_jquery__('<button>', {
        //text:'天上',
        attr: { 'data-action-name': 'celestial', title: 'セレスチャル種' }
    }).appendTo($buttonSpan);
    __WEBPACK_IMPORTED_MODULE_0_jquery__('<button>', {
        //text:'悪鬼',
        attr: { 'data-action-name': 'fiendish', title: 'フィーンディッシュ種' }
    }).appendTo($buttonSpan);
    __WEBPACK_IMPORTED_MODULE_0_jquery__('<button>', {
        //text:'決然',
        attr: { 'data-action-name': 'resolute', title: 'レゾルート種' }
    }).appendTo($buttonSpan);
    __WEBPACK_IMPORTED_MODULE_0_jquery__('<button>', {
        //text:'崩壊',
        attr: { 'data-action-name': 'entropic', title: 'エントロピック種' }
    }).appendTo($buttonSpan);
    __WEBPACK_IMPORTED_MODULE_0_jquery__('<button>', {
        //text:'元へ',
        attr: { 'data-action-name': 'clear', 'title': 'リセット' }
    }).appendTo($buttonSpan);
    __WEBPACK_IMPORTED_MODULE_0_jquery__('<button>', {
        //text:'元へ',
        attr: { 'data-action-name': 'help',
            'title': '『単純なテンプレート』を再構築ルールっぽく適用。\n完全ではありません。変更後の値は目安です。' }
    }).appendTo($buttonSpan);
    $buttonSpan.appendTo($beastName);
    // 初期化
    $buttonSpan.one('click', 'button', function () {
        var beast = new BeastDetail($beastName);
        $buttonSpan.data('beast', beast);
    });
    $beastName.data('initialized', true);
}
// readyAdvancementAll();


/***/ })

},[378]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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