webpackJsonp([1],{

/***/ 105:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__search_pattern__ = __webpack_require__(58);

function quotemeta(s) {
    return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
}
var QueryPattern = /** @class */ (function () {
    function QueryPattern(queryText, _filterTag) {
        this.queryText = queryText;
        this.filterTag = {};
        if (_filterTag) {
            this.filterTag = _filterTag;
        }
        this.query = this.buildQuery(queryText);
    }
    Object.defineProperty(QueryPattern.prototype, "allMatchPattern", {
        get: function () {
            if (this._allMatchPattern)
                return this._allMatchPattern;
            var matchAllPattern = new RegExp(this.query.words.map(function (r) { return r.source; }).join('|'), 'gi');
            this._allMatchPattern = matchAllPattern;
            return matchAllPattern;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(QueryPattern.prototype, "firstPattern", {
        get: function () {
            return this.query.words[0];
        },
        enumerable: true,
        configurable: true
    });
    QueryPattern.prototype.test = function (_subject) {
        var res = false;
        var subject = _subject;
        if (!this.query.words.length)
            return false;
        if (this.query.squeeze.length) {
            res = this.query.squeeze
                .every(function (path) { return path.test(subject.path); });
            if (!res)
                return false;
        }
        if (this.query.target.length) {
            res = this.query.target
                .some(function (path) { return path.test(subject.path); });
            if (!res)
                return false;
        }
        res = this.query.words
            .every(function (word) { return word.test(subject.label) || word.test(subject.yomi || subject.body); });
        return res;
    };
    QueryPattern.prototype.toString = function () {
        var words = this.query.words.map(function (s) { return s.toString(); }).join(' ');
        var target = this.query.target.map(function (s) { return ':' + s.toString(); }).join(' ');
        var squeeze = this.query.squeeze.map(function (s) { return '@' + s.toString(); }).join(' ');
        return "word: " + words + "\ntarget: " + target + "\nsqueeze: " + squeeze + "\n";
    };
    QueryPattern.prototype.buildQuery = function (queryText) {
        var flagments = this.splitQuery(queryText);
        var query = this.divideQueries(flagments);
        return query;
    };
    QueryPattern.prototype.splitQuery = function (query) {
        var fragments = [];
        var pattern = /^(?:"[^"]+"|[@:]\w+(?:-\w+)*|\S+|\s+)/;
        while (query.length > 0) {
            query = query.replace(pattern, function (matched) {
                if (!/^\s+$/.test(matched)) {
                    if (/^"/.test(matched)) {
                        matched = matched.replace(/^"|"$/g, "");
                    }
                    fragments.push(matched);
                }
                return "";
            });
        }
        return fragments;
    };
    QueryPattern.prototype.divideQueries = function (fragments) {
        var _this = this;
        var words = [], targetPaths = [], squeezePaths = [];
        fragments.forEach(function (term) {
            var matched = term.match(/^([:@])(.*)/);
            if (matched) {
                var filterType = matched[1];
                var filterPath = matched[2];
                if (_this.filterTag[filterPath]) {
                    filterPath = _this.filterTag[filterPath];
                }
                else {
                    filterPath = quotemeta(filterPath);
                }
                var filterRx = new RegExp(filterPath);
                if (filterType === ':') {
                    targetPaths.push(filterRx);
                }
                else {
                    squeezePaths.push(filterRx);
                }
            }
            else {
                words.push(Object(__WEBPACK_IMPORTED_MODULE_0__search_pattern__["a" /* default */])(term));
            }
        });
        return {
            words: words,
            target: targetPaths,
            squeeze: squeezePaths
        };
    };
    return QueryPattern;
}());
/* harmony default export */ __webpack_exports__["a"] = (QueryPattern);


/***/ }),

/***/ 374:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__script_fulltext_search__ = __webpack_require__(375);

Object(__WEBPACK_IMPORTED_MODULE_0__script_fulltext_search__["a" /* default */])().run();


/***/ }),

/***/ 375:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = invoker;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_tslib__ = __webpack_require__(53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_tslib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_tslib__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__app_global__ = __webpack_require__(28);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__query_pattern__ = __webpack_require__(105);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_vue__ = __webpack_require__(37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_vue___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_vue__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_vue_class_component__ = __webpack_require__(57);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_vue_class_component___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_vue_class_component__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_jquery__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_jquery___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_jquery__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__attach_data__ = __webpack_require__(47);







;
;
;
var appGlobal = __WEBPACK_IMPORTED_MODULE_1__app_global__["default"].instance;
var template = "\n  <section id=\"fulltext-search\">\n    <div id=\"input\">\n      <label>\u691C\u7D22\uFF08\u534A\u89D2\u7A7A\u767D\u3067AND\u691C\u7D22\uFF09\uFF1A</label>\n      <input type=\"search\" id=\"fulltext-search-entry\"\n          v-on:input=\"searchFulltext\"\n          v-model=\"searchQuery\"\n          v-on:esc=\"\"\n          placeholder=\"\u691C\u7D22\u8A9E\"\n          v-on:keyup.esc=\"clearQuery\"\n          ref=\"searchEntry\"\n      />\n      <div id=\"view-size-selection\" v-on:change=\"searchFulltext\">\n        <label><input type=\"radio\" name=\"viewSize\" value=\"5\"   v-model.number=\"viewSize\" /> <span>5</span></label>\n        <label><input type=\"radio\" name=\"viewSize\" value=\"10\"  v-model.number=\"viewSize\" /> <span>10</span></label>\n        <label><input type=\"radio\" name=\"viewSize\" value=\"20\"  v-model.number=\"viewSize\" /> <span>20</span></label>\n        <label><input type=\"radio\" name=\"viewSize\" value=\"50\"  v-model.number=\"viewSize\" /> <span>50</span></label>\n        <label><input type=\"radio\" name=\"viewSize\" value=\"100\" v-model.number=\"viewSize\" /> <span>100</span></label>\n      </div>\n      <div>\n        <span id=\"search-status\">{{resultsCount}}\u4EF6\uFF0F{{indexSize}}\u4EF6\u4E2D \uFF08 {{requiredTimeStr}} \u79D2\uFF09</span>\n        <span id=\"search-status\"></span>\n      </div>\n    </div>\n\n    <div class=\"search-pagination\"></div>\n\n    <div id=\"search-view\">\n\n        <div class=\"result-item\" v-for=\"item in viewResults\">\n            <h3>\n              <a v-bind:href=\"'.'+item.path\" v-html=\"item.boldedTitle\"></a>\n              <small>\uFF3B{{item.score|floor}} pts. <small>({{item.titlePoint|floor}}+{{item.contentPoint|floor}})</small>\uFF3D</small>\n              <small>#{{item.order+1}}</small>\n            </h3>\n            <div class=\"page-fulltitle\">\n              <span v-if=\"item.titleHTML\" v-html=\"item.titleHTML\"></span>\n              <span v-else v-text=\"item.path\"></span>\n            </div>\n            <div class=\"result-snippet\" v-html=\"item.snippet\"></div>\n        </div>\n\n    </div>\n    <div id=\"pagenation\">\n      <button class=\"next-view\" v-on:click=\"viewNext\" v-bind:disabled=\"!canNext\">\u6B21\u3092\u8868\u793A \uFF08{{lastItemOrder}}/{{resultsCount}}\uFF09</button>\n      <button class=\"all-view\" v-on:click=\"viewAll\" v-bind:disabled=\"!canNext\">\u5168\u3066\u8868\u793A</button>\n    </div>\n\n    <hr />\n    <div class=\"search-pagination-bottom\"></div>\n\n  </section>\n";
var DummyData = /** @class */ (function () {
    function DummyData() {
        this.allResults = [];
    }
    return DummyData;
}());
var FulltextSearchView = /** @class */ (function (_super) {
    __WEBPACK_IMPORTED_MODULE_0_tslib__["__extends"](FulltextSearchView, _super);
    function FulltextSearchView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.searchQuery = "";
        _this.viewResults = [];
        _this.indexSize = 0;
        _this.requiredTime = 0;
        _this.resultsCount = 0;
        _this.currentLastIndex = 0;
        _this.lastItemOrder = 0;
        _this.data = new DummyData;
        _this.viewSize = appGlobal.fulltextSearchViewSize;
        _this.isIndexReadied = false;
        return _this;
    }
    FulltextSearchView.prototype.beforeCreate = function () {
        this.searchEngine = new FulltextSearchEngine;
        appGlobal.loadStylesheet('fulltext-search');
    };
    FulltextSearchView.prototype.created = function () {
        var _this = this;
        // インデックス読込後のイベント
        this.$once('indexReadied', function () {
            _this.isIndexReadied = true;
        });
        // インデックスを読込
        this.searchEngine.readyIndex(function () {
            _this.$emit('indexReadied');
        });
        // 戻る、進む、リロード時に検索クエリを保持するために
        // Vue の外側に配置した INPUT#fulltext-search-reminder に記録する。
        this.reminder = document.getElementById('fulltext-search-reminder');
        this.$watch('searchQuery', function (_val, _oldVal) {
            _this.reminder.value = _this.encodeReminder();
        });
        this.$watch('viewSize', function (_val, _oldVal) {
            _this.reminder.value = _this.encodeReminder();
        });
    };
    FulltextSearchView.prototype.mounted = function () {
        this.resetQueryReminder();
    };
    // 記憶したクエリを再セットする。
    FulltextSearchView.prototype.resetQueryReminder = function () {
        var _this = this;
        var reminderDataJSON = this.reminder.value;
        if (reminderDataJSON) {
            //console.log('reminderDataJSON:', reminderDataJSON);
            var reminderData = JSON.parse(reminderDataJSON);
            this.searchQuery = reminderData.searchQuery;
            this.viewSize = reminderData.viewSize;
            this.$once('indexReadied', function () {
                _this.$refs.searchEntry.dispatchEvent(new Event('input'));
            });
        }
    };
    FulltextSearchView.prototype.encodeReminder = function () {
        return JSON.stringify({
            searchQuery: this.searchQuery,
            viewSize: this.viewSize,
        });
    };
    FulltextSearchView.prototype.searchFulltext = function () {
        if (!this.searchEngine.isReadiedIndex)
            return;
        this.indexSize = this.searchEngine.indexSize;
        var response = this.searchEngine.searchFulltext(this.searchQuery);
        //this.data.allResults  = response.results;
        this.viewResults = response.results.slice(0, this.viewSize);
        this.resultsCount = response.results.length;
        this.currentLastIndex = this.viewSize - 1;
        this.lastItemOrder = this.currentLastIndex + 1;
        if (this.lastItemOrder > this.resultsCount) {
            this.lastItemOrder = this.resultsCount;
        }
        this.indexSize = response.indexSize;
        this.requiredTime = response.requiredTime;
        this.addDisplayingObject(this.viewResults);
    };
    FulltextSearchView.prototype.addDisplayingObject = function (results) {
        var allMatchPattern = this.searchEngine.searchPattern.allMatchPattern;
        for (var _i = 0, results_1 = results; _i < results_1.length; _i++) {
            var res = results_1[_i];
            //res.snippet = res.content;
            res.boldedTitle = this.createBoldedHTML(res.title, allMatchPattern);
            res.snippet = this.createSnippetHTML(res.content, allMatchPattern);
        }
        appGlobal.loadTitleDic()
            .then(function () {
            for (var _i = 0, results_2 = results; _i < results_2.length; _i++) {
                var result = results_2[_i];
                result.titleHTML = appGlobal.buildFactTitleHTML("" + result.path);
            }
        });
    };
    Object.defineProperty(FulltextSearchView.prototype, "canNext", {
        get: function () {
            return this.lastItemOrder < this.resultsCount;
        },
        enumerable: true,
        configurable: true
    });
    FulltextSearchView.prototype.viewNext = function () {
        if (this.resultsCount > this.currentLastIndex + 1) {
            var startIndex = this.currentLastIndex + 1;
            var endIndex = startIndex + this.viewSize - 1;
            this.currentLastIndex = endIndex;
            this.lastItemOrder = this.currentLastIndex + 1;
            if (this.lastItemOrder > this.resultsCount) {
                this.lastItemOrder = this.resultsCount;
            }
            var addingResults = this.searchEngine.results.slice(startIndex, endIndex + 1);
            this.addDisplayingObject(addingResults);
            this.viewResults.push.apply(this.viewResults, addingResults);
        }
    };
    FulltextSearchView.prototype.viewAll = function () {
        if (this.resultsCount > this.currentLastIndex + 1) {
            var startIndex = this.currentLastIndex + 1;
            var endIndex = this.resultsCount - 1;
            this.currentLastIndex = endIndex;
            this.lastItemOrder = this.currentLastIndex + 1;
            var addingResults = this.searchEngine.results.slice(startIndex);
            this.addDisplayingObject(addingResults);
            this.viewResults.push.apply(this.viewResults, addingResults);
        }
    };
    Object.defineProperty(FulltextSearchView.prototype, "requiredTimeStr", {
        get: function () {
            return (this.requiredTime / 1000).toString();
        },
        enumerable: true,
        configurable: true
    });
    FulltextSearchView.prototype.createBoldedHTML = function (text, boldPattern) {
        var pattern = new RegExp("(" + boldPattern.source + ")", 'gi');
        var bolded = text.replace(pattern, "<strong>$1</strong>");
        return __WEBPACK_IMPORTED_MODULE_5_jquery__('<span></span>').append(bolded).get(0).outerHTML;
    };
    FulltextSearchView.prototype.createSnippetHTML = function (contentBody, mathedPattern, snipetsLimit, snipPreLength, snipPostLength) {
        if (snipetsLimit === void 0) { snipetsLimit = 5; }
        if (snipPreLength === void 0) { snipPreLength = 10; }
        if (snipPostLength === void 0) { snipPostLength = 10; }
        var reg = new RegExp(mathedPattern.source, 'ig');
        if (!snipetsLimit)
            snipetsLimit = 5;
        if (!snipPreLength)
            snipPreLength = 10;
        if (!snipPostLength)
            snipPostLength = snipPreLength;
        var group = __WEBPACK_IMPORTED_MODULE_5_jquery__('<div></div>');
        var count = 0;
        while (++count) {
            if (count > snipetsLimit)
                break;
            var match_res = reg.exec(contentBody);
            var span = __WEBPACK_IMPORTED_MODULE_5_jquery__('<span></span>');
            if (!match_res && count == 1) {
                group.append(span).append(contentBody.slice(0, 200));
            }
            if (!match_res)
                break;
            var last_pos = reg.lastIndex;
            var match_word = match_res[0];
            var match_length = match_word.length;
            var start_pos = last_pos - match_length;
            var snip_start_pos = start_pos - snipPreLength;
            var snip_last_pos = last_pos + snipPostLength;
            var snip_pre = contentBody.slice(snip_start_pos, start_pos);
            var snip_post = contentBody.slice(last_pos, snip_last_pos);
            var bolded_word = __WEBPACK_IMPORTED_MODULE_5_jquery__('<b></b>');
            bolded_word.append(__WEBPACK_IMPORTED_MODULE_5_jquery__('<u/>').text(match_word).html());
            span.append(__WEBPACK_IMPORTED_MODULE_5_jquery__('<u/>').text(snip_pre).html())
                .append(bolded_word)
                .append(__WEBPACK_IMPORTED_MODULE_5_jquery__('<u/>').text(snip_post).html());
            group.append(span).append(' ... ');
        }
        return group.get(0).innerHTML;
    };
    FulltextSearchView.prototype.clearQuery = function () {
        this.searchQuery = "";
        //this.viewResults = [];
        this.$refs.searchEntry.focus();
    };
    FulltextSearchView = __WEBPACK_IMPORTED_MODULE_0_tslib__["__decorate"]([
        __WEBPACK_IMPORTED_MODULE_4_vue_class_component___default()({
            template: template,
            filters: {
                floor: function (value) {
                    return parseFloat(value).toString().replace(/(\.\d).*/, "$1");
                }
            },
        })
    ], FulltextSearchView);
    return FulltextSearchView;
}(__WEBPACK_IMPORTED_MODULE_3_vue___default.a));
var FulltextSearchEngine = /** @class */ (function () {
    function FulltextSearchEngine() {
        this.searchPatternStr = "";
        this.pathToRoot = ".";
        this.isReadiedIndex = false;
        this.nowReadyingIndex = false;
    }
    Object.defineProperty(FulltextSearchEngine.prototype, "indexSize", {
        get: function () {
            return this.index.length;
        },
        enumerable: true,
        configurable: true
    });
    FulltextSearchEngine.prototype.searchFulltext = function (query) {
        var _this = this;
        if (!this.isReadiedIndex) {
            throw new Error("Yet doesn't ready Index data");
        }
        var beginSearch = Date.now();
        this.searchPattern = new __WEBPACK_IMPORTED_MODULE_2__query_pattern__["a" /* default */](query, appGlobal.filterTag);
        this.searchPatternStr = this.searchPattern.toString();
        if (query.length) {
            var tmpResults = this.index.filter(function (item) {
                var isMatched = _this.searchPattern.test(item);
                return isMatched;
            })
                .map(function (item) {
                var first = _this.searchPattern.firstPattern.exec(item.body);
                var matchedIndex = -1;
                if (first !== null)
                    matchedIndex = first.index;
                var title = item.label;
                var content = item.body;
                var matchAllPattern = _this.searchPattern.allMatchPattern;
                var titleMatchCount = (title.match(matchAllPattern) || []).length;
                var contentMatchCount = (content.match(matchAllPattern) || []).length;
                var titlePts = 0;
                var contentPts = 0;
                if (title.length)
                    titlePts = titleMatchCount * 1000 / title.length;
                if (content.length)
                    contentPts = contentMatchCount * 1000 / content.length;
                var matchedPoint = titlePts + contentPts;
                var resItem = {
                    path: item.path,
                    title: item.label,
                    content: item.body,
                    titleHTML: "",
                    matchedIndex: matchedIndex,
                    titlePoint: titlePts,
                    contentPoint: contentPts,
                    score: matchedPoint,
                    order: 0
                };
                //console.log(resItem);
                return resItem;
            });
            this.results = tmpResults.sort(function (a, b) {
                return b.score - a.score;
            });
            var order = 0;
            for (var _i = 0, _a = this.results; _i < _a.length; _i++) {
                var item = _a[_i];
                item.order = order++;
            }
        }
        else {
            this.results = [];
        }
        var endSearch = Date.now();
        var responseTime = endSearch - beginSearch;
        var response = {
            requiredTime: responseTime,
            indexSize: this.indexSize,
            results: this.results,
        };
        return response;
    };
    FulltextSearchEngine.prototype.readyIndex = function (callback) {
        var _this = this;
        if (this.isReadiedIndex) {
            if (callback)
                callback();
            console.log('INDEX READIED');
            return;
        }
        if (this.nowReadyingIndex) {
            console.log('NOW READYING INDEX');
            return;
        }
        this.nowReadyingIndex = true;
        console.log('LOAD INDEX');
        var files = appGlobal.fulltextIndexFiles;
        Object(__WEBPACK_IMPORTED_MODULE_6__attach_data__["default"])(files)
            .then(function (args) {
            _this.index = Array.prototype.concat.apply([], args);
            console.log('LOADED: INDEX SIZE is', _this.index.length);
            _this.isReadiedIndex = true;
            if (callback)
                callback();
        });
        console.log('LOADING SPLASH INDEX...');
        // タイトルを読み込み
        appGlobal.loadTitleDic();
    };
    return FulltextSearchEngine;
}());
function invoker() {
    return new FulltextSearch;
}
var FulltextSearch = /** @class */ (function () {
    function FulltextSearch() {
        this.property = {
            name: 'FulltextSearch',
        };
    }
    FulltextSearch.prototype.run = function () {
        new FulltextSearchView({ el: '#fulltext-search' });
    };
    return FulltextSearch;
}());


/***/ }),

/***/ 53:
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Promise, global) {var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
/* global global, define, System, Reflect, Promise */
var __extends;
var __assign;
var __rest;
var __decorate;
var __param;
var __metadata;
var __awaiter;
var __generator;
var __exportStar;
var __values;
var __read;
var __spread;
var __asyncGenerator;
var __asyncDelegator;
var __asyncValues;
(function (factory) {
    var root = typeof global === "object" ? global : typeof self === "object" ? self : typeof this === "object" ? this : {};
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports], __WEBPACK_AMD_DEFINE_RESULT__ = (function (exports) { factory(createExporter(root, createExporter(exports))); }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    }
    else if (typeof module === "object" && typeof module.exports === "object") {
        factory(createExporter(root, createExporter(module.exports)));
    }
    else {
        factory(createExporter(root));
    }
    function createExporter(exports, previous) {
        return function (id, v) { return exports[id] = previous ? previous(id, v) : v; };
    }
})
(function (exporter) {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };

    __extends = function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };

    __assign = Object.assign || function (t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };

    __rest = function (s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
                t[p[i]] = s[p[i]];
        return t;
    };

    __decorate = function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };

    __param = function (paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); }
    };

    __metadata = function (metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
    };

    __awaiter = function (thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    };

    __generator = function (thisArg, body) {
        var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_) try {
                if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
                if (y = 0, t) op = [0, t.value];
                switch (op[0]) {
                    case 0: case 1: t = op; break;
                    case 4: _.label++; return { value: op[1], done: false };
                    case 5: _.label++; y = op[1]; op = [0]; continue;
                    case 7: op = _.ops.pop(); _.trys.pop(); continue;
                    default:
                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                        if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                        if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                        if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                        if (t[2]) _.ops.pop();
                        _.trys.pop(); continue;
                }
                op = body.call(thisArg, _);
            } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
            if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
        }
    };

    __exportStar = function (m, exports) {
        for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
    };

    __values = function (o) {
        var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
        if (m) return m.call(o);
        return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
    };

    __read = function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m) return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
        }
        catch (error) { e = { error: error }; }
        finally {
            try {
                if (r && !r.done && (m = i["return"])) m.call(i);
            }
            finally { if (e) throw e.error; }
        }
        return ar;
    };

    __spread = function () {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    };

    __asyncGenerator = function (thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), q = [], c, i;
        return i = { next: verb("next"), "throw": verb("throw"), "return": verb("return") }, i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) { return function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]), next(); }); }; }
        function next() { if (!c && q.length) resume((c = q.shift())[0], c[1]); }
        function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(c[3], e); } }
        function step(r) { r.done ? settle(c[2], r) : r.value[0] === "yield" ? settle(c[2], { value: r.value[1], done: false }) : Promise.resolve(r.value[1]).then(r.value[0] === "delegate" ? delegate : fulfill, reject); }
        function delegate(r) { step(r.done ? r : { value: ["yield", r.value], done: false }); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) { c = void 0, f(v), next(); }
    };

    __asyncDelegator = function (o) {
        var i = { next: verb("next"), "throw": verb("throw", function (e) { throw e; }), "return": verb("return", function (v) { return { value: v, done: true }; }) };
        return o = __asyncValues(o), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { return function (v) { return { value: ["delegate", (o[n] || f).call(o, v)], done: false }; }; }
    };

    __asyncValues = function (o) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator];
        return m ? m.call(o) : typeof __values === "function" ? __values(o) : o[Symbol.iterator]();
    };

    exporter("__extends", __extends);
    exporter("__assign", __assign);
    exporter("__rest", __rest);
    exporter("__decorate", __decorate);
    exporter("__param", __param);
    exporter("__metadata", __metadata);
    exporter("__awaiter", __awaiter);
    exporter("__generator", __generator);
    exporter("__exportStar", __exportStar);
    exporter("__values", __values);
    exporter("__read", __read);
    exporter("__spread", __spread);
    exporter("__asyncGenerator", __asyncGenerator);
    exporter("__asyncDelegator", __asyncDelegator);
    exporter("__asyncValues", __asyncValues);
});
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(48), __webpack_require__(60)))

/***/ }),

/***/ 57:
/***/ (function(module, exports, __webpack_require__) {

/**
  * vue-class-component v5.0.1
  * (c) 2015-2017 Evan You
  * @license MIT
  */
(function (global, factory) {
	 true ? factory(exports, __webpack_require__(37)) :
	typeof define === 'function' && define.amd ? define(['exports', 'vue'], factory) :
	(factory((global.VueClassComponent = global.VueClassComponent || {}),global.Vue));
}(this, (function (exports,Vue) { 'use strict';

Vue = 'default' in Vue ? Vue['default'] : Vue;

function createDecorator(factory) {
    return function (_, key, index) {
        if (typeof index !== 'number') {
            index = undefined;
        }
        $decoratorQueue.push(function (options) { return factory(options, key, index); });
    };
}
function warn(message) {
    if (typeof console !== 'undefined') {
        console.warn('[vue-class-component] ' + message);
    }
}

function collectDataFromConstructor(vm, Component) {
    Component.prototype._init = function () {
        var _this = this;
        var keys = Object.getOwnPropertyNames(vm);
        if (vm.$options.props) {
            for (var key in vm.$options.props) {
                if (!vm.hasOwnProperty(key)) {
                    keys.push(key);
                }
            }
        }
        keys.forEach(function (key) {
            if (key.charAt(0) !== '_') {
                Object.defineProperty(_this, key, {
                    get: function () { return vm[key]; },
                    set: function (value) { return vm[key] = value; }
                });
            }
        });
    };
    var data = new Component();
    var plainData = {};
    Object.keys(data).forEach(function (key) {
        if (data[key] !== undefined) {
            plainData[key] = data[key];
        }
    });
    {
        if (!(Component.prototype instanceof Vue) && Object.keys(plainData).length > 0) {
            warn('Component class must inherit Vue or its descendant class ' +
                'when class property is used.');
        }
    }
    return plainData;
}

var $internalHooks = [
    'data',
    'beforeCreate',
    'created',
    'beforeMount',
    'mounted',
    'beforeDestroy',
    'destroyed',
    'beforeUpdate',
    'updated',
    'activated',
    'deactivated',
    'render'
];
var $decoratorQueue = [];
function componentFactory(Component, options) {
    if (options === void 0) { options = {}; }
    options.name = options.name || Component._componentTag || Component.name;
    var proto = Component.prototype;
    Object.getOwnPropertyNames(proto).forEach(function (key) {
        if (key === 'constructor') {
            return;
        }
        if ($internalHooks.indexOf(key) > -1) {
            options[key] = proto[key];
            return;
        }
        var descriptor = Object.getOwnPropertyDescriptor(proto, key);
        if (typeof descriptor.value === 'function') {
            (options.methods || (options.methods = {}))[key] = descriptor.value;
        }
        else if (descriptor.get || descriptor.set) {
            (options.computed || (options.computed = {}))[key] = {
                get: descriptor.get,
                set: descriptor.set
            };
        }
    });
    (options.mixins || (options.mixins = [])).push({
        data: function () {
            return collectDataFromConstructor(this, Component);
        }
    });
    $decoratorQueue.forEach(function (fn) { return fn(options); });
    $decoratorQueue = [];
    var superProto = Object.getPrototypeOf(Component.prototype);
    var Super = superProto instanceof Vue
        ? superProto.constructor
        : Vue;
    return Super.extend(options);
}

function Component(options) {
    if (typeof options === 'function') {
        return componentFactory(options);
    }
    return function (Component) {
        return componentFactory(Component, options);
    };
}
(function (Component) {
    function registerHooks(keys) {
        $internalHooks.push.apply($internalHooks, keys);
    }
    Component.registerHooks = registerHooks;
})(Component || (Component = {}));
var Component$1 = Component;

exports['default'] = Component$1;
exports.createDecorator = createDecorator;

Object.defineProperty(exports, '__esModule', { value: true });

})));


/***/ }),

/***/ 58:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = makeSearchPattern;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_fhconvert__ = __webpack_require__(59);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_fhconvert___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_fhconvert__);

var malleableKanaPatternTable = {
    "ア": "[ァア]",
    "イ": "[ィイ]",
    "ウ": "[ゥウ]",
    "エ": "[ェエ]",
    "オ": "[ォオ]",
    "ヤ": "[ャヤ]",
    "ユ": "[ュユ]",
    "ヨ": "[ョヨ]",
    "ァ": "[ァア]",
    "ィ": "[ィイ]",
    "ゥ": "[ゥウ]",
    "ェ": "[ェエ]",
    "ォ": "[ォオ]",
    "ャ": "[ャヤ]",
    "ュ": "[ュユ]",
    "ョ": "[ョヨ]",
    "ツ": "[ッツ]",
    "ッ": "[ッツ]",
    "ジ": "[ジヂ]",
    "ズ": "[ズヅ]",
    "ヂ": "[ジヂ]",
    "ヅ": "[ズヅ]",
    "バ": "(?:ヴァ|バ)",
    "ビ": "(?:ヴィ|ビ)",
    "ブ": "[ヴブ]",
    "ベ": "(?:ヴェ|ベ)",
    "ボ": "(?:ヴォ|ボ)",
    "ヴァ": "(?:ヴァ|バ)",
    "ヴィ": "(?:ヴィ|ビ)",
    "ヴェ": "(?:ヴェ|ベ)",
    "ヴォ": "(?:ヴォ|ボ)",
    "ヴ": "[ヴブ]",
    "ヒュ": "[ヒフ][ユュ]",
    "フュ": "[ヒフ][ユュ]",
};
var vowelDerivingTable = {
    "ア": new RegExp("[ァアカガサザタダナハバパマラャヤワ]"),
    "イ": new RegExp("[ィイキギシジチヂニヒビピミリ]"),
    "ウ": new RegExp("[ゥウクグスズツヅヌフブプムルュユヴ]"),
    "エ": new RegExp("[ェエケゲセゼテデネヘベペメレ]"),
    "オ": new RegExp("[ォオコゴソゾトドノホボポモロョヨヲ]")
};
var prolongPatternTable = {
    "ア": "[ァアー]",
    "イ": "[ィイー]",
    "ウ": "[ゥウー]",
    "エ": "[ェエー]",
    "オ": "[ォオー]",
    "オー": "[ウゥオォー]",
    "エー": "[イィエェー]",
};
// テキストからパターンを作る
function makeSearchPattern(_queryText) {
    // ひらがなをカタカナに変換
    var queryText = __WEBPACK_IMPORTED_MODULE_0_fhconvert__["hgtokk"](_queryText);
    // パターン作成
    var seq = queryText.match(/ヴ[ァィェォ]|[ヒフ]ュ|./g);
    if (!seq) {
        seq = [];
    }
    ;
    var searchRegexpSeeds = [];
    var vowels = []; // 母音
    seq.forEach(function (_charUnit, idx) {
        var charUnit = "" + _charUnit;
        var matched = charUnit.match(/(.)$/);
        if (!matched)
            matched = [""];
        var lastChar = matched[0];
        var vowel = "";
        vowels[idx] = "";
        // 母音抽出
        Object.keys(vowelDerivingTable)
            .forEach(function (vowelKey) {
            var pattern = vowelDerivingTable[vowelKey];
            if (lastChar.match(pattern)) {
                vowel = vowelKey;
                vowels[idx] = vowel;
                return false;
            }
            return true;
        });
        // 長音のパターンを作成
        var prolongPattern = "";
        var prevVowel = vowels[idx - 1];
        if (charUnit.match(/^[アイウエオァィゥェォー]$/) && prevVowel) {
            // 今が長音の場合
            if (charUnit == "ー") {
                prolongPattern = prolongPatternTable[prevVowel + "ー"] || prolongPatternTable[prevVowel];
            }
            else if (prevVowel === vowel) {
                prolongPattern = prolongPatternTable[vowel];
            }
            else if (prevVowel === "オ" && vowel === "ウ") {
                prolongPattern = "[オォウゥー]";
            }
            else if (prevVowel === "エ" && vowel === "イ") {
                prolongPattern = "[エェイィー]";
            }
        }
        if (prolongPattern) {
            searchRegexpSeeds.push(prolongPattern);
        }
        else {
            // 特定のカナのパターン
            var kanaPattern = malleableKanaPatternTable[charUnit];
            if (kanaPattern) {
                searchRegexpSeeds.push(kanaPattern);
            }
            else {
                var bs = String.fromCharCode(92); // バックスラッシュ
                var unsafe = bs + ".+*?[^]$(){}=!<>¦|:";
                var safesearch = charUnit;
                var i = void 0;
                for (i = 0; i < unsafe.length; ++i) {
                    safesearch = safesearch.replace(new RegExp("\\" + unsafe.charAt(i), "g"), bs + unsafe.charAt(i));
                }
                searchRegexpSeeds.push(safesearch);
            }
        }
    });
    // ひらがなとカタカナのパターンを混合
    // ( (?: kata ) | (?: hira ) )
    searchRegexpSeeds.forEach(function (v, idx) {
        var pattern = "";
        var hiragana = __WEBPACK_IMPORTED_MODULE_0_fhconvert__["kktohg"](v);
        if (v !== hiragana) {
            if (v.length === 1) {
                pattern = "[" + v + hiragana + "]";
            }
            else {
                var pat_katakana = v;
                var pat_hirakana = hiragana;
                pattern = "(?:" + pat_katakana + "|" + pat_hirakana + ")";
            }
        }
        else {
            pattern = v;
        }
        searchRegexpSeeds[idx] = pattern;
    });
    // 各単位ごとに .? を挟んでパターンを作る
    var pattern = new RegExp(searchRegexpSeeds.join(".?"), "i");
    return pattern;
}


/***/ })

},[374]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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