webpackJsonp([5],{

/***/ 376:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__special_carrying_capacity__ = __webpack_require__(377);

Object(__WEBPACK_IMPORTED_MODULE_0__special_carrying_capacity__["a" /* default */])().run();


/***/ }),

/***/ 377:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = invoker;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_jquery__);

/** 数値をコンマ区切りに */
function encomma(num) {
    var numlook = num.toString();
    var numParts = numlook.split('.');
    numParts[0] = numParts[0]
        .split("").reverse().join("")
        .replace(/(\d{3}(?=\d))/g, '$1,')
        .split("").reverse().join("");
    var commalize = numParts[0];
    if (numParts[1])
        commalize += '.' + numParts[1];
    return commalize;
}
var controlHTML = "<style>\n  #carrying-capacity label {\n    background: #eee9d0;\n    color: #887;\n    margin-right: 0.3em;\n    padding: 0.1em 0.4em 0.1em 0.4em;\n    background: #eee9d0;\n    color: #887;\n    cursor: pointer;\n    border-radius: 3px;\n    user-select: none;\n    -moz-user-select: none;\n    -webkit-user-select: none;\n  }\n  #carrying-capacity label.checked {\n    background: #ddd9c0;\n    color: #332;\n  }\n  #carrying-capacity label>input[type=\"radio\"] {\n    display: none;\n  }\n</style>\n<div id=\"carrying-capacity\"><div id=\"carrying-capacity-size\">\n  <label><input type=\"radio\" name=\"carrying-capacity-size\" value=\"fine\"      >\u6975\u5C0F</label>\n  <label><input type=\"radio\" name=\"carrying-capacity-size\" value=\"diminutive\">\u5FAE\u5C0F</label>\n  <label><input type=\"radio\" name=\"carrying-capacity-size\" value=\"tiny\"      >\u8D85\u5C0F\u578B</label>\n  <label><input type=\"radio\" name=\"carrying-capacity-size\" value=\"small\"     >\u5C0F\u578B</label>\n  <label class=\"checked\"><input type=\"radio\" name=\"carrying-capacity-size\" value=\"medium\" checked=\"checked\">\u4E2D\u578B</label>\n  <label><input type=\"radio\" name=\"carrying-capacity-size\" value=\"large\"     >\u5927\u578B</label>\n  <label><input type=\"radio\" name=\"carrying-capacity-size\" value=\"huge\"      >\u8D85\u5927\u578B</label>\n  <label><input type=\"radio\" name=\"carrying-capacity-size\" value=\"gargantuan\">\u5DE8\u5927</label>\n  <label><input type=\"radio\" name=\"carrying-capacity-size\" value=\"colossal\"  >\u8D85\u5DE8\u5927</label>\n  </div><div id=\"carrying-capacity-legs\">\n  <label class=\"checked\"><input type=\"radio\" name=\"carrying-capacity-legs\" value=\"bipedal\" checked=\"checked\">\u4E8C\u8DB3\u6B69\u884C</label>\n  <label><input type=\"radio\" name=\"carrying-capacity-legs\" value=\"quadruped\">\u56DB\u8DB3\u6B69\u884C</label>\n</div></div>";
var footRowHTML = "<tbody><tr class=\"odd\"><td><p><span>\n<input id=\"carrying-capacity-calculator-strength\" type=\"text\" style=\"width:4em;\" placeholder=\"\u7B4B\u529B\" />\n</span></p></td>\n<td><p><span></span></p></td>\n<td><p><span></span></p></td>\n<td><p><span></span></p></td></tr>\n</tbody>";
var loadRateDic = {
    1: [3, 6, 10], 2: [6, 13, 20], 3: [10, 20, 30],
    4: [13, 26, 40], 5: [16, 33, 50], 6: [20, 40, 60],
    7: [23, 46, 70], 8: [26, 53, 80], 9: [30, 60, 90],
    10: [33, 66, 100], 11: [38, 76, 115], 12: [43, 86, 130],
    13: [50, 100, 150], 14: [58, 116, 175], 15: [66, 133, 200],
    16: [76, 153, 230], 17: [86, 173, 260], 18: [100, 200, 300],
    19: [116, 233, 350], 20: [133, 266, 400], 21: [153, 306, 460],
    22: [173, 346, 520], 23: [200, 400, 600], 24: [233, 466, 700],
    25: [266, 533, 800], 26: [306, 613, 920], 27: [346, 693, 1040],
    28: [400, 800, 1200], 29: [466, 933, 1400],
    getLoadArray: function (strength) {
        var strengthNum = parseInt(strength);
        if (strengthNum <= 19)
            return this[strengthNum];
        var baseStrength = 20 + (strengthNum % 10);
        var overStrengthRate = Math.pow(4, (strengthNum - (strengthNum % 10) - 20) / 10);
        return this[baseStrength].map(function (v) { return v * overStrengthRate; });
    }
};
var sizeRateDic = {
    fine: { name: "極小", bipedal: 0.125, quadruped: 0.25 },
    diminutive: { name: "微小", bipedal: 0.25, quadruped: 0.5 },
    tiny: { name: "超小型", bipedal: 0.5, quadruped: 0.75 },
    small: { name: "小型", bipedal: 0.75, quadruped: 1 },
    medium: { name: "中型", bipedal: 1, quadruped: 1.5 },
    large: { name: "大型", bipedal: 2, quadruped: 3 },
    huge: { name: "超大型", bipedal: 4, quadruped: 6 },
    gargantuan: { name: "巨大", bipedal: 8, quadruped: 12 },
    colossal: { name: "超巨大", bipedal: 16, quadruped: 24 }
};
/* ------------------------------------------------------------------------ */
// 手製ロードだとクラスが返らないので、インスタンスを返す。
function invoker() {
    return new CarryingCapacityTable;
}
var CarryingCapacityTable = /** @class */ (function () {
    function CarryingCapacityTable() {
        this.property = {
            name: "CarryingCapacityTable",
        };
    }
    CarryingCapacityTable.prototype.run = function () {
        this.initCarryingCapacityTable();
    };
    CarryingCapacityTable.prototype.initCarryingCapacityTable = function () {
        var $table = __WEBPACK_IMPORTED_MODULE_0_jquery__('[id="表：運搬能力"] > table');
        $table.after(controlHTML);
        $table.append(footRowHTML);
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#carrying-capacity > click')
            .on('click', function () {
            __WEBPACK_IMPORTED_MODULE_0_jquery__(this).find(':radio').prop(true);
        });
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#carrying-capacity :input')
            .on('change', function () {
            __WEBPACK_IMPORTED_MODULE_0_jquery__(this)
                .closest('div')
                .find('label')
                .each(function () {
                __WEBPACK_IMPORTED_MODULE_0_jquery__(this).removeClass('checked');
            });
            __WEBPACK_IMPORTED_MODULE_0_jquery__(this).closest('label').addClass('checked');
        });
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#carrying-capacity :input, #carrying-capacity-calculator-strength')
            .on('change input', function () {
            var size = __WEBPACK_IMPORTED_MODULE_0_jquery__('#carrying-capacity-size :radio:checked').val();
            var legs = __WEBPACK_IMPORTED_MODULE_0_jquery__('#carrying-capacity-legs :radio:checked').val();
            $table.find('tbody tr').each(function () {
                var $row = __WEBPACK_IMPORTED_MODULE_0_jquery__(this);
                var $firstCell = $row.find('td:eq(0)');
                var keyStr = $firstCell.text();
                $firstCell.find('#carrying-capacity-calculator-strength').each(function () {
                    keyStr = __WEBPACK_IMPORTED_MODULE_0_jquery__(this).val();
                });
                if (!/^\d+$/.test(keyStr))
                    return;
                var loadRate = loadRateDic.getLoadArray(keyStr);
                var sizeRate = sizeRateDic[size];
                if (!loadRate || !sizeRate)
                    return;
                var sizeModifier = sizeRate[legs];
                var lighter = 0;
                $row.find('td:gt(0)').each(function (idx) {
                    var load = Math.floor(loadRate[idx] * sizeModifier);
                    var cellText = "";
                    if (lighter)
                        cellText += encomma(lighter + 1) + ' ';
                    cellText += "～ " + encomma(load);
                    __WEBPACK_IMPORTED_MODULE_0_jquery__(this).find('span').text(cellText);
                    lighter = load;
                });
            });
        });
    };
    return CarryingCapacityTable;
}());


/***/ })

},[376]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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