webpackJsonp([0],{

/***/ 105:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__search_pattern__ = __webpack_require__(58);

function quotemeta(s) {
    return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
}
var QueryPattern = /** @class */ (function () {
    function QueryPattern(queryText, _filterTag) {
        this.queryText = queryText;
        this.filterTag = {};
        if (_filterTag) {
            this.filterTag = _filterTag;
        }
        this.query = this.buildQuery(queryText);
    }
    Object.defineProperty(QueryPattern.prototype, "allMatchPattern", {
        get: function () {
            if (this._allMatchPattern)
                return this._allMatchPattern;
            var matchAllPattern = new RegExp(this.query.words.map(function (r) { return r.source; }).join('|'), 'gi');
            this._allMatchPattern = matchAllPattern;
            return matchAllPattern;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(QueryPattern.prototype, "firstPattern", {
        get: function () {
            return this.query.words[0];
        },
        enumerable: true,
        configurable: true
    });
    QueryPattern.prototype.test = function (_subject) {
        var res = false;
        var subject = _subject;
        if (!this.query.words.length)
            return false;
        if (this.query.squeeze.length) {
            res = this.query.squeeze
                .every(function (path) { return path.test(subject.path); });
            if (!res)
                return false;
        }
        if (this.query.target.length) {
            res = this.query.target
                .some(function (path) { return path.test(subject.path); });
            if (!res)
                return false;
        }
        res = this.query.words
            .every(function (word) { return word.test(subject.label) || word.test(subject.yomi || subject.body); });
        return res;
    };
    QueryPattern.prototype.toString = function () {
        var words = this.query.words.map(function (s) { return s.toString(); }).join(' ');
        var target = this.query.target.map(function (s) { return ':' + s.toString(); }).join(' ');
        var squeeze = this.query.squeeze.map(function (s) { return '@' + s.toString(); }).join(' ');
        return "word: " + words + "\ntarget: " + target + "\nsqueeze: " + squeeze + "\n";
    };
    QueryPattern.prototype.buildQuery = function (queryText) {
        var flagments = this.splitQuery(queryText);
        var query = this.divideQueries(flagments);
        return query;
    };
    QueryPattern.prototype.splitQuery = function (query) {
        var fragments = [];
        var pattern = /^(?:"[^"]+"|[@:]\w+(?:-\w+)*|\S+|\s+)/;
        while (query.length > 0) {
            query = query.replace(pattern, function (matched) {
                if (!/^\s+$/.test(matched)) {
                    if (/^"/.test(matched)) {
                        matched = matched.replace(/^"|"$/g, "");
                    }
                    fragments.push(matched);
                }
                return "";
            });
        }
        return fragments;
    };
    QueryPattern.prototype.divideQueries = function (fragments) {
        var _this = this;
        var words = [], targetPaths = [], squeezePaths = [];
        fragments.forEach(function (term) {
            var matched = term.match(/^([:@])(.*)/);
            if (matched) {
                var filterType = matched[1];
                var filterPath = matched[2];
                if (_this.filterTag[filterPath]) {
                    filterPath = _this.filterTag[filterPath];
                }
                else {
                    filterPath = quotemeta(filterPath);
                }
                var filterRx = new RegExp(filterPath);
                if (filterType === ':') {
                    targetPaths.push(filterRx);
                }
                else {
                    squeezePaths.push(filterRx);
                }
            }
            else {
                words.push(Object(__WEBPACK_IMPORTED_MODULE_0__search_pattern__["a" /* default */])(term));
            }
        });
        return {
            words: words,
            target: targetPaths,
            squeeze: squeezePaths
        };
    };
    return QueryPattern;
}());
/* harmony default export */ __webpack_exports__["a"] = (QueryPattern);


/***/ }),

/***/ 362:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__script_splash_search__ = __webpack_require__(363);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__script_mobile_menu__ = __webpack_require__(364);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__script_outline_panel__ = __webpack_require__(365);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__script_xref_navpanel__ = __webpack_require__(366);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__script_footnote_tooltip__ = __webpack_require__(367);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__script_image_injector__ = __webpack_require__(368);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__script_affair_loader__ = __webpack_require__(369);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__script_flattenable_content__ = __webpack_require__(370);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__script_anchor_copyer__ = __webpack_require__(371);
//import AppGlobal from './script/app-global';
//let appGlobal: AppGlobal = AppGlobal.instance;

new __WEBPACK_IMPORTED_MODULE_0__script_splash_search__["a" /* default */]({ el: '#splash-search-box', });
// MobileMenu は、
//   * SplashSearchBox の後
//   * OutlinePanel の前

Object(__WEBPACK_IMPORTED_MODULE_1__script_mobile_menu__["a" /* default */])();

if (document.getElementById('document-outline')) {
    new __WEBPACK_IMPORTED_MODULE_2__script_outline_panel__["a" /* default */]({ el: '#document-outline', });
}

new __WEBPACK_IMPORTED_MODULE_3__script_xref_navpanel__["a" /* default */];

new __WEBPACK_IMPORTED_MODULE_4__script_footnote_tooltip__["a" /* default */];

new __WEBPACK_IMPORTED_MODULE_5__script_image_injector__["a" /* default */];

(new __WEBPACK_IMPORTED_MODULE_6__script_affair_loader__["a" /* default */]).run();

(new __WEBPACK_IMPORTED_MODULE_7__script_flattenable_content__["a" /* default */]).run();

new __WEBPACK_IMPORTED_MODULE_8__script_anchor_copyer__["a" /* default */];


/***/ }),

/***/ 363:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_tslib__ = __webpack_require__(53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_tslib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_tslib__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_vue__ = __webpack_require__(37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_vue___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_vue__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_vue_class_component__ = __webpack_require__(57);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_vue_class_component___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_vue_class_component__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__query_pattern__ = __webpack_require__(105);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__app_global__ = __webpack_require__(28);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__attach_data__ = __webpack_require__(47);






var appGlobal = __WEBPACK_IMPORTED_MODULE_4__app_global__["default"].instance;
;
var SplashSearchBox = /** @class */ (function (_super) {
    __WEBPACK_IMPORTED_MODULE_0_tslib__["__extends"](SplashSearchBox, _super);
    function SplashSearchBox() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.splashes = [];
        _this.results = [];
        _this.hasInitialized = false;
        _this.isReadiedIndex = false;
        _this.nowReadyingIndex = false;
        _this.searchQuery = "";
        _this.searchPatternStr = "";
        _this.pathToRoot = ".";
        _this.DEBUG = false;
        return _this;
    }
    SplashSearchBox.prototype.created = function () {
        this.pathToRoot = appGlobal.pathToRoot;
        //appGlobal.loadStylesheet('splash-search');
        this.DEBUG = appGlobal.isDEBUG;
    };
    SplashSearchBox.prototype.clearQuery = function () {
        this.searchQuery = "";
        this.results = [];
        this.$refs.searchEntry.focus();
    };
    SplashSearchBox.prototype.readyIndex = function () {
        var _this = this;
        if (this.isReadiedIndex) {
            console.log('INDEX READIED');
            return;
        }
        if (this.nowReadyingIndex) {
            console.log('NOW READYING INDEX');
            return;
        }
        this.nowReadyingIndex = true;
        console.log('LOAD INDEX');
        var files = appGlobal.splashFiles;
        Object(__WEBPACK_IMPORTED_MODULE_5__attach_data__["default"])(files)
            .then(function (args) {
            _this.splashes = Array.prototype.concat.apply([], args);
            console.log('LOADED: INDEX SIZE is', _this.splashes.length);
            _this.isReadiedIndex = true;
            _this.searchSplash();
        });
        console.log('LOADING SPLASH INDEX...');
        // タイトルを読み込み
        //appGlobal.loadTitleDic();
    };
    SplashSearchBox.prototype.searchSplash = function () {
        var _this = this;
        if (!this.isReadiedIndex) {
            this.readyIndex();
            return;
        }
        this.searchPattern = new __WEBPACK_IMPORTED_MODULE_3__query_pattern__["a" /* default */](this.searchQuery, appGlobal.filterTag);
        this.searchPatternStr = this.searchPattern.toString();
        if (this.searchQuery.length) {
            // 検索
            var tmpResults_1 = this.splashes
                .filter(function (item) {
                return _this.searchPattern.test(item);
            })
                .map(function (item) {
                var first = _this.searchPattern.firstPattern.exec(item.label);
                if (first === null)
                    first = _this.searchPattern.firstPattern.exec(item.yomi);
                var matchedIndex = -1;
                if (first !== null)
                    matchedIndex = first.index;
                var resItem = {
                    path: item.path,
                    splash: item.label,
                    pron: item.yomi,
                    titleHTML: "",
                    matchedIndex: matchedIndex,
                };
                //console.log(resItem);
                return resItem;
            });
            // 並べ替え
            tmpResults_1.sort(function (a, b) {
                return (a.matchedIndex - b.matchedIndex)
                    || (a.splash.length - b.splash.length);
            });
            // カット
            tmpResults_1 = tmpResults_1.slice(0, 100);
            // タイトル取得
            appGlobal.loadTitleDic()
                .then(function () {
                for (var _i = 0, tmpResults_2 = tmpResults_1; _i < tmpResults_2.length; _i++) {
                    var resultItem = tmpResults_2[_i];
                    resultItem.titleHTML
                        = appGlobal.buildFactTitleHTML(resultItem.path);
                }
            });
            this.results = tmpResults_1;
        }
        else {
            this.results = [];
        }
    };
    SplashSearchBox = __WEBPACK_IMPORTED_MODULE_0_tslib__["__decorate"]([
        __WEBPACK_IMPORTED_MODULE_2_vue_class_component___default()({
            template: /*html*/ "\n      <div id=\"splash-search-box\">\n        <div id=\"splash-search-entry-area\">\n          <input type=\"search\"\n              id=\"splash-search-entry\"\n              v-on:input=\"searchSplash\"\n              v-on:focus=\"readyIndex\"\n              v-model=\"searchQuery\"\n              placeholder=\"\u898B\u51FA\u3057\u691C\u7D22\"\n              v-on:keyup.esc=\"clearQuery\"\n              ref=\"searchEntry\"\n          />\n        </div>\n        <section id=\"splash-search-result\" v-if=\"results.length\">\n          <div class=\"inner\">\n            <pre v-if=\"DEBUG\"><code>{{searchPatternStr}}</code></pre>\n            <ol v-if=\"results.length\">\n              <li v-for=\"item in results\">\n                <a :href=\"pathToRoot+item.path\"\n                    v-on:keyup.esc=\"clearQuery\"\n                >\n                  <span class=\"splash-name\">{{item.splash}}</span>\n\n                  <span v-if=\"item.titleHTML\" class=\"page-title\" v-html=\"item.titleHTML\"></span>\n                  <span v-else class=\"page-title\" v-text=\"item.path\"></span>\n\n                  <span v-if=\"DEBUG\">\u30DE\u30C3\u30C1\u4F4D\u7F6E\uFF1A{{item.matchedIndex}}</span>\n                </a>\n              </li>\n            </ol>\n          </div>\n        </section>\n      </div>\n    ",
        })
    ], SplashSearchBox);
    return SplashSearchBox;
}(__WEBPACK_IMPORTED_MODULE_1_vue___default.a));
/* harmony default export */ __webpack_exports__["a"] = (SplashSearchBox);
/*
    let splash = new SplashSearchBox({
        el: '#main',
    });
    console.log( splash );
*/


/***/ }),

/***/ 364:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = run;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_tslib__ = __webpack_require__(53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_tslib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_tslib__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_jquery__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_jquery___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_jquery__);


function run() {
    // 見出し表示
    var outlinePanel = new OutlinePanel();
    outlinePanel.run();
    // 総目次
    var totalContents = new TotalContents();
    totalContents.run();
    // 見出し検索
    var splashSearch = new SplashSearch();
    splashSearch.run();
    // 最上部までスクロール
    __WEBPACK_IMPORTED_MODULE_1_jquery__('[href="#?scroll-to-top"]').on('touch click', function (ev) {
        ev.preventDefault();
        __WEBPACK_IMPORTED_MODULE_1_jquery__(document).scrollTop(0);
    });
}
var MobileCommon = /** @class */ (function () {
    function MobileCommon() {
        this.preservedScrollTop = 0;
    }
    MobileCommon.prototype.run = function () {
        this.readyContent();
    };
    MobileCommon.prototype.readyContent = function () {
    };
    MobileCommon.prototype.showOverlayedContent = function () {
        this.readyDisplayingOverlay();
    };
    MobileCommon.prototype.readyDisplayingOverlay = function () {
        this.preservedScrollTop = __WEBPACK_IMPORTED_MODULE_1_jquery__(document).scrollTop();
        this.hideMainContent();
        history.pushState(null, "", null);
        __WEBPACK_IMPORTED_MODULE_1_jquery__(window).on('popstate.dispOverlayedContent', this.backOnOverlayedContentHandler.bind(this));
    };
    MobileCommon.prototype.backOnOverlayedContentHandler = function (e) {
        e.preventDefault();
        this.showMainContent();
        this.resumeBodyContents();
        __WEBPACK_IMPORTED_MODULE_1_jquery__(document).scrollTop(this.preservedScrollTop);
        __WEBPACK_IMPORTED_MODULE_1_jquery__(window).off('popstate.dispOverlayedContent');
    };
    MobileCommon.prototype.hideMainContent = function () {
        // 全部消す
        __WEBPACK_IMPORTED_MODULE_1_jquery__('#breadcrumbs').hide();
        __WEBPACK_IMPORTED_MODULE_1_jquery__('.document-title').hide();
        __WEBPACK_IMPORTED_MODULE_1_jquery__('#document-body').hide();
        __WEBPACK_IMPORTED_MODULE_1_jquery__('.page-footer').hide();
        __WEBPACK_IMPORTED_MODULE_1_jquery__('#mobile-menu').hide();
    };
    MobileCommon.prototype.showMainContent = function () {
        // 全部消す
        __WEBPACK_IMPORTED_MODULE_1_jquery__('#breadcrumbs').show();
        __WEBPACK_IMPORTED_MODULE_1_jquery__('.document-title').show();
        __WEBPACK_IMPORTED_MODULE_1_jquery__('#document-body').show();
        __WEBPACK_IMPORTED_MODULE_1_jquery__('.page-footer').show();
        __WEBPACK_IMPORTED_MODULE_1_jquery__('#mobile-menu').show();
    };
    MobileCommon.prototype.resumeBodyContents = function () {
        this.showMainContent();
    };
    MobileCommon.prototype.createCloseButton = function () {
        var closeButton = __WEBPACK_IMPORTED_MODULE_1_jquery__('<a class="close-overlayed-content" href="#?" tabindex="-1">'
            + '<span></span></a>');
        closeButton.on('click touch', function (ev) {
            ev.preventDefault();
            __WEBPACK_IMPORTED_MODULE_1_jquery__(window).trigger('popstate.dispOverlayedContent');
        });
        return closeButton;
    };
    return MobileCommon;
}());
// 見出し目次
var OutlinePanel = /** @class */ (function (_super) {
    __WEBPACK_IMPORTED_MODULE_0_tslib__["__extends"](OutlinePanel, _super);
    function OutlinePanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    OutlinePanel.prototype.readyContent = function () {
        var _this = this;
        var outlineUL = __WEBPACK_IMPORTED_MODULE_1_jquery__('#document-outline > ul').clone(true);
        var outlinePanel = __WEBPACK_IMPORTED_MODULE_1_jquery__(__WEBPACK_IMPORTED_MODULE_1_jquery__["parseHTML"]('<div></div>')[0]);
        outlinePanel.append(outlineUL);
        outlinePanel.appendTo('#outline-panel-mobile');
        this.createCloseButton().appendTo('#outline-panel-mobile');
        outlinePanel.on('touch click', 'a[href]', function (ev) {
            ev.preventDefault();
            _this.resumeBodyContents();
            var target = __WEBPACK_IMPORTED_MODULE_1_jquery__(ev.target).attr('href');
            setTimeout(function () {
                location.assign(target);
                if (/^#/.test(target)) {
                    __WEBPACK_IMPORTED_MODULE_1_jquery__(document).scrollTop(__WEBPACK_IMPORTED_MODULE_1_jquery__(target).offset().top);
                }
            }, 0);
        });
        __WEBPACK_IMPORTED_MODULE_1_jquery__('[href="#?splash-toc"]').on('touch click', function (ev) {
            ev.preventDefault();
            _this.showOverlayedContent();
        });
    };
    OutlinePanel.prototype.showOverlayedContent = function () {
        _super.prototype.showOverlayedContent.call(this);
        __WEBPACK_IMPORTED_MODULE_1_jquery__('#outline-panel-mobile').addClass('show');
    };
    OutlinePanel.prototype.resumeBodyContents = function () {
        __WEBPACK_IMPORTED_MODULE_1_jquery__('#outline-panel-mobile').removeClass('show');
        _super.prototype.resumeBodyContents.call(this);
    };
    return OutlinePanel;
}(MobileCommon));
// 総目次
var TotalContents = /** @class */ (function (_super) {
    __WEBPACK_IMPORTED_MODULE_0_tslib__["__extends"](TotalContents, _super);
    function TotalContents() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TotalContents.prototype.readyContent = function () {
        var _this = this;
        this.createCloseButton().appendTo('#outer-table-of-contents');
        __WEBPACK_IMPORTED_MODULE_1_jquery__('[href="#?grand-toc"]').on('touch click', function (ev) {
            ev.preventDefault();
            _this.showOverlayedContent();
        });
    };
    TotalContents.prototype.showOverlayedContent = function () {
        _super.prototype.showOverlayedContent.call(this);
        __WEBPACK_IMPORTED_MODULE_1_jquery__('#outer-table-of-contents').addClass('show');
    };
    TotalContents.prototype.resumeBodyContents = function () {
        __WEBPACK_IMPORTED_MODULE_1_jquery__('#outer-table-of-contents').removeClass('show');
    };
    return TotalContents;
}(MobileCommon));
// 見出し検索
var SplashSearch = /** @class */ (function (_super) {
    __WEBPACK_IMPORTED_MODULE_0_tslib__["__extends"](SplashSearch, _super);
    function SplashSearch() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SplashSearch.prototype.readyContent = function () {
        var _this = this;
        this.createCloseButton().appendTo('#splash-search-box');
        __WEBPACK_IMPORTED_MODULE_1_jquery__('[href="#?splash-search"]').on('touch click', function (ev) {
            ev.preventDefault();
            _this.showOverlayedContent();
        });
    };
    SplashSearch.prototype.showOverlayedContent = function () {
        this.readyDisplayingOverlay();
        __WEBPACK_IMPORTED_MODULE_1_jquery__('#splash-search-box').addClass('show-in-mobile');
    };
    SplashSearch.prototype.resumeBodyContents = function () {
        __WEBPACK_IMPORTED_MODULE_1_jquery__('#splash-search-box').removeClass('show-in-mobile');
    };
    return SplashSearch;
}(MobileCommon));


/***/ }),

/***/ 365:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_tslib__ = __webpack_require__(53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_tslib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_tslib__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_vue__ = __webpack_require__(37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_vue___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_vue__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_vue_class_component__ = __webpack_require__(57);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_vue_class_component___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_vue_class_component__);



//import AppGlobal from './app-global';
var tocContent = "";
var toc = document.querySelector('#document-outline > ul');
if (toc !== null) {
    tocContent = toc.outerHTML;
}
console.log(toc);
//let appGlobal = AppGlobal.instance;
var OutlinePanel = /** @class */ (function (_super) {
    __WEBPACK_IMPORTED_MODULE_0_tslib__["__extends"](OutlinePanel, _super);
    function OutlinePanel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isShowTOC = false;
        _this.tocContent = tocContent;
        return _this;
    }
    OutlinePanel.prototype.created = function () {
        //appGlobal.loadStylesheet('outline-panel');
    };
    OutlinePanel.prototype.toggleShowTOC = function () {
        this.isShowTOC =
            this.isShowTOC ? false : true;
    };
    OutlinePanel = __WEBPACK_IMPORTED_MODULE_0_tslib__["__decorate"]([
        __WEBPACK_IMPORTED_MODULE_2_vue_class_component___default()({
            template: /*html*/ "\n      <section id=\"document-outline\"\n            v-on:click=\"toggleShowTOC\"\n            v-bind:class=\"isShowTOC ? 'show' : ''\">\n        <header>T O C</header>\n        <div v-if=\"isShowTOC\"\n            id=\"outline-panel-content\"\n            v-html=\"tocContent\"></div>\n      </section>\n    "
        })
    ], OutlinePanel);
    return OutlinePanel;
}(__WEBPACK_IMPORTED_MODULE_1_vue___default.a));
/* harmony default export */ __webpack_exports__["a"] = (OutlinePanel);


/***/ }),

/***/ 366:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_tslib__ = __webpack_require__(53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_tslib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_tslib__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_jquery__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_jquery___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_jquery__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_vue__ = __webpack_require__(37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_vue___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_vue__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_vue_class_component__ = __webpack_require__(57);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_vue_class_component___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_vue_class_component__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__app_global__ = __webpack_require__(28);





var XRefNavpanel = /** @class */ (function () {
    function XRefNavpanel() {
        __WEBPACK_IMPORTED_MODULE_1_jquery__('body').append('<div id="xref-popup"></div>');
        __WEBPACK_IMPORTED_MODULE_1_jquery__(document).on("click", 'a.xref', this.openNavpanel.bind(this));
    }
    XRefNavpanel.prototype.openNavpanel = function (event) {
        var _this = this;
        // LooseText のページ情報を取得
        var pageInfo = window.loxt;
        // TODO: let pageInfo = appGlobal.pageInfo;
        // クリックされた要素を保存 // [<a>...</a>]
        var termElm = __WEBPACK_IMPORTED_MODULE_1_jquery__(event.currentTarget);
        // 要素のテキストを取得
        var termText = termElm.text();
        // タイトルからリンク先候補を取得
        var termDests = pageInfo.xref[termText];
        if (!termDests || !termDests.length) {
            console.log('"' + termText + '" の移動先がない。');
            return;
        }
        var isNormalLink = false;
        if (termDests.length == 1 // 行先が1つ
            ||
                // 行先が2つかつ、2つ目が "/path/to/term#用語"のとき
                // ex) "ゾーン":["/b1/xorn","/b1/xorn#ゾーン"]
                termDests.length == 2
                    && termDests[1] == termDests[0] + "#" + termText) {
            isNormalLink = true;
        }
        if (!isNormalLink) {
            event.preventDefault();
            if (!this.navpanel)
                this.navpanel = new XRefNavpanelView({ el: '#xref-popup' });
            this.navpanel.hidePanel();
            // クリックした要素の OFFSET 位置を取得
            var offsetTop = termElm.offset().top;
            var offsetLeft = termElm.offset().left;
            var elementHeight = termElm.height();
            this.navpanel.termText = termText;
            this.navpanel.top = offsetTop + elementHeight;
            this.navpanel.left = offsetLeft;
            this.navpanel.destinations = termDests.map(function (path) { return { path: path, title: "" }; });
            this.navpanel.targetWindow = termElm.attr("target");
            __WEBPACK_IMPORTED_MODULE_4__app_global__["default"].instance.loadTitleDic()
                .then(function () {
                for (var _i = 0, _a = _this.navpanel.destinations; _i < _a.length; _i++) {
                    var dest = _a[_i];
                    dest.title =
                        __WEBPACK_IMPORTED_MODULE_4__app_global__["default"].instance
                            .buildFactTitleHTML(dest.path, true);
                }
            });
            this.navpanel.showPanel();
            //this.titlize_wating();
            //return false;
        }
    };
    return XRefNavpanel;
}());
/* harmony default export */ __webpack_exports__["a"] = (XRefNavpanel);
var XRefNavpanelView = /** @class */ (function (_super) {
    __WEBPACK_IMPORTED_MODULE_0_tslib__["__extends"](XRefNavpanelView, _super);
    function XRefNavpanelView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.panelId = 'xref-popup';
        _this.termText = "";
        _this.destinations = [];
        _this.targetWindow = "";
        _this.style = "";
        _this.top = 0;
        _this.left = 0;
        _this.show = false;
        return _this;
    }
    Object.defineProperty(XRefNavpanelView.prototype, "styleString", {
        get: function () {
            var style = "position: absolute;";
            style += " top: " + this.top + "px;";
            if (!__WEBPACK_IMPORTED_MODULE_4__app_global__["default"].instance.isMobileMode()) {
                style += " left: " + this.left + "px";
            }
            //console.log( style );
            return style;
        },
        enumerable: true,
        configurable: true
    });
    XRefNavpanelView.prototype.hidePanel = function () {
        this.show = false;
    };
    XRefNavpanelView.prototype.showPanel = function () {
        this.show = true;
    };
    XRefNavpanelView.prototype.restructDestURL = function (path) {
        var appGlobal = __WEBPACK_IMPORTED_MODULE_4__app_global__["default"].instance;
        return appGlobal.restructURL(path);
    };
    XRefNavpanelView.prototype.removeNavpanel = function (event) {
        event.preventDefault();
        this.hidePanel();
    };
    XRefNavpanelView = __WEBPACK_IMPORTED_MODULE_0_tslib__["__decorate"]([
        __WEBPACK_IMPORTED_MODULE_3_vue_class_component___default()({
            template: /*html*/ "\n      <div id=\"xref-popup\"\n        v-bind:style=\"styleString\"\n        class=\"destnavi\"\n        v-if=\"show\"\n        >\n        <a v-for=\"dest in destinations\"\n          v-bind:href=\"restructDestURL(dest.path)\"\n          v-bind:target=\"targetWindow\"\n          class=\"destitem\">\n\n          <span v-if=\"dest.title.length\" v-html=\"dest.title\"></span>\n          <span v-else=\"dest.title.length\" v-text=\"dest.path\"></span>\n\n        </a>\n        <a href=\"#\" class=\"destnavicloser\"\n            v-on:click=\"removeNavpanel\"\n        ><span></span></a>\n      </div>\n    ",
        })
    ], XRefNavpanelView);
    return XRefNavpanelView;
}(__WEBPACK_IMPORTED_MODULE_2_vue___default.a));


/***/ }),

/***/ 367:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_jquery__);

var FootnoteTooltip = /** @class */ (function () {
    function FootnoteTooltip() {
        this._readyFootnote();
    }
    FootnoteTooltip.prototype._readyFootnote = function () {
        __WEBPACK_IMPORTED_MODULE_0_jquery__(document)
            .on("mouseover", "a.fn", this._showFootnote.bind(this))
            .on("mouseout", "a.fn", this._hideFootnote.bind(this))
            .on("mouseover", ".footnote-popup", this._remainFootnote.bind(this))
            .on("mouseout", ".footnote-popup", this._hideFootnote.bind(this));
    };
    FootnoteTooltip.prototype._showFootnote = function (e) {
        var s = __WEBPACK_IMPORTED_MODULE_0_jquery__(e.currentTarget);
        var pos = this._getPositions(s);
        var id = s.attr('href').replace(/^#/, '');
        var popup_div = __WEBPACK_IMPORTED_MODULE_0_jquery__('[id="' + id + '"]').clone();
        popup_div
            .attr('id', 'footnote-popup')
            .css('position', 'absolute')
            .css('top', pos.top + pos.height)
            .css('left', pos.left < 50 ? 0 : pos.left - 50)
            .addClass('footnote-popup');
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#document-body').append(popup_div);
    };
    FootnoteTooltip.prototype._getPositions = function (ele) {
        var t = ele.offset().top;
        var l = ele.offset().left;
        var h = ele.height();
        return { top: t, left: l, height: h };
    };
    FootnoteTooltip.prototype._remainFootnote = function (e) {
        __WEBPACK_IMPORTED_MODULE_0_jquery__(e.currentTarget).stop().fadeTo(0, 1);
    };
    FootnoteTooltip.prototype._hideFootnote = function () {
        // 全ての .footnote-popup を捕捉して削除
        __WEBPACK_IMPORTED_MODULE_0_jquery__('.footnote-popup').fadeOut("normal", function () { __WEBPACK_IMPORTED_MODULE_0_jquery__(this).remove(); });
    };
    return FootnoteTooltip;
}());
/* harmony default export */ __webpack_exports__["a"] = (FootnoteTooltip);


/***/ }),

/***/ 368:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_jquery__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__app_global__ = __webpack_require__(28);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__attach_data__ = __webpack_require__(47);



var appGlobal = __WEBPACK_IMPORTED_MODULE_1__app_global__["default"].instance;
var ImageInjector = /** @class */ (function () {
    function ImageInjector() {
        this.beginProc();
    }
    ImageInjector.prototype.beginProc = function () {
        var _this = this;
        var path = appGlobal.pageInfo.document_path;
        // 参照用データを取得
        Object(__WEBPACK_IMPORTED_MODULE_2__attach_data__["default"])(appGlobal.additionalImageFiles)
            .then(function (imageDics) {
            var imageDic = Object.assign.apply({}, imageDics);
            if (typeof imageDic !== 'undefined' && imageDic[path]) {
                _this.injectImages(imageDic[path]);
            }
        });
    };
    ImageInjector.prototype.injectImages = function (imageMaps) {
        for (var _i = 0, imageMaps_1 = imageMaps; _i < imageMaps_1.length; _i++) {
            var info = imageMaps_1[_i];
            this.insertImage(info.query, info.src);
        }
    };
    ImageInjector.prototype.insertImage = function (_query, _src) {
        var targetNode;
        var mainDocument = document.getElementById('document-body');
        if (!(mainDocument instanceof HTMLElement))
            return;
        // XPATH
        if (/^\.\/|^\//.test(_query)) {
            var _node = this.findSingleNode(_query);
            if (!(_node instanceof HTMLElement))
                return;
            targetNode = _node;
        }
        else {
            targetNode = __WEBPACK_IMPORTED_MODULE_0_jquery__(_query, mainDocument).get(0);
            if (!(targetNode instanceof HTMLElement))
                return;
        }
        var pathToRoot = appGlobal.pathToRoot;
        __WEBPACK_IMPORTED_MODULE_0_jquery__(targetNode)
            .after(''
            + ("<a href=\"" + pathToRoot + _src + "\" class=\"adding-image-link\">")
            + ("<img src=\"" + pathToRoot + _src + "\" class=\"adding-image\"/>")
            + '</a>');
    };
    ImageInjector.prototype.findSingleNode = function (xpath) {
        var mainDocument = document.getElementById('document-body');
        if (!(mainDocument instanceof HTMLElement))
            throw new Error(mainDocument + " isn't HTMLElement");
        // XXX: IE11 では document.evaluate がないため動かない
        var _node = document.evaluate(xpath, mainDocument, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
        if (!(_node instanceof HTMLElement))
            return null;
        return _node;
    };
    return ImageInjector;
}());
/* harmony default export */ __webpack_exports__["a"] = (ImageInjector);


/***/ }),

/***/ 369:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__app_global__ = __webpack_require__(28);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common__ = __webpack_require__(141);


var appGlobal = __WEBPACK_IMPORTED_MODULE_0__app_global__["default"].instance;
//interface SpecialModule {
//    default: SpecialScriptInvoker;
//}
var AffairLoader = /** @class */ (function () {
    function AffairLoader() {
    }
    AffairLoader.prototype.run = function () {
        this.loadSpecailScript();
    };
    AffairLoader.prototype.loadSpecailScript = function () {
        var pagePath = appGlobal.pageInfo.document_path;
        var pathToRoot = appGlobal.pathToRoot;
        for (var _i = 0, _a = appGlobal.specialScripts; _i < _a.length; _i++) {
            var setting = _a[_i];
            var isRunable = false;
            var path = setting.path;
            if (path instanceof RegExp) {
                isRunable = path.test(pagePath);
            }
            else {
                path = Object(__WEBPACK_IMPORTED_MODULE_1__common__["wildcard"])(path);
                isRunable = path.test(pagePath);
            }
            if (!isRunable)
                continue;
            var src = setting.script;
            //if ( typeof define === "function" && define.amd )
            //    eval("require([src]);");
            var isInRequireJS = eval('typeof define === "function" && define.amd');
            if (isInRequireJS) {
                eval("require([src]);");
            }
            else {
                var scriptExtension = ".bnd.js";
                src = pathToRoot + "/" + src + scriptExtension;
                this.appendScriptTag(src);
            }
        }
    };
    AffairLoader.prototype.appendScriptTag = function (src) {
        var heads = document.getElementsByTagName('head');
        if (heads === null)
            throw new Error("Cannot find 'head' element.");
        var head = heads[0];
        var scriptTag = this.createScriptTag(src);
        head.appendChild(scriptTag);
        return scriptTag;
    };
    AffairLoader.prototype.createScriptTag = function (src) {
        var scriptTag = document.createElement('script');
        scriptTag.setAttribute('src', src);
        return scriptTag;
    };
    return AffairLoader;
}());
/* harmony default export */ __webpack_exports__["a"] = (AffairLoader);


/***/ }),

/***/ 370:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_jquery__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__app_global__ = __webpack_require__(28);


var appGlobal = __WEBPACK_IMPORTED_MODULE_1__app_global__["default"].instance;
var FlattenableContent = /** @class */ (function () {
    function FlattenableContent() {
        this.openedAsDefault = window.appConfig.flattenableContentOpenAsDefault;
        this.flattenableContentSelector
            = appGlobal.flattenableContentSelector;
    }
    FlattenableContent.prototype.run = function () {
        var _this = this;
        var $flattenables = __WEBPACK_IMPORTED_MODULE_0_jquery__(this.flattenableContentSelector).not('table');
        $flattenables = $flattenables.wrap('<div class="flattenable">').parent();
        var $flattenButton = __WEBPACK_IMPORTED_MODULE_0_jquery__(this.createFlattenButton(true));
        $flattenButton.on('click', function (ev) {
            var elm = __WEBPACK_IMPORTED_MODULE_0_jquery__(ev.target).parent().get(0);
            _this.flattenBlock(elm);
        });
        $flattenables.prepend($flattenButton);
        if (!this.openedAsDefault) {
            $flattenables.each(function (_i, item) {
                _this.flattenBlock(item);
            });
        }
        if ($flattenables.length) {
            this.addAllFlatteningButton();
        }
    };
    FlattenableContent.prototype.flattenBlock = function (elm) {
        var $flattenable = __WEBPACK_IMPORTED_MODULE_0_jquery__(elm);
        $flattenable.hide();
        var $flattenedDummy = __WEBPACK_IMPORTED_MODULE_0_jquery__('<div>', { class: 'flattenable-flattened' });
        var $flattenButton = __WEBPACK_IMPORTED_MODULE_0_jquery__(this.createFlattenButton(false));
        $flattenButton.on('click', function (ev) {
            var $elm = __WEBPACK_IMPORTED_MODULE_0_jquery__(ev.target).closest('.flattenable-flattened');
            $elm.prev().show();
            $elm.remove();
        });
        $flattenedDummy.append($flattenButton);
        $flattenedDummy.insertAfter($flattenable);
    };
    FlattenableContent.prototype.addAllFlatteningButton = function () {
        var $flatteningAll = __WEBPACK_IMPORTED_MODULE_0_jquery__('<div>', {
            id: 'flattening-all',
            'data-do-flatten': (this.openedAsDefault ? 'true' : '')
        });
        __WEBPACK_IMPORTED_MODULE_0_jquery__('#codxx-function-slot').append($flatteningAll);
        $flatteningAll.on('click', function () {
            var doFlatten = $flatteningAll.attr('data-do-flatten');
            if (doFlatten) {
                __WEBPACK_IMPORTED_MODULE_0_jquery__('#document-body')
                    .find('.flattening-opened:visible').click();
                $flatteningAll.attr('data-do-flatten', '');
            }
            else {
                __WEBPACK_IMPORTED_MODULE_0_jquery__('#document-body')
                    .find('.flattening-closed:visible').click();
                $flatteningAll.attr('data-do-flatten', 'true');
            }
        });
    };
    FlattenableContent.prototype.createFlattenButton = function (isOpened) {
        var html = '<span class="flattening-button '
            + 'flattening-'
            + (isOpened ? 'opened' : 'closed')
            + '">'
            + appGlobal.flattenableContentSigil
            + '</span>';
        return __WEBPACK_IMPORTED_MODULE_0_jquery__(html).get(0);
    };
    return FlattenableContent;
}());
/* harmony default export */ __webpack_exports__["a"] = (FlattenableContent);


/***/ }),

/***/ 371:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_jquery__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__app_global__ = __webpack_require__(28);


var appGlobal = __WEBPACK_IMPORTED_MODULE_1__app_global__["default"].instance;
var selectors = [
    '#document-body h1.dest[id]',
    '#document-body h2.dest[id]',
    '#document-body h3.dest[id]',
    '#document-body h4.dest[id]',
    '#document-body h5.dest[id]',
    '#document-body h6.dest[id]',
    '#document-body header.dest[id]',
    '#document-body .table-outer.dest[id]',
    '#document-body p.dest[id]',
    '#document-body dt.dest[id]',
];
var selector = selectors.join(',');
var anchorCopyerTitle = "\u30AF\u30EA\u30C3\u30AF\u3067\u4E0B\u8A18WEB\u7248\u306EURL\u3092\u30AF\u30EA\u30C3\u30D7\u30DC\u30FC\u30C9\u306B\u30B3\u30D4\u30FC\n*URL*\nWEB\u7248\u306E\u66F4\u65B0\u6642\u671F\u306B\u3088\u308A\u6709\u52B9\u306AURL\u3067\u306A\u3044\u5834\u5408\u6709\u308A";
var btnHTMLCode = "<div class=\"copy-anchor-place\">"
    + ("<span class=\"btn-copy-anchor\" title=\"" + anchorCopyerTitle + "\"></span>")
    + "</div>";
var fareaHTMLCode = "<div id=\"copying-text-area\">"
    + "<span>URL\u30B3\u30D4\u30FC\u6E08\uFF1A</span>"
    + "<input type=\"text\" id=\"copying-text\" />"
    + "<span id=\"btn-close-copying\"></span>"
    + "</div>";
function createHTML(str) {
    var elementList = [];
    var nodes = __WEBPACK_IMPORTED_MODULE_0_jquery__["parseHTML"](str.replace(/^\s*/mg, ''));
    nodes.forEach(function (n) {
        if (n instanceof HTMLElement)
            elementList.push(n);
    });
    return elementList;
}
var AnchorCopyer = /** @class */ (function () {
    function AnchorCopyer() {
        this.urlBase = appGlobal.anchorCopyerBaseURL;
        if (appGlobal.isEnabledAnchorCopyer) {
            this.readyBtn();
            this.attachCopyBtn();
            console.log('AnchorCopyer START');
        }
    }
    AnchorCopyer.prototype.readyBtn = function () {
        var btnNodeBase = __WEBPACK_IMPORTED_MODULE_0_jquery__["parseHTML"](btnHTMLCode)[0];
        if (btnNodeBase instanceof HTMLElement)
            this.btnNodeBase = btnNodeBase;
    };
    AnchorCopyer.prototype.attachCopyBtn = function () {
        var _this = this;
        var nlist = document.querySelectorAll(selector);
        var list = Array.from(nlist);
        list.forEach(function (n) {
            var btnPlace = _this.btnNodeBase.cloneNode(true);
            n.insertBefore(btnPlace, n.firstChild);
            btnPlace.firstChild
                .addEventListener('click', _this.copyURL.bind(_this));
            btnPlace.firstChild
                .addEventListener('mouseenter', _this.modifyTitleAttr.bind(_this), { once: true, });
        });
    };
    AnchorCopyer.prototype.modifyTitleAttr = function (ev) {
        var btn = ev.currentTarget;
        var para = btn.parentNode.parentNode;
        var title = btn.getAttribute('title');
        var url = this.fabricateURL(para.id);
        title = title.replace(/\*URL\*/, "<" + url + ">");
        btn.setAttribute('title', title);
    };
    AnchorCopyer.prototype.copyURL = function (ev) {
        var btn = ev.currentTarget;
        var btnPlace = btn.parentNode;
        var para = btnPlace.parentNode;
        var urlStr = this.fabricateURL(para.id);
        // 以前のものがあれば削除
        var prevBtn = document.getElementById('copying-text-area');
        if (prevBtn) {
            prevBtn.parentNode.removeChild(prevBtn);
        }
        var farea = createHTML(fareaHTMLCode)[0];
        var input = farea.querySelector('input');
        input.value = urlStr;
        btnPlace.appendChild(farea);
        input.select();
        document.execCommand('copy');
        var closer = input.nextSibling;
        closer.addEventListener('click', function () {
            __WEBPACK_IMPORTED_MODULE_0_jquery__(farea).remove();
        });
        // ちょっと待って削除
        __WEBPACK_IMPORTED_MODULE_0_jquery__(farea)
            .delay(3000)
            .fadeOut({ duration: 2000 })
            .queue(function () {
            this.remove();
        });
    };
    AnchorCopyer.prototype.fabricateURL = function (id) {
        var docPath = document.body.dataset.documentPath;
        var fragment = id.replace(/ /g, '%20');
        var urlStr = "" + this.urlBase + docPath + ".html#" + fragment;
        return urlStr;
    };
    return AnchorCopyer;
}());
/* harmony default export */ __webpack_exports__["a"] = (AnchorCopyer);


/***/ }),

/***/ 53:
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Promise, global) {var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
/* global global, define, System, Reflect, Promise */
var __extends;
var __assign;
var __rest;
var __decorate;
var __param;
var __metadata;
var __awaiter;
var __generator;
var __exportStar;
var __values;
var __read;
var __spread;
var __asyncGenerator;
var __asyncDelegator;
var __asyncValues;
(function (factory) {
    var root = typeof global === "object" ? global : typeof self === "object" ? self : typeof this === "object" ? this : {};
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports], __WEBPACK_AMD_DEFINE_RESULT__ = (function (exports) { factory(createExporter(root, createExporter(exports))); }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    }
    else if (typeof module === "object" && typeof module.exports === "object") {
        factory(createExporter(root, createExporter(module.exports)));
    }
    else {
        factory(createExporter(root));
    }
    function createExporter(exports, previous) {
        return function (id, v) { return exports[id] = previous ? previous(id, v) : v; };
    }
})
(function (exporter) {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };

    __extends = function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };

    __assign = Object.assign || function (t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };

    __rest = function (s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
                t[p[i]] = s[p[i]];
        return t;
    };

    __decorate = function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };

    __param = function (paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); }
    };

    __metadata = function (metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
    };

    __awaiter = function (thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    };

    __generator = function (thisArg, body) {
        var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_) try {
                if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
                if (y = 0, t) op = [0, t.value];
                switch (op[0]) {
                    case 0: case 1: t = op; break;
                    case 4: _.label++; return { value: op[1], done: false };
                    case 5: _.label++; y = op[1]; op = [0]; continue;
                    case 7: op = _.ops.pop(); _.trys.pop(); continue;
                    default:
                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                        if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                        if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                        if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                        if (t[2]) _.ops.pop();
                        _.trys.pop(); continue;
                }
                op = body.call(thisArg, _);
            } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
            if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
        }
    };

    __exportStar = function (m, exports) {
        for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
    };

    __values = function (o) {
        var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
        if (m) return m.call(o);
        return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
    };

    __read = function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m) return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
        }
        catch (error) { e = { error: error }; }
        finally {
            try {
                if (r && !r.done && (m = i["return"])) m.call(i);
            }
            finally { if (e) throw e.error; }
        }
        return ar;
    };

    __spread = function () {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    };

    __asyncGenerator = function (thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), q = [], c, i;
        return i = { next: verb("next"), "throw": verb("throw"), "return": verb("return") }, i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) { return function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]), next(); }); }; }
        function next() { if (!c && q.length) resume((c = q.shift())[0], c[1]); }
        function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(c[3], e); } }
        function step(r) { r.done ? settle(c[2], r) : r.value[0] === "yield" ? settle(c[2], { value: r.value[1], done: false }) : Promise.resolve(r.value[1]).then(r.value[0] === "delegate" ? delegate : fulfill, reject); }
        function delegate(r) { step(r.done ? r : { value: ["yield", r.value], done: false }); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) { c = void 0, f(v), next(); }
    };

    __asyncDelegator = function (o) {
        var i = { next: verb("next"), "throw": verb("throw", function (e) { throw e; }), "return": verb("return", function (v) { return { value: v, done: true }; }) };
        return o = __asyncValues(o), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { return function (v) { return { value: ["delegate", (o[n] || f).call(o, v)], done: false }; }; }
    };

    __asyncValues = function (o) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator];
        return m ? m.call(o) : typeof __values === "function" ? __values(o) : o[Symbol.iterator]();
    };

    exporter("__extends", __extends);
    exporter("__assign", __assign);
    exporter("__rest", __rest);
    exporter("__decorate", __decorate);
    exporter("__param", __param);
    exporter("__metadata", __metadata);
    exporter("__awaiter", __awaiter);
    exporter("__generator", __generator);
    exporter("__exportStar", __exportStar);
    exporter("__values", __values);
    exporter("__read", __read);
    exporter("__spread", __spread);
    exporter("__asyncGenerator", __asyncGenerator);
    exporter("__asyncDelegator", __asyncDelegator);
    exporter("__asyncValues", __asyncValues);
});
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(48), __webpack_require__(60)))

/***/ }),

/***/ 57:
/***/ (function(module, exports, __webpack_require__) {

/**
  * vue-class-component v5.0.1
  * (c) 2015-2017 Evan You
  * @license MIT
  */
(function (global, factory) {
	 true ? factory(exports, __webpack_require__(37)) :
	typeof define === 'function' && define.amd ? define(['exports', 'vue'], factory) :
	(factory((global.VueClassComponent = global.VueClassComponent || {}),global.Vue));
}(this, (function (exports,Vue) { 'use strict';

Vue = 'default' in Vue ? Vue['default'] : Vue;

function createDecorator(factory) {
    return function (_, key, index) {
        if (typeof index !== 'number') {
            index = undefined;
        }
        $decoratorQueue.push(function (options) { return factory(options, key, index); });
    };
}
function warn(message) {
    if (typeof console !== 'undefined') {
        console.warn('[vue-class-component] ' + message);
    }
}

function collectDataFromConstructor(vm, Component) {
    Component.prototype._init = function () {
        var _this = this;
        var keys = Object.getOwnPropertyNames(vm);
        if (vm.$options.props) {
            for (var key in vm.$options.props) {
                if (!vm.hasOwnProperty(key)) {
                    keys.push(key);
                }
            }
        }
        keys.forEach(function (key) {
            if (key.charAt(0) !== '_') {
                Object.defineProperty(_this, key, {
                    get: function () { return vm[key]; },
                    set: function (value) { return vm[key] = value; }
                });
            }
        });
    };
    var data = new Component();
    var plainData = {};
    Object.keys(data).forEach(function (key) {
        if (data[key] !== undefined) {
            plainData[key] = data[key];
        }
    });
    {
        if (!(Component.prototype instanceof Vue) && Object.keys(plainData).length > 0) {
            warn('Component class must inherit Vue or its descendant class ' +
                'when class property is used.');
        }
    }
    return plainData;
}

var $internalHooks = [
    'data',
    'beforeCreate',
    'created',
    'beforeMount',
    'mounted',
    'beforeDestroy',
    'destroyed',
    'beforeUpdate',
    'updated',
    'activated',
    'deactivated',
    'render'
];
var $decoratorQueue = [];
function componentFactory(Component, options) {
    if (options === void 0) { options = {}; }
    options.name = options.name || Component._componentTag || Component.name;
    var proto = Component.prototype;
    Object.getOwnPropertyNames(proto).forEach(function (key) {
        if (key === 'constructor') {
            return;
        }
        if ($internalHooks.indexOf(key) > -1) {
            options[key] = proto[key];
            return;
        }
        var descriptor = Object.getOwnPropertyDescriptor(proto, key);
        if (typeof descriptor.value === 'function') {
            (options.methods || (options.methods = {}))[key] = descriptor.value;
        }
        else if (descriptor.get || descriptor.set) {
            (options.computed || (options.computed = {}))[key] = {
                get: descriptor.get,
                set: descriptor.set
            };
        }
    });
    (options.mixins || (options.mixins = [])).push({
        data: function () {
            return collectDataFromConstructor(this, Component);
        }
    });
    $decoratorQueue.forEach(function (fn) { return fn(options); });
    $decoratorQueue = [];
    var superProto = Object.getPrototypeOf(Component.prototype);
    var Super = superProto instanceof Vue
        ? superProto.constructor
        : Vue;
    return Super.extend(options);
}

function Component(options) {
    if (typeof options === 'function') {
        return componentFactory(options);
    }
    return function (Component) {
        return componentFactory(Component, options);
    };
}
(function (Component) {
    function registerHooks(keys) {
        $internalHooks.push.apply($internalHooks, keys);
    }
    Component.registerHooks = registerHooks;
})(Component || (Component = {}));
var Component$1 = Component;

exports['default'] = Component$1;
exports.createDecorator = createDecorator;

Object.defineProperty(exports, '__esModule', { value: true });

})));


/***/ }),

/***/ 58:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = makeSearchPattern;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_fhconvert__ = __webpack_require__(59);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_fhconvert___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_fhconvert__);

var malleableKanaPatternTable = {
    "ア": "[ァア]",
    "イ": "[ィイ]",
    "ウ": "[ゥウ]",
    "エ": "[ェエ]",
    "オ": "[ォオ]",
    "ヤ": "[ャヤ]",
    "ユ": "[ュユ]",
    "ヨ": "[ョヨ]",
    "ァ": "[ァア]",
    "ィ": "[ィイ]",
    "ゥ": "[ゥウ]",
    "ェ": "[ェエ]",
    "ォ": "[ォオ]",
    "ャ": "[ャヤ]",
    "ュ": "[ュユ]",
    "ョ": "[ョヨ]",
    "ツ": "[ッツ]",
    "ッ": "[ッツ]",
    "ジ": "[ジヂ]",
    "ズ": "[ズヅ]",
    "ヂ": "[ジヂ]",
    "ヅ": "[ズヅ]",
    "バ": "(?:ヴァ|バ)",
    "ビ": "(?:ヴィ|ビ)",
    "ブ": "[ヴブ]",
    "ベ": "(?:ヴェ|ベ)",
    "ボ": "(?:ヴォ|ボ)",
    "ヴァ": "(?:ヴァ|バ)",
    "ヴィ": "(?:ヴィ|ビ)",
    "ヴェ": "(?:ヴェ|ベ)",
    "ヴォ": "(?:ヴォ|ボ)",
    "ヴ": "[ヴブ]",
    "ヒュ": "[ヒフ][ユュ]",
    "フュ": "[ヒフ][ユュ]",
};
var vowelDerivingTable = {
    "ア": new RegExp("[ァアカガサザタダナハバパマラャヤワ]"),
    "イ": new RegExp("[ィイキギシジチヂニヒビピミリ]"),
    "ウ": new RegExp("[ゥウクグスズツヅヌフブプムルュユヴ]"),
    "エ": new RegExp("[ェエケゲセゼテデネヘベペメレ]"),
    "オ": new RegExp("[ォオコゴソゾトドノホボポモロョヨヲ]")
};
var prolongPatternTable = {
    "ア": "[ァアー]",
    "イ": "[ィイー]",
    "ウ": "[ゥウー]",
    "エ": "[ェエー]",
    "オ": "[ォオー]",
    "オー": "[ウゥオォー]",
    "エー": "[イィエェー]",
};
// テキストからパターンを作る
function makeSearchPattern(_queryText) {
    // ひらがなをカタカナに変換
    var queryText = __WEBPACK_IMPORTED_MODULE_0_fhconvert__["hgtokk"](_queryText);
    // パターン作成
    var seq = queryText.match(/ヴ[ァィェォ]|[ヒフ]ュ|./g);
    if (!seq) {
        seq = [];
    }
    ;
    var searchRegexpSeeds = [];
    var vowels = []; // 母音
    seq.forEach(function (_charUnit, idx) {
        var charUnit = "" + _charUnit;
        var matched = charUnit.match(/(.)$/);
        if (!matched)
            matched = [""];
        var lastChar = matched[0];
        var vowel = "";
        vowels[idx] = "";
        // 母音抽出
        Object.keys(vowelDerivingTable)
            .forEach(function (vowelKey) {
            var pattern = vowelDerivingTable[vowelKey];
            if (lastChar.match(pattern)) {
                vowel = vowelKey;
                vowels[idx] = vowel;
                return false;
            }
            return true;
        });
        // 長音のパターンを作成
        var prolongPattern = "";
        var prevVowel = vowels[idx - 1];
        if (charUnit.match(/^[アイウエオァィゥェォー]$/) && prevVowel) {
            // 今が長音の場合
            if (charUnit == "ー") {
                prolongPattern = prolongPatternTable[prevVowel + "ー"] || prolongPatternTable[prevVowel];
            }
            else if (prevVowel === vowel) {
                prolongPattern = prolongPatternTable[vowel];
            }
            else if (prevVowel === "オ" && vowel === "ウ") {
                prolongPattern = "[オォウゥー]";
            }
            else if (prevVowel === "エ" && vowel === "イ") {
                prolongPattern = "[エェイィー]";
            }
        }
        if (prolongPattern) {
            searchRegexpSeeds.push(prolongPattern);
        }
        else {
            // 特定のカナのパターン
            var kanaPattern = malleableKanaPatternTable[charUnit];
            if (kanaPattern) {
                searchRegexpSeeds.push(kanaPattern);
            }
            else {
                var bs = String.fromCharCode(92); // バックスラッシュ
                var unsafe = bs + ".+*?[^]$(){}=!<>¦|:";
                var safesearch = charUnit;
                var i = void 0;
                for (i = 0; i < unsafe.length; ++i) {
                    safesearch = safesearch.replace(new RegExp("\\" + unsafe.charAt(i), "g"), bs + unsafe.charAt(i));
                }
                searchRegexpSeeds.push(safesearch);
            }
        }
    });
    // ひらがなとカタカナのパターンを混合
    // ( (?: kata ) | (?: hira ) )
    searchRegexpSeeds.forEach(function (v, idx) {
        var pattern = "";
        var hiragana = __WEBPACK_IMPORTED_MODULE_0_fhconvert__["kktohg"](v);
        if (v !== hiragana) {
            if (v.length === 1) {
                pattern = "[" + v + hiragana + "]";
            }
            else {
                var pat_katakana = v;
                var pat_hirakana = hiragana;
                pattern = "(?:" + pat_katakana + "|" + pat_hirakana + ")";
            }
        }
        else {
            pattern = v;
        }
        searchRegexpSeeds[idx] = pattern;
    });
    // 各単位ごとに .? を挟んでパターンを作る
    var pattern = new RegExp(searchRegexpSeeds.join(".?"), "i");
    return pattern;
}


/***/ })

},[362]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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